/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.simplegrille.smgrimpl;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.desmodo.simplegrille.api.SimpleAtlas;
import net.desmodo.simplegrille.api.SimpleAtlasBuilder;
import net.desmodo.simplegrille.api.SimpleContexte;
import net.desmodo.simplegrille.api.SimpleDescripteurPere;
import net.desmodo.simplegrille.api.SimpleStructure;
import net.desmodo.simplegrille.smgrimpl.LangAccoladeArgument;
import net.desmodo.simplegrille.smgrimpl.SimpleAtlasImpl;
import net.desmodo.simplegrille.smgrimpl.SimpleDescripteurFilsImpl;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.AccoladeArgument;
import net.mapeadores.util.text.AccoladeArgumentFactory;
import net.mapeadores.util.text.AccoladePattern;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.xml.InvalidXMLException;

public class SimpleAtlasBuilderImpl
implements SimpleAtlasBuilder {
    private final List<TermBuilder> descripteurList = new ArrayList<TermBuilder>();
    private final SimpleStructure simpleStructure;
    private final Map<String, TermBuilder> descripteurMap = new HashMap<String, TermBuilder>();
    private final UiPatternArgumentFactory uiPatternArgumentFactory = new UiPatternArgumentFactory();
    private final Map<Lang, Label> libelleMap = new HashMap<Lang, Label>();
    private String prefixe;
    private int autoIncrement = 1;
    private AccoladePattern uiPattern = null;
    private String uiPatternString = null;

    public SimpleAtlasBuilderImpl(SimpleStructure simpleStructure) {
        this.simpleStructure = simpleStructure;
    }

    @Override
    public int addSimpleDescripteurFils(String iddesc, String pereIddesc, String idctxt) {
        TermBuilder termBuilder = this.descripteurMap.get(iddesc);
        if (termBuilder == null) {
            SimpleDescripteurPere simpleDescripteurPere = this.simpleStructure.getSimpleDescripteurPere(pereIddesc);
            if (simpleDescripteurPere == null) {
                return -1;
            }
            SimpleContexte simpleContexte = simpleDescripteurPere.getSimpleContexteList().getSimpleContexte(idctxt);
            if (simpleContexte == null) {
                return -1;
            }
            termBuilder = new TermBuilder(this.descripteurList.size(), iddesc, simpleContexte, simpleDescripteurPere);
            this.descripteurList.add(termBuilder);
            this.descripteurMap.put(iddesc, termBuilder);
            try {
                int val = Integer.parseInt(iddesc);
                if (val >= this.autoIncrement) {
                    this.autoIncrement = val + 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return termBuilder.getIndex();
    }

    @Override
    public void putDescripteurFilsLibelle(int index, Label libelle) {
        TermBuilder termBuilder = this.descripteurList.get(index);
        termBuilder.putLibelle(libelle);
    }

    public void setPrefixe(String prefixe) {
        if (prefixe != null && (prefixe = prefixe.trim()).length() == 0) {
            prefixe = null;
        }
        this.prefixe = prefixe;
    }

    public void setUiPattern(String uiPatternString) {
        this.uiPattern = null;
        this.uiPatternString = null;
        if (uiPatternString != null && (uiPatternString = uiPatternString.trim()).length() > 0) {
            this.uiPatternString = uiPatternString;
            try {
                this.uiPattern = new AccoladePattern(uiPatternString, (AccoladeArgumentFactory)this.uiPatternArgumentFactory);
            }
            catch (ParseException pe) {
                this.uiPattern = AccoladePattern.getNoArgumentPattern((String)"#ERROR: ", (String)uiPatternString);
            }
        }
    }

    @Override
    public void setAutoIncrement(int val) {
        if (val > this.autoIncrement) {
            this.autoIncrement = val;
        }
    }

    @Override
    public void putAtlasLibelle(Label libelle) {
        this.libelleMap.put(libelle.getLang(), libelle);
    }

    public SimpleAtlas toSimpleAtlas() {
        if (this.prefixe == null) {
            throw new InvalidXMLException("missing prefix element in simple-grille");
        }
        ArrayList<SimpleDescripteurFilsImpl> result = new ArrayList<SimpleDescripteurFilsImpl>();
        for (TermBuilder termeBuilder : this.descripteurList) {
            SimpleDescripteurFilsImpl sdf = new SimpleDescripteurFilsImpl(termeBuilder.id, termeBuilder.simpleDescripteurPere, termeBuilder.simpleContexte, termeBuilder.libelleMap);
            result.add(sdf);
        }
        if (this.uiPattern == null) {
            Lang defaultLang = (Lang)this.simpleStructure.getLangs().get(0);
            try {
                this.uiPattern = new AccoladePattern("{" + defaultLang.toString() + "}", (AccoladeArgumentFactory)this.uiPatternArgumentFactory);
            }
            catch (ParseException pe) {
                throw new ShouldNotOccurException((Exception)pe);
            }
        }
        return new SimpleAtlasImpl(this.simpleStructure, this.prefixe, this.autoIncrement, result, this.uiPattern, this.uiPatternString, this.libelleMap);
    }

    private static class UiPatternArgumentFactory
    implements AccoladeArgumentFactory {
        private UiPatternArgumentFactory() {
        }

        public AccoladeArgument getAccoladeArgument(String name, String mode) {
            try {
                Lang langInteger = Lang.parse((String)name);
                return new LangAccoladeArgument(langInteger);
            }
            catch (ParseException pe) {
                return null;
            }
        }
    }

    private class TermBuilder {
        private final Map<Lang, Label> libelleMap = new HashMap<Lang, Label>();
        private final int index;
        private final String id;
        private final SimpleContexte simpleContexte;
        private final SimpleDescripteurPere simpleDescripteurPere;

        private TermBuilder(int index, String id, SimpleContexte simpleContexte, SimpleDescripteurPere simpleDescripteurPere) {
            this.index = index;
            this.id = id;
            this.simpleContexte = simpleContexte;
            this.simpleDescripteurPere = simpleDescripteurPere;
        }

        public int getIndex() {
            return this.index;
        }

        private void putLibelle(Label libelle) {
            this.libelleMap.put(libelle.getLang(), libelle);
        }
    }
}

