/* global Fapi,ScarabeApi */

ScarabeApi.Cache = {};

/**
 * 
 * @param {Fapi} fapi
 * @param {Fapi.Cache.Thesaurus} thesaurus
 * @param {Object} options
 * @returns {Function}
 */
ScarabeApi.Cache.attachRecap = function (fapi, thesaurus, options) {
    var requestParameters = {
        subset: "thesaurus_" + thesaurus.getName()
    };
    if (options) {
        if (options.propertiesMapping) {
            requestParameters.tableexport = options.propertiesMapping;
        }
        if (options.requestParameters) {
            for(let parameter in options.requestParameters) {
                requestParameters[parameter] = options.requestParameters[parameter];
            }
        }
    }
    return function(callback) {
        ScarabeApi.Ajax.loadAnalytiqueRecap(fapi, {
            requestParameters: requestParameters,
            callback: function (data) {
                thesaurus.analytiqueRecap = data.analytiqueRecap;
                _attach(data.analytiqueRecap.subArray, thesaurus);
                if (callback) {
                    callback();
                }
            }
        });
    };


    function _attach(subrecapArray, thesaurus) {
        for(let subrecap of subrecapArray) {
            let motcle = thesaurus.getMotcleById(subrecap.id);
            if (motcle) {
                motcle.analytiqueRecap = subrecap;
            }
            _attach(subrecap.subArray, thesaurus);
        }
    }
    
};

/**
 * 
 * @param {Fapi} fapi
 * @param {Fapi.Cache.Thesaurus} thesaurus
 * @param {Object} options
 * @returns {Function}
 */
ScarabeApi.Cache.attachDetails = function (fapi, thesaurus, options) {
    var requestParameters = {
        subset: "thesaurus_" + thesaurus.getName(),
        withrecap: 0,
        recursive: 1
    };
    if (options) {
        if (options.propertiesMapping) {
            requestParameters.tableexport = options.propertiesMapping;
        }
        if (options.requestParameters) {
            for(let parameter in options.requestParameters) {
                requestParameters[parameter] = options.requestParameters[parameter];
            }
        }
    }
    return function(callback) {
        ScarabeApi.Ajax.loadAnalytiqueDetails(fapi, {
            requestParameters: requestParameters,
            callback: function (data) {
                thesaurus.analytiqueDetails = data.analytiqueDetails;
                _attach(data.analytiqueDetails.array, thesaurus);
                if (callback) {
                    callback();
                }
            }
        });
    };


    function _attach(subdetailArray, thesaurus) {
        for(let subdetail of subdetailArray) {
            let motcle = thesaurus.getMotcleById(subdetail.item.id);
            if (motcle) {
                motcle.analytiqueDetail = subdetail;
            }
            _attach(subdetail.subArray, thesaurus);
        }
    }
    
};

