/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.core;

import fr.exemole.bdfext.scarabe.api.core.AvanceInfo;
import fr.exemole.bdfext.scarabe.api.core.Avenir;
import fr.exemole.bdfext.scarabe.api.core.Ligne;
import fr.exemole.bdfext.scarabe.api.core.Mouvement;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.alias.AliasChecker;
import net.fichotheque.alias.AliasHolder;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.Item;
import net.fichotheque.corpus.fiche.PersonItem;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.croisement.Liaison;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.tools.alias.AliasUtils;
import net.fichotheque.utils.SphereUtils;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.models.PersonCore;

public class CoreUtils {
    public static final AliasChecker CORE_ALIASCHECKER = new CoreAliasChecker();
    public static final List<Mouvement> EMPTY_MOUVEMENTLIST = Collections.emptyList();
    public static final List<Ligne> EMPTY_LIGNELIST = Collections.emptyList();
    public static final List<Avenir> EMPTY_AVENIRLIST = Collections.emptyList();
    public static final List<AvanceInfo.DepenseInfo> EMPTY_DEPENSEINFOLIST = Collections.emptyList();

    private CoreUtils() {
    }

    public static CorpusField getBeneficiaire(AliasHolder aliasHolder, String corpusAlias) {
        if (corpusAlias.equals("mouvement")) {
            return aliasHolder.getCorpusField("mouvement_beneficiaire");
        }
        if (corpusAlias.equals("depense")) {
            return aliasHolder.getCorpusField("depense_beneficiaire");
        }
        if (corpusAlias.equals("apport")) {
            return aliasHolder.getCorpusField("apport_beneficiaire");
        }
        if (corpusAlias.equals("avance")) {
            return aliasHolder.getCorpusField("avance_beneficiaire");
        }
        return null;
    }

    public static CorpusField getDate(AliasHolder aliasHolder, String corpusAlias) {
        if (corpusAlias.equals("mouvement")) {
            return aliasHolder.getCorpusField("mouvement_date");
        }
        if (corpusAlias.equals("depense")) {
            return aliasHolder.getCorpusField("depense_date");
        }
        if (corpusAlias.equals("apport")) {
            return aliasHolder.getCorpusField("apport_date");
        }
        if (corpusAlias.equals("avance")) {
            return aliasHolder.getCorpusField("avance_date");
        }
        return null;
    }

    public static CorpusField getMontant(AliasHolder aliasHolder, String corpusAlias) {
        if (corpusAlias.equals("depense")) {
            return aliasHolder.getCorpusField("depense_montant");
        }
        if (corpusAlias.equals("apport")) {
            return aliasHolder.getCorpusField("apport_montant");
        }
        if (corpusAlias.equals("avance")) {
            return aliasHolder.getCorpusField("avance_montant");
        }
        return null;
    }

    public static CorpusField getLibelle(AliasHolder aliasHolder, String corpusAlias) {
        if (corpusAlias.equals("mouvement")) {
            return aliasHolder.getCorpusField("mouvement_libelle");
        }
        if (corpusAlias.equals("depense")) {
            return aliasHolder.getCorpusField("depense_libelle");
        }
        if (corpusAlias.equals("apport")) {
            return aliasHolder.getCorpusField("apport_libelle");
        }
        if (corpusAlias.equals("avance")) {
            return aliasHolder.getCorpusField("avance_libelle");
        }
        return null;
    }

    public static CorpusField getPeriode(AliasHolder aliasHolder, String corpusAlias) {
        if (corpusAlias.equals("depense")) {
            return aliasHolder.getCorpusField("depense_periode");
        }
        if (corpusAlias.equals("apport")) {
            return aliasHolder.getCorpusField("apport_periode");
        }
        if (corpusAlias.equals("avance")) {
            return aliasHolder.getCorpusField("avance_periode");
        }
        return null;
    }

    public static CorpusField getDateprevue(AliasHolder aliasHolder, String corpusAlias) {
        if (corpusAlias.equals("depense")) {
            return aliasHolder.getCorpusField("depense_dateprevue");
        }
        return null;
    }

    public static String getCorpusAlias(AliasHolder aliasHolder, Corpus corpus) {
        if (corpus.equals(aliasHolder.getCorpus("mouvement"))) {
            return "mouvement";
        }
        if (corpus.equals(aliasHolder.getCorpus("depense"))) {
            return "depense";
        }
        if (corpus.equals(aliasHolder.getCorpus("apport"))) {
            return "apport";
        }
        if (corpus.equals(aliasHolder.getCorpus("avance"))) {
            return "avance";
        }
        return null;
    }

    public static Lists getLists(FichePointeur mouvementPointeur, AliasHolder coreAliasHolder) {
        InternalLists lists = new InternalLists();
        Collection depenseLiaisons = mouvementPointeur.getStandardLiaisons((Subset)coreAliasHolder.getCorpus("depense"));
        ArrayList<FicheMeta> depenseList = new ArrayList<FicheMeta>();
        for (Liaison liaison : depenseLiaisons) {
            depenseList.add((FicheMeta)liaison.getSubsetItem());
        }
        lists.depenseList = depenseList;
        Collection apportLiaisons = mouvementPointeur.getStandardLiaisons((Subset)coreAliasHolder.getCorpus("apport"));
        ArrayList<FicheMeta> apportList = new ArrayList<FicheMeta>();
        for (Liaison liaison : apportLiaisons) {
            apportList.add((FicheMeta)liaison.getSubsetItem());
        }
        lists.apportList = apportList;
        Collection avanceLiaisons = mouvementPointeur.getStandardLiaisons((Subset)coreAliasHolder.getCorpus("avance"));
        ArrayList<FicheMeta> avanceList = new ArrayList<FicheMeta>();
        ArrayList<FicheMeta> soldeAvanceList = new ArrayList<FicheMeta>();
        for (Liaison liaison : avanceLiaisons) {
            FicheMeta avance = (FicheMeta)liaison.getSubsetItem();
            int currentWeight = liaison.getLien().getWeight();
            if (currentWeight == 1) {
                avanceList.add(avance);
                continue;
            }
            if (currentWeight != 2) continue;
            soldeAvanceList.add(avance);
        }
        lists.avanceList = avanceList;
        lists.soldeAvanceList = soldeAvanceList;
        return lists;
    }

    public static List<Mouvement> toMouvementList(Collection<Mouvement> mouvements) {
        if (mouvements == null || mouvements.isEmpty()) {
            return EMPTY_MOUVEMENTLIST;
        }
        return CoreUtils.wrap(mouvements.toArray(new Mouvement[mouvements.size()]));
    }

    public static List<Ligne> toLigneList(Collection<Ligne> lignes) {
        if (lignes == null || lignes.isEmpty()) {
            return EMPTY_LIGNELIST;
        }
        return CoreUtils.wrap(lignes.toArray(new Ligne[lignes.size()]));
    }

    public static List<Avenir> toAvenirList(Collection<Avenir> avenirs) {
        if (avenirs == null || avenirs.isEmpty()) {
            return EMPTY_AVENIRLIST;
        }
        return CoreUtils.wrap(avenirs.toArray(new Avenir[avenirs.size()]));
    }

    public static boolean isAvanceSoldee(Ligne ligne) {
        AvanceInfo avanceInfo = ligne.getAvanceInfo();
        if (avanceInfo == null) {
            return false;
        }
        return avanceInfo.isAvanceSoldee();
    }

    public static boolean isAvanceNonSoldee(Ligne ligne) {
        AvanceInfo avanceInfo = ligne.getAvanceInfo();
        if (avanceInfo == null) {
            return false;
        }
        return !avanceInfo.isAvanceSoldee();
    }

    public static String toBeneficiaireString(FicheItem ficheItem, Fichotheque fichotheque) {
        if (ficheItem instanceof Item) {
            return ((Item)ficheItem).getValue();
        }
        if (ficheItem instanceof PersonItem) {
            PersonCore personCore = SphereUtils.toPersonCore((Fichotheque)fichotheque, (PersonItem)((PersonItem)ficheItem));
            return personCore.toStandardStyle();
        }
        return ficheItem.toString();
    }

    public static List<Ligne> wrap(Ligne[] array) {
        return new LigneList(array);
    }

    public static List<Mouvement> wrap(Mouvement[] array) {
        return new MouvementList(array);
    }

    public static List<Avenir> wrap(Avenir[] array) {
        return new AvenirList(array);
    }

    public static List<AvanceInfo.DepenseInfo> wrap(AvanceInfo.DepenseInfo[] array) {
        return new DepenseInfoList(array);
    }

    private static class InternalLists
    implements Lists {
        private List<FicheMeta> depenseList;
        private List<FicheMeta> avanceList;
        private List<FicheMeta> soldeAvanceList;
        private List<FicheMeta> apportList;

        private InternalLists() {
        }

        @Override
        public List<FicheMeta> getDepenseList() {
            return this.depenseList;
        }

        @Override
        public List<FicheMeta> getApportList() {
            return this.apportList;
        }

        @Override
        public List<FicheMeta> getAvanceList() {
            return this.avanceList;
        }

        @Override
        public List<FicheMeta> getSoldeAvanceList() {
            return this.soldeAvanceList;
        }
    }

    private static class LigneList
    extends AbstractList<Ligne>
    implements RandomAccess {
        private final Ligne[] array;

        private LigneList(Ligne[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Ligne get(int index) {
            return this.array[index];
        }
    }

    private static class MouvementList
    extends AbstractList<Mouvement>
    implements RandomAccess {
        private final Mouvement[] array;

        private MouvementList(Mouvement[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Mouvement get(int index) {
            return this.array[index];
        }
    }

    private static class AvenirList
    extends AbstractList<Avenir>
    implements RandomAccess {
        private final Avenir[] array;

        private AvenirList(Avenir[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Avenir get(int index) {
            return this.array[index];
        }
    }

    private static class DepenseInfoList
    extends AbstractList<AvanceInfo.DepenseInfo>
    implements RandomAccess {
        private final AvanceInfo.DepenseInfo[] array;

        private DepenseInfoList(AvanceInfo.DepenseInfo[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public AvanceInfo.DepenseInfo get(int index) {
            return this.array[index];
        }
    }

    private static class CoreAliasChecker
    implements AliasChecker {
        private CoreAliasChecker() {
        }

        public short checkCorpusAlias(String alias) {
            switch (alias) {
                case "mouvement": 
                case "depense": 
                case "apport": 
                case "banque": 
                case "avance": {
                    return 2;
                }
            }
            return 0;
        }

        public short checkThesaurusAlias(String alias) {
            switch (alias) {
                case "banque": 
                case "modepaiement": 
                case "rapprochement": {
                    return 2;
                }
            }
            return 0;
        }

        public short checkFieldAlias(String corpusAlias, String fieldAlias) {
            if (corpusAlias.equals("mouvement")) {
                switch (fieldAlias) {
                    case "mouvement_date": 
                    case "mouvement_montantdebit": 
                    case "mouvement_montantcredit": 
                    case "mouvement_numeropiece": 
                    case "mouvement_beneficiaire": 
                    case "mouvement_libelle": {
                        return 2;
                    }
                    case "mouvement_numerocheque": {
                        return 1;
                    }
                }
                return 0;
            }
            if (corpusAlias.equals("depense")) {
                switch (fieldAlias) {
                    case "depense_date": 
                    case "depense_montant": 
                    case "depense_beneficiaire": 
                    case "depense_libelle": 
                    case "depense_periode": 
                    case "depense_dateprevue": {
                        return 2;
                    }
                }
                return 0;
            }
            if (corpusAlias.equals("apport")) {
                switch (fieldAlias) {
                    case "apport_date": 
                    case "apport_montant": 
                    case "apport_libelle": 
                    case "apport_periode": {
                        return 2;
                    }
                    case "apport_beneficiaire": {
                        return 1;
                    }
                }
                return 0;
            }
            if (corpusAlias.equals("avance")) {
                switch (fieldAlias) {
                    case "avance_date": 
                    case "avance_montant": 
                    case "avance_beneficiaire": 
                    case "avance_libelle": 
                    case "avance_periode": {
                        return 2;
                    }
                }
                return 0;
            }
            if (corpusAlias.equals("banque")) {
                switch (fieldAlias) {
                    case "banque_montantreport": {
                        return 2;
                    }
                }
                return 0;
            }
            return 0;
        }

        public boolean testFieldValidity(String alias, CorpusField corpusField, MessageHandler messageHandler) {
            switch (alias) {
                case "mouvement_date": 
                case "depense_date": 
                case "depense_dateprevue": 
                case "apport_date": 
                case "avance_date": {
                    return AliasUtils.testDateProp((String)alias, (CorpusField)corpusField, (MessageHandler)messageHandler);
                }
                case "mouvement_montantdebit": 
                case "mouvement_montantcredit": 
                case "depense_montant": 
                case "apport_montant": 
                case "avance_montant": 
                case "banque_montantreport": {
                    return AliasUtils.testAmountProp((String)alias, (CorpusField)corpusField, (MessageHandler)messageHandler);
                }
                case "mouvement_beneficiaire": 
                case "depense_beneficiaire": 
                case "apport_beneficiaire": 
                case "avance_beneficiaire": {
                    return AliasUtils.testPersonProp((String)alias, (CorpusField)corpusField, (MessageHandler)messageHandler);
                }
                case "mouvement_numeropiece": 
                case "mouvement_numerocheque": {
                    return AliasUtils.testNumberProp((String)alias, (CorpusField)corpusField, (MessageHandler)messageHandler);
                }
                case "mouvement_libelle": 
                case "depense_libelle": 
                case "avance_libelle": {
                    return AliasUtils.testItemProp((String)alias, (CorpusField)corpusField, (MessageHandler)messageHandler);
                }
                case "depense_periode": 
                case "apport_periode": 
                case "avance_periode": {
                    return AliasUtils.testDateInfo((String)alias, (CorpusField)corpusField, (MessageHandler)messageHandler);
                }
            }
            return false;
        }
    }

    public static interface Lists {
        public List<FicheMeta> getDepenseList();

        public List<FicheMeta> getApportList();

        public List<FicheMeta> getAvanceList();

        public List<FicheMeta> getSoldeAvanceList();
    }
}

