/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.tools.analytique;

import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueDef;
import fr.exemole.bdfext.scarabe.api.analytique.GroupbyDef;
import fr.exemole.bdfext.scarabe.api.analytique.OperationDef;
import fr.exemole.bdfext.scarabe.api.analytique.TableaucroiseDef;
import fr.exemole.bdfext.scarabe.tools.analytique.AnalytiqueUtils;
import fr.exemole.bdfext.scarabe.tools.analytique.CustomLigneDefBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.utils.FichothequeUtils;

public class AnalytiqueDefBuilder {
    private final GroupbyDef groupbyDef;
    private final List<IncludeKey> subIncludeKeyList = new ArrayList<IncludeKey>();
    private final List<OperationDef> operationDefList = new ArrayList<OperationDef>();
    private final List<TableaucroiseDef> tableaucroiseDefList = new ArrayList<TableaucroiseDef>();
    private final Set<String> existingOperationNameSet = new HashSet<String>();

    public AnalytiqueDefBuilder(GroupbyDef groupbyDef) {
        this.groupbyDef = groupbyDef;
    }

    public AnalytiqueDefBuilder addSubIncludeKey(IncludeKey includeKey) {
        this.subIncludeKeyList.add(includeKey);
        return this;
    }

    public AnalytiqueDefBuilder addOperationDef(OperationDef operationDef) {
        String name = operationDef.getName();
        if (!this.existingOperationNameSet.contains(name)) {
            this.operationDefList.add(operationDef);
            this.existingOperationNameSet.add(name);
        }
        return this;
    }

    public AnalytiqueDefBuilder addLignesSpecialOperation() {
        this.testLignes();
        return this;
    }

    public AnalytiqueDefBuilder addAvenirSpecialOperation() {
        this.testAvenir();
        return this;
    }

    public AnalytiqueDefBuilder addTableaucroiseDef(TableaucroiseDef tableaucroiseDef) {
        this.tableaucroiseDefList.add(tableaucroiseDef);
        return this;
    }

    public boolean containsOperationDef(String name) {
        return this.existingOperationNameSet.contains(name);
    }

    public boolean isValidOperand(String operandName) {
        if (AnalytiqueUtils.isSpecialOperand(operandName)) {
            return true;
        }
        return this.existingOperationNameSet.contains(operandName);
    }

    private void testLignes() {
        this.testSpecialLigne("_apport_");
        this.testSpecialLigne("_depense_");
        this.testSpecialLigne("_avance_");
    }

    private void testAvenir() {
        this.testSpecialLigne("_avenir_depense_");
    }

    private void testSpecialLigne(String name) {
        if (!this.existingOperationNameSet.contains(name)) {
            CustomLigneDefBuilder customLigneDefBuilder = new CustomLigneDefBuilder(name);
            this.existingOperationNameSet.add(name);
            this.operationDefList.add(customLigneDefBuilder.toCustomLigneDef());
        }
    }

    public AnalytiqueDef toAnalytiqueDef() {
        this.testLignes();
        this.testAvenir();
        List finalSubIncludeKeyList = FichothequeUtils.wrap((IncludeKey[])this.subIncludeKeyList.toArray(new IncludeKey[this.subIncludeKeyList.size()]));
        List<OperationDef> finalOperationDefList = AnalytiqueUtils.wrap(this.operationDefList.toArray(new OperationDef[this.operationDefList.size()]));
        List<TableaucroiseDef> finalTableaucroiseDefList = AnalytiqueUtils.wrap(this.tableaucroiseDefList.toArray(new TableaucroiseDef[this.tableaucroiseDefList.size()]));
        return new InternalAnalytiqueDef(this.groupbyDef, finalSubIncludeKeyList, finalOperationDefList, finalTableaucroiseDefList);
    }

    public static AnalytiqueDefBuilder init(GroupbyDef groupbyDef) {
        return new AnalytiqueDefBuilder(groupbyDef);
    }

    private static class InternalAnalytiqueDef
    implements AnalytiqueDef {
        private final GroupbyDef groupbyDef;
        private final List<IncludeKey> subIncludeKeyList;
        private final List<OperationDef> operationDefList;
        private final List<TableaucroiseDef> tableaucroiseDefList;

        private InternalAnalytiqueDef(GroupbyDef groupbyDef, List<IncludeKey> subIncludeKeyList, List<OperationDef> operationDefList, List<TableaucroiseDef> tableaucroiseDefList) {
            this.groupbyDef = groupbyDef;
            this.subIncludeKeyList = subIncludeKeyList;
            this.operationDefList = operationDefList;
            this.tableaucroiseDefList = tableaucroiseDefList;
        }

        @Override
        public GroupbyDef getGroupbyDef() {
            return this.groupbyDef;
        }

        @Override
        public List<IncludeKey> getSubIncludeKeyList() {
            return this.subIncludeKeyList;
        }

        @Override
        public List<OperationDef> getOperationDefList() {
            return this.operationDefList;
        }

        @Override
        public List<TableaucroiseDef> getTableaucroiseDefList() {
            return this.tableaucroiseDefList;
        }
    }
}

