/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.producers.html.ficheform;

import fr.exemole.bdfserver.api.ficheform.FicheFormParameters;
import fr.exemole.bdfserver.api.ficheform.FormElement;
import fr.exemole.bdfserver.api.ficheform.FormElementProvider;
import fr.exemole.bdfserver.api.ui.FieldUi;
import fr.exemole.bdfserver.api.ui.IncludeUi;
import fr.exemole.bdfserver.api.ui.SubsetIncludeUi;
import fr.exemole.bdfserver.tools.ficheform.FicheFormUtils;
import fr.exemole.bdfserver.tools.ficheform.FormElementProviderFactory;
import fr.exemole.bdfserver.tools.ficheform.builders.AmountPropSubfieldsElementBuilder;
import fr.exemole.bdfserver.tools.ficheform.builders.CorpusIncludeElementBuilder;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.alias.AliasHolder;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.AmountItem;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.Item;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.include.ExtendedIncludeKey;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.syntax.FormSyntax;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.fichotheque.utils.pointeurs.PointeurFactory;

public class AvenirFormElementProvider
implements FormElementProvider {
    private final Fichotheque fichotheque;
    private final SubsetKey depenseSubsetKey;
    private final FicheFormParameters ficheFormParameters;
    private final FicheMeta depense;
    private final CorpusField mouvementLibelleField;
    private final CorpusField mouvementBeneficiaireField;
    private final CorpusField mouvementDebitField;
    private final CorpusField mouvementCreditField;
    private final FichePointeur depensePointeur;
    private final AliasHolder coreAliasHolder;
    private final FormElementProvider defaultProvider;
    private AmountItem depenseMontant;

    private AvenirFormElementProvider(FicheFormParameters ficheFormParameters, FicheMeta depense, AliasHolder coreAliasHolder) {
        this.fichotheque = depense.getFichotheque();
        this.depenseSubsetKey = depense.getSubsetKey();
        this.ficheFormParameters = ficheFormParameters;
        this.coreAliasHolder = coreAliasHolder;
        this.depense = depense;
        this.defaultProvider = FormElementProviderFactory.newInstance((FicheFormParameters)ficheFormParameters);
        this.mouvementLibelleField = coreAliasHolder.getCorpusField("mouvement_libelle");
        this.mouvementBeneficiaireField = coreAliasHolder.getCorpusField("mouvement_beneficiaire");
        this.mouvementDebitField = coreAliasHolder.getCorpusField("mouvement_montantdebit");
        this.mouvementCreditField = coreAliasHolder.getCorpusField("mouvement_montantcredit");
        this.depensePointeur = PointeurFactory.newFichePointeur((Corpus)depense.getCorpus());
        this.depensePointeur.setCurrentSubsetItem((SubsetItem)depense);
        Object obj = this.depensePointeur.getValue(coreAliasHolder.getCorpusField("depense_montant"));
        if (obj != null || obj instanceof AmountItem) {
            this.depenseMontant = (AmountItem)obj;
        }
    }

    public FormElement.Include getFormElement(FichePointeur fichePointeur, IncludeUi includeUi) {
        ExtendedIncludeKey includeKey;
        SubsetKey subsetKey;
        if (includeUi instanceof SubsetIncludeUi && (subsetKey = (includeKey = ((SubsetIncludeUi)includeUi).getExtendedIncludeKey()).getSubsetKey()).equals((Object)this.depenseSubsetKey) && (!includeKey.hasWeightFilter() || includeKey.getWeightFilter() == 1)) {
            int weight = includeKey.getWeightFilter() == 1 ? -1 : 1;
            return CorpusIncludeElementBuilder.init((String)includeUi.getName(), (Corpus)this.depense.getCorpus()).setHasWeightFilter(includeKey.hasWeightFilter()).populateOptions(this.ficheFormParameters, includeUi).addFicheMeta(this.depense, weight).toCorpusIncludeElement();
        }
        return this.defaultProvider.getFormElement(fichePointeur, includeUi);
    }

    public FormElement.Field getFormElement(FichePointeur fichePointeur, FieldUi fieldUI) {
        FormElement.Field fieldElement = this.testLibelle(fichePointeur, fieldUI);
        if (fieldElement != null) {
            return fieldElement;
        }
        fieldElement = this.testBeneficiaire(fichePointeur, fieldUI);
        if (fieldElement != null) {
            return fieldElement;
        }
        fieldElement = this.testMontant(fichePointeur, fieldUI, this.mouvementDebitField, false);
        if (fieldElement != null) {
            return fieldElement;
        }
        fieldElement = this.testMontant(fichePointeur, fieldUI, this.mouvementCreditField, true);
        if (fieldElement != null) {
            return fieldElement;
        }
        return this.defaultProvider.getFormElement(fichePointeur, fieldUI);
    }

    private FormElement.Field testLibelle(FichePointeur fichePointeur, FieldUi fieldUi) {
        if (!this.areMatching(fieldUi, this.mouvementLibelleField)) {
            return null;
        }
        String defaultValue = null;
        Object item = this.depensePointeur.getValue(this.coreAliasHolder.getCorpusField("depense_libelle"));
        if (item != null && item instanceof Item) {
            defaultValue = ((Item)item).getValue();
        }
        return FicheFormUtils.toFormElement((FichePointeur)fichePointeur, (FicheFormParameters)this.ficheFormParameters, (CorpusField)this.mouvementLibelleField, (FieldUi)fieldUi, (String)defaultValue);
    }

    private FormElement.Field testBeneficiaire(FichePointeur fichePointeur, FieldUi fieldUi) {
        if (!this.areMatching(fieldUi, this.mouvementBeneficiaireField)) {
            return null;
        }
        String defaultValue = null;
        FicheItem ficheItem = (FicheItem)this.depensePointeur.getValue(this.coreAliasHolder.getCorpusField("depense_beneficiaire"));
        if (ficheItem != null) {
            FormSyntax.Parameters parameters = FicheFormUtils.getParameters((FicheFormParameters)this.ficheFormParameters, (CorpusField)this.mouvementBeneficiaireField);
            defaultValue = FormSyntax.toString((FicheItem)ficheItem, (Fichotheque)this.fichotheque, (FormSyntax.Parameters)parameters);
        }
        return FicheFormUtils.toFormElement((FichePointeur)fichePointeur, (FicheFormParameters)this.ficheFormParameters, (CorpusField)this.mouvementBeneficiaireField, (FieldUi)fieldUi, defaultValue);
    }

    private FormElement.Field testMontant(FichePointeur fichePointeur, FieldUi fieldUi, CorpusField montantField, boolean inverse) {
        if (!this.areMatching(fieldUi, montantField)) {
            return null;
        }
        if (this.depenseMontant == null) {
            return null;
        }
        AmountItem montant = this.depenseMontant;
        boolean positif = montant.getDecimal().isPositif();
        if (positif == inverse) {
            return null;
        }
        if (!positif) {
            montant = new AmountItem(montant.getDecimal().getOpposite(), montant.getCurrency());
        }
        if (CorpusMetadataUtils.isCurrenciesProp((CorpusField)montantField)) {
            return AmountPropSubfieldsElementBuilder.build((FicheFormParameters)this.ficheFormParameters, (CorpusField)montantField, (FieldUi)fieldUi, (FicheItem)montant).toAmountPropSubfieldsElement();
        }
        FormSyntax.Parameters parameters = FicheFormUtils.getParameters((FicheFormParameters)this.ficheFormParameters, (CorpusField)montantField);
        String defaultValue = FormSyntax.toString((FicheItem)montant, (Fichotheque)this.fichotheque, (FormSyntax.Parameters)parameters);
        return FicheFormUtils.toFormElement((FichePointeur)fichePointeur, (FicheFormParameters)this.ficheFormParameters, (CorpusField)montantField, (FieldUi)fieldUi, (String)defaultValue);
    }

    private boolean areMatching(FieldUi fieldUi, CorpusField corpusField) {
        return fieldUi.getFieldKey().equals((Object)corpusField.getFieldKey());
    }

    public static AvenirFormElementProvider newInstance(FicheFormParameters ficheFormParameters, FicheMeta depense, AliasHolder coreAliasHolder) {
        return new AvenirFormElementProvider(ficheFormParameters, depense, coreAliasHolder);
    }
}

