/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe.producers.html;

import fr.exemole.bdfext.scarabe.Scarabe;
import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.api.Recapitulatif;
import fr.exemole.bdfext.scarabe.api.core.AvanceInfo;
import fr.exemole.bdfext.scarabe.api.core.Avenir;
import fr.exemole.bdfext.scarabe.api.core.Banque;
import fr.exemole.bdfext.scarabe.api.core.Banques;
import fr.exemole.bdfext.scarabe.api.core.Ligne;
import fr.exemole.bdfext.scarabe.api.core.Mouvement;
import fr.exemole.bdfext.scarabe.producers.html.ScarabeHtmlUtils;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.Button;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import fr.exemole.bdfserver.tools.BH;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.primitives.FuzzyDate;
import net.mapeadores.util.text.DateFormatBundle;

public class ErrorRecapitulatifHtmlProducer
extends BdfServerHtmlProducer {
    private final Recapitulatif recapitulatif;
    private final ScarabeContext scarabeContext;

    public ErrorRecapitulatifHtmlProducer(BdfParameters bdfParameters, ScarabeContext scarabeContext) {
        super(bdfParameters);
        this.scarabeContext = scarabeContext;
        this.addExtensionThemeCss("scarabe", new String[]{"_action.css"});
        this.setBodyCssClass("global-body-ListFrame");
        this.recapitulatif = scarabeContext.getScarabeCache().getRecapitulatif(this.bdfServer);
    }

    public void printHtml() {
        List<FicheMeta> list;
        List<Avenir> errorAvenirList;
        List<Mouvement> errorMouvementList;
        this.start();
        ScarabeHtmlUtils.printRecapitulatifToolList((HtmlPrinter)this, Scarabe.DOMAIN);
        Banques banques = this.recapitulatif.getBanques();
        if (banques.isWithErrors()) {
            this.__((Consumer)PageUnit.start((Object)"_ title.scarabe.error_banque")).UL();
            for (Object banque : banques) {
                if (!banque.hasError()) continue;
                this.printBanqueLi((Banque)banque);
            }
            this._UL().__(PageUnit.END);
        }
        if (!(errorMouvementList = this.recapitulatif.getErrorMouvementList()).isEmpty()) {
            this.__((Consumer)PageUnit.start((Object)"_ title.scarabe.error_mouvement")).UL();
            for (Mouvement mouvement : errorMouvementList) {
                this.printErrorMouvementLi(mouvement);
            }
            this._UL().__(PageUnit.END);
        }
        if (!(errorAvenirList = this.recapitulatif.getErrorAvenirList()).isEmpty()) {
            this.__((Consumer)PageUnit.start((Object)"_ title.scarabe.error_avenir")).UL();
            for (Avenir avenir : errorAvenirList) {
                this.printErrorAvenirLi(avenir);
            }
            this._UL().__(PageUnit.END);
        }
        if (!(list = this.recapitulatif.getDesherenceList()).isEmpty()) {
            this.__((Consumer)PageUnit.start((Object)"_ title.scarabe.error_desherence")).UL();
            for (FicheMeta ficheMeta : list) {
                this.printDesherenceLi(ficheMeta);
            }
            this._UL().__(PageUnit.END);
        }
        this.end();
    }

    private void printErrorMouvementLi(Mouvement mouvement) {
        this.LI();
        int piece = mouvement.getNumeropiece();
        this.P().__localize("_ label.scarabe.numeropiece").__colon();
        if (piece == -1) {
            this.__escape("?");
        } else {
            this.__append(piece);
        }
        this.__dash().__localize("_ label.scarabe.date").__colon();
        FuzzyDate date = mouvement.getDate();
        if (date == null) {
            this.__escape("?");
        } else {
            DateFormatBundle dateFormatBundle = DateFormatBundle.getDateFormatBundle((Locale)this.getFormatLocale());
            this.__escape(date.getDateLitteral(dateFormatBundle));
        }
        this.__dash().__localize("_ label.scarabe.libelle").__colon().__escape((CharSequence)mouvement.getLibelle());
        List<Message> errorMessageList = mouvement.getErrorMessageList();
        if (!errorMessageList.isEmpty()) {
            this.__dash().SPAN("global-ErrorMessage");
            boolean next = false;
            for (Message errorMessage : errorMessageList) {
                if (next) {
                    this.__escape(" ; ");
                } else {
                    next = true;
                }
                this.__localize(errorMessage);
            }
            this._SPAN();
        }
        this.BR();
        FicheMeta ficheMeta = mouvement.getFicheMeta();
        this.__(!errorMessageList.isEmpty() ? this.printFicheButtons(ficheMeta) : false).A(HA.href((CharSequence)BH.domain((String)"edition").page("fiche-result").subsetItem((SubsetItem)ficheMeta)).target("Edition").classes("global-button-Transparent action-scarabe-MouvementCheck").titleLocKey("_ link.scarabe.mouvementresult")).__(Button.ICON)._A()._P();
        if (mouvement.withLigneError()) {
            this.UL().__(this.printLigneErrorLi(mouvement.getAvanceList(), "_ label.scarabe.fiche_avance")).__(this.printLigneErrorLi(mouvement.getSoldeAvanceList(), "_ label.scarabe.fiche_avance_solde")).__(this.printLigneErrorLi(mouvement.getDepenseList(), "_ label.scarabe.fiche_depense")).__(this.printLigneErrorLi(mouvement.getApportList(), "_ label.scarabe.fiche_apport"))._UL();
        }
        this._LI();
    }

    private boolean printLigneErrorLi(List<Ligne> ligneList, String titleMessageKey) {
        for (Ligne ligne : ligneList) {
            if (!ligne.hasError()) continue;
            FicheMeta ficheMeta = ligne.getFicheMeta();
            String title = ficheMeta.getTitle();
            if (title.length() == 0) {
                title = "__";
            }
            this.LI();
            this.P().EM().__localize(titleMessageKey).__colon()._EM().__escape((CharSequence)title).SPAN("global-ErrorMessage").__dash();
            boolean premier = true;
            boolean withAvanceInfoError = false;
            for (Message errorMessage : ligne.getErrorMessageList()) {
                if (errorMessage.getMessageKey().equals("_ error.unsupported.scarabe.witherrors_avance")) {
                    withAvanceInfoError = true;
                    continue;
                }
                if (premier) {
                    premier = false;
                } else {
                    this.__escape(" ; ");
                }
                this.__localize(errorMessage);
            }
            this._SPAN().BR().__(this.printFicheButtons(ficheMeta))._P();
            if (withAvanceInfoError) {
                this.UL();
                AvanceInfo avanceInfo = ligne.getAvanceInfo();
                for (AvanceInfo.DepenseInfo depenseInfo : avanceInfo.getDepenseInfoList()) {
                    if (!depenseInfo.hasError()) continue;
                    FicheMeta depenseFicheMeta = depenseInfo.getFicheMeta();
                    String depenseTitre = depenseFicheMeta.getTitle();
                    if (depenseTitre.length() == 0) {
                        depenseTitre = "__";
                    }
                    this.LI();
                    this.P().EM().__localize("_ label.scarabe.fiche_depense").__colon()._EM().__escape((CharSequence)depenseTitre);
                    this.SPAN("global-ErrorMessage");
                    boolean first = true;
                    for (Message errorDepenseMessage : depenseInfo.getErrorMessageList()) {
                        if (first) {
                            first = false;
                            this.__dash();
                        } else {
                            this.__escape(" ; ");
                        }
                        this.__localize(errorDepenseMessage);
                    }
                    this._SPAN().BR().__(this.printFicheButtons(depenseFicheMeta))._P();
                    this._LI();
                }
                this._UL();
            }
            this._LI();
        }
        return true;
    }

    private void printErrorAvenirLi(Avenir avenir) {
        FicheMeta ficheMeta = avenir.getFicheMeta();
        String title = ficheMeta.getTitle();
        if (title.length() == 0) {
            title = "__";
        }
        this.LI();
        this.P().EM().__localize("_ label.scarabe.fiche_depense_avenir").__colon()._EM().__escape((CharSequence)title).SPAN("global-ErrorMessage").__dash();
        boolean next = false;
        for (Message errorMessage : avenir.getErrorMessageList()) {
            if (next) {
                this.__escape(" ; ");
            } else {
                next = true;
            }
            this.__localize(errorMessage);
        }
        this._SPAN().BR().__(this.printFicheButtons(ficheMeta))._P();
        this._LI();
    }

    private void printDesherenceLi(FicheMeta ficheMeta) {
        this.LI();
        this.P().__escape((CharSequence)CorpusMetadataUtils.getFicheTitle((FicheMeta)ficheMeta, (Lang)this.bdfUser.getWorkingLang(), (Locale)this.bdfUser.getFormatLocale())).BR().__(this.printFicheButtons(ficheMeta)).A(HA.href((CharSequence)BH.domain((String)Scarabe.DOMAIN).page("DesherenceRemove").subsetItem((SubsetItem)ficheMeta)).classes("global-button-Transparent action-Delete").target("Edition").titleLocKey("_ link.global.delete")).__(Button.ICON)._A()._P();
        this._LI();
    }

    private void printBanqueLi(Banque banque) {
        Corpus corpusBanque = this.scarabeContext.getCoreAliasHolder().getCorpus("banque");
        int motcleid = banque.getMotcle().getId();
        this.LI();
        this.P().__escape((CharSequence)banque.getTitle(this.workingLang)).__dash().SPAN("global-ErrorMessage");
        boolean next = false;
        for (Message errorMessage : banque.getErrorMessageList()) {
            if (next) {
                this.__escape(" ; ");
            } else {
                next = true;
            }
            this.__localize(errorMessage);
        }
        this._SPAN().BR();
        FicheMeta ficheMeta = corpusBanque.getFicheMetaById(motcleid);
        if (ficheMeta != null) {
            this.__(this.printFicheButtons(ficheMeta));
        } else {
            String href = BH.domain((String)"edition").page("fiche-change").subset((Subset)corpusBanque).param("id", String.valueOf(motcleid)).toString();
            this.__((Consumer)Button.link((String)href).action("action-FicheCreate").textL10nObject((Object)"_ link.scarabe.fichebanquecreation").target("Edition"));
        }
        this._P();
        this._LI();
    }

    private boolean printFicheButtons(FicheMeta ficheMeta) {
        this.__(ScarabeHtmlUtils.printDisplayButton((HtmlPrinter)this, ficheMeta)).__(ScarabeHtmlUtils.printEditButton((HtmlPrinter)this, ficheMeta));
        return true;
    }
}

