/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.scarabe;

import fr.exemole.bdfext.scarabe.ScarabeContext;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueDetails;
import fr.exemole.bdfext.scarabe.api.analytique.AnalytiqueRecap;
import fr.exemole.bdfext.scarabe.api.core.BanqueDetail;
import fr.exemole.bdfext.scarabe.api.core.Mouvement;
import fr.exemole.bdfext.scarabe.producers.html.AnalytiqueDetailTableHtmlProducer;
import fr.exemole.bdfext.scarabe.producers.html.AnalytiqueRecapListHtmlProducer;
import fr.exemole.bdfext.scarabe.producers.html.AvancesNonSoldeesHtmlProducer;
import fr.exemole.bdfext.scarabe.producers.html.BanqueDetailTableHtmlProducer;
import fr.exemole.bdfext.scarabe.producers.html.BanqueRecapitulatifHtmlProducer;
import fr.exemole.bdfext.scarabe.producers.html.DepenseAvenirHtmlProducer;
import fr.exemole.bdfext.scarabe.producers.html.DesherenceRemoveHtmlProducer;
import fr.exemole.bdfext.scarabe.producers.html.ErrorRecapitulatifHtmlProducer;
import fr.exemole.bdfext.scarabe.producers.html.ExportationHtmlProducer;
import fr.exemole.bdfext.scarabe.producers.html.InitLogHtmlProducer;
import fr.exemole.bdfext.scarabe.producers.html.InstallationHtmlProducer;
import fr.exemole.bdfext.scarabe.producers.html.MouvementFicheResultHtmlProducer;
import fr.exemole.bdfext.scarabe.producers.html.OverrideFichesHtmlProducer;
import fr.exemole.bdfext.scarabe.producers.html.PastDateWarningHtmlProducer;
import fr.exemole.bdfext.scarabe.producers.html.RecapitulatifHtmlProducer;
import fr.exemole.bdfext.scarabe.producers.html.ResteWarningHtmlProducer;
import fr.exemole.bdfext.scarabe.producers.html.TableaucroiseTableHtmlProducer;
import fr.exemole.bdfext.scarabe.producers.html.configuration.AnalytiqueConfigHtmlProducer;
import fr.exemole.bdfext.scarabe.producers.html.configuration.ColumnsConfigHtmlProducer;
import fr.exemole.bdfext.scarabe.producers.html.configuration.PrerequestConfigHtmlProducer;
import fr.exemole.bdfext.scarabe.producers.html.ficheform.AvenirFormElementProvider;
import fr.exemole.bdfext.scarabe.producers.html.ficheform.LigneFormElementProvider;
import fr.exemole.bdfext.scarabe.producers.html.ficheform.SoldeFormElementProvider;
import fr.exemole.bdfext.scarabe.tools.core.CoreUtils;
import fr.exemole.bdfext.scarabe.tools.core.MouvementBuilder;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.ficheform.FicheFormParameters;
import fr.exemole.bdfserver.api.ficheform.FormElementProvider;
import fr.exemole.bdfserver.api.instruction.BdfCommandResult;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.api.instruction.PermissionException;
import fr.exemole.bdfserver.api.providers.HtmlProducerProvider;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.MessageHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.edition.FicheFormHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.edition.FicheResultHandler;
import fr.exemole.bdfserver.htmlproducers.edition.FicheResultHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.main.MainHtmlProducerFactory;
import fr.exemole.bdfserver.htmlproducers.main.MainHtmlUtils;
import fr.exemole.bdfserver.tools.ficheform.FicheFormUtils;
import fr.exemole.bdfserver.tools.ficheform.FormElementProviderFactory;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.instruction.BdfInstructionUtils;
import fr.exemole.bdfserver.tools.instruction.OutputRequestHandler;
import fr.exemole.bdfserver.tools.instruction.RequestHandler;
import fr.exemole.bdfserver.tools.roles.PermissionCheck;
import java.text.ParseException;
import java.util.List;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetKey;
import net.fichotheque.alias.AliasHolder;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.pointeurs.FichePointeur;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.ThesaurusUtils;
import net.fichotheque.utils.pointeurs.PointeurFactory;
import net.mapeadores.util.html.HtmlProducer;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.text.StringUtils;

public class ScarabeHtmlProducerProvider
implements HtmlProducerProvider {
    private static final int SCARABE_ADMIN = 1;
    private final ScarabeContext scarabeContext;

    public ScarabeHtmlProducerProvider(ScarabeContext scarabeContext) {
        this.scarabeContext = scarabeContext;
    }

    public HtmlProducer getHtmlProducer(OutputParameters parameters) throws ErrorMessageException {
        BdfServerHtmlProducer htmlProducer = this.getBdfHtmlProducer(parameters);
        BdfCommandResult bdfCommandResult = parameters.getBdfCommandResult();
        if (htmlProducer != null && bdfCommandResult != null) {
            htmlProducer.setBdfCommandResult(bdfCommandResult);
        }
        return htmlProducer;
    }

    private BdfServerHtmlProducer getBdfHtmlProducer(OutputParameters parameters) throws ErrorMessageException {
        if (BdfInstructionUtils.ownsToExtension((OutputParameters)parameters, (String)"scarabe")) {
            return this.scarabeDomain(parameters);
        }
        switch (parameters.getDomain().getFirstPart()) {
            case "main": {
                return this.mainDomain(parameters);
            }
            case "edition": {
                return this.editionDomain(parameters);
            }
        }
        return null;
    }

    private BdfServerHtmlProducer scarabeDomain(OutputParameters parameters) throws ErrorMessageException {
        OutputRequestHandler requestHandler = OutputRequestHandler.init((OutputParameters)parameters);
        BdfServer bdfServer = parameters.getBdfServer();
        BdfUser bdfUser = parameters.getBdfUser();
        String page = parameters.getOutput();
        short initState = this.scarabeContext.getInitState();
        if (initState == 2) {
            switch (page) {
                case "Installation": {
                    parameters.checkFichothequeAdmin();
                    return new InstallationHtmlProducer((BdfParameters)parameters);
                }
                case "InitLog": {
                    parameters.checkFichothequeAdmin();
                    this.scarabeContext.reinit();
                    return new InitLogHtmlProducer((BdfParameters)parameters, this.scarabeContext);
                }
            }
            return null;
        }
        if (initState != 1) {
            switch (page) {
                case "InitLog": {
                    parameters.checkFichothequeAdmin();
                    this.scarabeContext.reinit();
                    return new InitLogHtmlProducer((BdfParameters)parameters, this.scarabeContext);
                }
            }
            return null;
        }
        switch (ScarabeHtmlProducerProvider.getPageType(page)) {
            case 1: {
                parameters.checkFichothequeAdmin();
                this.scarabeContext.reinit();
                switch (page) {
                    case "AnalytiqueConfig": {
                        return new AnalytiqueConfigHtmlProducer((BdfParameters)parameters);
                    }
                    case "PrerequestConfig": {
                        return new PrerequestConfigHtmlProducer((BdfParameters)parameters, this.scarabeContext);
                    }
                    case "ColumnsConfig": {
                        return new ColumnsConfigHtmlProducer((BdfParameters)parameters, this.scarabeContext);
                    }
                    case "InitLog": {
                        return new InitLogHtmlProducer((BdfParameters)parameters, this.scarabeContext);
                    }
                }
                return null;
            }
        }
        switch (page) {
            case "MouvementFicheResult": {
                FicheMeta ficheMeta = requestHandler.getFicheMeta();
                FicheResultHandler ficheResultHandler = FicheResultHandler.build((FicheMeta)ficheMeta, (RequestHandler)requestHandler);
                return new MouvementFicheResultHtmlProducer((BdfParameters)parameters, this.scarabeContext, ficheResultHandler);
            }
            case "Recapitulatif": {
                return new RecapitulatifHtmlProducer((BdfParameters)parameters, this.scarabeContext);
            }
            case "ErrorRecapitulatif": {
                return new ErrorRecapitulatifHtmlProducer((BdfParameters)parameters, this.scarabeContext);
            }
            case "ResteWarning": {
                return new ResteWarningHtmlProducer((BdfParameters)parameters, this.scarabeContext);
            }
            case "BanqueRecapitulatif": {
                return new BanqueRecapitulatifHtmlProducer((BdfParameters)parameters, this.scarabeContext);
            }
            case "AnalytiqueRecapList": {
                AnalytiqueRecap analytiqueRecap = (AnalytiqueRecap)parameters.getResultObject("scarabe.obj_analytiquerecap");
                return new AnalytiqueRecapListHtmlProducer((BdfParameters)parameters, this.scarabeContext, analytiqueRecap);
            }
            case "BanqueDetailTable": {
                bdfUser.putParameter("scarabe.lastbanquedetailformat", (Object)"html");
                BanqueDetail banqueDetail = (BanqueDetail)parameters.getResultObject("scarabe.obj_banquedetail");
                String type = (String)parameters.getResultObject("scarabe.obj_type");
                return BanqueDetailTableHtmlProducer.newInstance((BdfParameters)parameters, this.scarabeContext, banqueDetail, type);
            }
            case "AnalytiqueDetailTable": {
                bdfUser.putParameter("scarabe.lastanalytiquedetailformat", (Object)"html");
                AnalytiqueDetails analytiqueDetails = (AnalytiqueDetails)parameters.getResultObject("scarabe.obj_analytiquedetails");
                AnalytiqueRecap analytiqueRecap = (AnalytiqueRecap)parameters.getResultObject("scarabe.obj_analytiquerecap");
                return new AnalytiqueDetailTableHtmlProducer((BdfParameters)parameters, this.scarabeContext, analytiqueDetails, analytiqueRecap);
            }
            case "TableaucroiseTable": {
                bdfUser.putParameter("scarabe.lasttableaucroiseformat", (Object)"html");
                AnalytiqueDetails analytiqueDetails = (AnalytiqueDetails)parameters.getResultObject("scarabe.obj_analytiquedetails");
                Fichotheque fichotheque = bdfServer.getFichotheque();
                IncludeKey includeKey = ScarabeHtmlProducerProvider.initIncludeKey((RequestHandler)requestHandler, fichotheque);
                List<Motcle> motcleList = ScarabeHtmlProducerProvider.initMotcleList(fichotheque, includeKey);
                return new TableaucroiseTableHtmlProducer((BdfParameters)parameters, this.scarabeContext, analytiqueDetails, includeKey, motcleList);
            }
            case "Exportation": {
                return new ExportationHtmlProducer((BdfParameters)parameters, this.scarabeContext);
            }
            case "AvancesNonSoldees": {
                return new AvancesNonSoldeesHtmlProducer((BdfParameters)parameters, this.scarabeContext);
            }
            case "DepenseAvenir": {
                return new DepenseAvenirHtmlProducer((BdfParameters)parameters, this.scarabeContext);
            }
            case "PastDateWarning": {
                return new PastDateWarningHtmlProducer((BdfParameters)parameters, this.scarabeContext);
            }
            case "DesherenceRemove": {
                FicheMeta ficheMeta = requestHandler.getMandatoryFicheMeta();
                return new DesherenceRemoveHtmlProducer((BdfParameters)parameters, ficheMeta);
            }
            case "Message": {
                return new MessageHtmlProducer((BdfParameters)parameters);
            }
        }
        return null;
    }

    private BdfServerHtmlProducer mainDomain(OutputParameters parameters) throws ErrorMessageException {
        if (this.scarabeContext.getInitState() != 1) {
            return null;
        }
        OutputRequestHandler requestHandler = OutputRequestHandler.init((OutputParameters)parameters);
        switch (parameters.getOutput()) {
            case "fiches": {
                MainHtmlProducerFactory.testFichesReload((RequestHandler)requestHandler);
                return new OverrideFichesHtmlProducer((BdfParameters)parameters, MainHtmlUtils.getFiches((RequestHandler)requestHandler), this.scarabeContext);
            }
        }
        return null;
    }

    private BdfServerHtmlProducer editionDomain(OutputParameters parameters) throws ErrorMessageException {
        if (this.scarabeContext.getInitState() != 1) {
            return null;
        }
        OutputRequestHandler requestHandler = OutputRequestHandler.init((OutputParameters)parameters);
        AliasHolder coreAliasHolder = this.scarabeContext.getCoreAliasHolder();
        Corpus mouvementCorpus = coreAliasHolder.getCorpus("mouvement");
        switch (parameters.getOutput()) {
            case "fiche-result": {
                FicheMeta ficheMeta = requestHandler.getFicheMeta();
                FicheResultHandler ficheResultHandler = FicheResultHandler.build((FicheMeta)ficheMeta, (RequestHandler)requestHandler);
                if (ficheMeta.getCorpus().equals(mouvementCorpus)) {
                    return new MouvementFicheResultHtmlProducer((BdfParameters)parameters, this.scarabeContext, ficheResultHandler);
                }
                return new FicheResultHtmlProducer((BdfParameters)parameters, ficheResultHandler);
            }
            case "fiche-creation": {
                Corpus corpus = requestHandler.getCorpus();
                if (corpus.getMasterSubset() != null) {
                    return null;
                }
                if (corpus.equals(mouvementCorpus)) {
                    ScarabeHtmlProducerProvider.checkFicheCreate((BdfParameters)parameters, mouvementCorpus);
                    return ScarabeHtmlProducerProvider.getMouvementFicheCreation(parameters, (RequestHandler)requestHandler, mouvementCorpus, coreAliasHolder);
                }
                FicheMeta mouvementFicheMeta = ScarabeHtmlProducerProvider.getMouvement((RequestHandler)requestHandler, coreAliasHolder);
                if (mouvementFicheMeta == null) {
                    return null;
                }
                String corpusAlias = CoreUtils.getCorpusAlias(coreAliasHolder, corpus);
                if (corpusAlias == null) {
                    return null;
                }
                Mouvement mouvement = MouvementBuilder.build(mouvementFicheMeta, this.scarabeContext);
                ScarabeHtmlProducerProvider.checkFicheCreate((BdfParameters)parameters, corpus);
                FichePointeur fichePointeur = PointeurFactory.newFichePointeur((Corpus)corpus, (boolean)true);
                FicheFormParameters ficheFormParameters = FicheFormUtils.toFicheFormParameters((OutputParameters)parameters);
                LigneFormElementProvider ligneFormElementProvider = new LigneFormElementProvider(ficheFormParameters, mouvement, corpusAlias, this.scarabeContext);
                return FicheFormHtmlProducer.newCreationInstance((BdfParameters)parameters, (FichePointeur)fichePointeur, (FormElementProvider)ligneFormElementProvider);
            }
        }
        return null;
    }

    private static BdfServerHtmlProducer getMouvementFicheCreation(OutputParameters bdfParameters, RequestHandler requestHandler, Corpus mouvementCorpus, AliasHolder aliasHolder) throws ErrorMessageException {
        FichePointeur mouvementPointeur = PointeurFactory.newFichePointeur((Corpus)mouvementCorpus, (boolean)true);
        FicheFormParameters ficheFormParameters = FicheFormUtils.toFicheFormParameters((OutputParameters)bdfParameters);
        FormElementProvider formElementProvider = ScarabeHtmlProducerProvider.getFormElementProvider(requestHandler, ficheFormParameters, aliasHolder);
        if (formElementProvider == null) {
            formElementProvider = FormElementProviderFactory.newInstance((FicheFormParameters)ficheFormParameters);
        }
        return FicheFormHtmlProducer.newCreationInstance((BdfParameters)bdfParameters, (FichePointeur)mouvementPointeur, (FormElementProvider)formElementProvider);
    }

    private static FicheMeta getMouvement(RequestHandler requestHandler, AliasHolder coreAliasHolder) throws ErrorMessageException {
        String idString = requestHandler.getTrimedParameter("mouvement");
        if (idString.isEmpty()) {
            return null;
        }
        try {
            int id = Integer.parseInt(idString);
            Corpus mouvementCorpus = coreAliasHolder.getCorpus("mouvement");
            return mouvementCorpus.getFicheMetaById(id);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    private static FormElementProvider getFormElementProvider(RequestHandler requestHandler, FicheFormParameters ficheFormParameters, AliasHolder aliasHolder) throws ErrorMessageException {
        Corpus avanceCorpus = aliasHolder.getCorpus("avance");
        Corpus depenseCorpus = aliasHolder.getCorpus("depense");
        String[] soldeAvanceArray = requestHandler.getTokens("avances");
        if (soldeAvanceArray.length > 0) {
            SoldeFormElementProvider.SoldeFicheFormParameters parameters = new SoldeFormElementProvider.SoldeFicheFormParameters();
            parameters.setAvanceCorpus(avanceCorpus);
            parameters.setDepenseCorpus(depenseCorpus);
            int length = soldeAvanceArray.length;
            for (int i = 0; i < length; ++i) {
                String[] tokens;
                for (String token : tokens = StringUtils.getTokens((String)soldeAvanceArray[i], (char)';', (short)2)) {
                    try {
                        boolean done;
                        int id = Integer.parseInt(token);
                        FicheMeta ficheMeta = avanceCorpus.getFicheMetaById(id);
                        if (ficheMeta == null || !(done = parameters.addAvance(ficheMeta))) continue;
                        ScarabeHtmlProducerProvider.addDepenses(parameters, requestHandler.getTokens("depensesparavance_" + id));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            return SoldeFormElementProvider.newInstance(ficheFormParameters, parameters);
        }
        String avenirString = requestHandler.getTrimedParameter("avenir");
        if (!avenirString.isEmpty()) {
            try {
                int id = Integer.parseInt(avenirString);
                FicheMeta depenseAvenir = depenseCorpus.getFicheMetaById(id);
                if (depenseAvenir == null) {
                    return null;
                }
                return AvenirFormElementProvider.newInstance(ficheFormParameters, depenseAvenir, aliasHolder);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        return null;
    }

    private static void addDepenses(SoldeFormElementProvider.SoldeFicheFormParameters parameters, String[] depenseArray) {
        Corpus depenseCorpus = parameters.getDepenseCorpus();
        for (String depense : depenseArray) {
            String[] tokens;
            for (String token : tokens = StringUtils.getTokens((String)depense, (char)';', (short)2)) {
                try {
                    int id = Integer.parseInt(token);
                    FicheMeta ficheMeta = depenseCorpus.getFicheMetaById(id);
                    if (ficheMeta == null) continue;
                    parameters.addDepense(ficheMeta);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    private static IncludeKey initIncludeKey(RequestHandler requestHandler, Fichotheque fichotheque) throws ErrorMessageException {
        String includeKeyString = requestHandler.getMandatoryParameter("includekey");
        try {
            IncludeKey includeKey = IncludeKey.parse((String)includeKeyString);
            SubsetKey subsetKey = includeKey.getSubsetKey();
            if (subsetKey.isThesaurusSubset() && fichotheque.containsSubset(subsetKey)) {
                return includeKey;
            }
            throw BdfErrors.unknownParameterValue((String)"includekey", (String)includeKeyString);
        }
        catch (ParseException pe) {
            throw BdfErrors.wrongParameterValue((String)"includekey", (String)includeKeyString);
        }
    }

    private static List<Motcle> initMotcleList(Fichotheque fichotheque, IncludeKey includeKey) {
        Thesaurus thesaurus = (Thesaurus)fichotheque.getSubset(includeKey.getSubsetKey());
        return ThesaurusUtils.toHierarchicMotcleList((Thesaurus)thesaurus);
    }

    private static int getPageType(String page) {
        switch (page) {
            case "ColumnsConfig": 
            case "PrerequestConfig": 
            case "AnalytiqueConfig": 
            case "InitLog": {
                return 1;
            }
        }
        return 0;
    }

    private static void checkFicheCreate(BdfParameters bdfParameters, Corpus corpus) throws PermissionException {
        PermissionCheck.checkFicheCreate((PermissionSummary)bdfParameters.getPermissionSummary(), (Corpus)corpus);
    }
}

