/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.resourcesupdate;

import fr.exemole.bdfext.resourcesupdate.tools.memento.Destination;
import fr.exemole.bdfext.resourcesupdate.tools.memento.MementoMotcle;
import fr.exemole.bdfext.resourcesupdate.tools.memento.ThesaurusToMemento;
import fr.exemole.bdfext.resourcesupdate.tools.memento.Unit;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfInstruction;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.fichotheque.extraction.ExtractionContext;
import net.mapeadores.util.io.StreamProducer;
import net.mapeadores.util.io.ZipStreamProducer;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.servlets.ResponseHandler;
import net.mapeadores.util.servlets.handlers.StreamResponseHandler;
import net.mapeadores.util.xml.AppendableXMLWriter;
import net.mapeadores.util.xml.XMLUtils;

public class MementoZipBdfInstruction
implements BdfInstruction {
    private final BdfServer bdfServer;

    public MementoZipBdfInstruction(BdfServer bdfServer) {
        this.bdfServer = bdfServer;
    }

    public short getBdfUserNeed() {
        return 1;
    }

    public ResponseHandler runInstruction(BdfUser bdfUser) {
        return StreamResponseHandler.init((StreamProducer)new MementoZipStreamProducer(this.bdfServer));
    }

    private static void zip(BdfServer bdfServer, ZipOutputStream zipOutputStream, String pathRoot) throws IOException {
        BufferedWriter bufWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)zipOutputStream, "UTF-8"));
        AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter((Appendable)bufWriter, (int)0);
        ExtractionContext extractionContext = BdfServerUtils.initAdminExtractionContextBuilder((BdfServer)bdfServer).toExtractionContext();
        for (Destination destination : ThesaurusToMemento.convert(bdfServer.getFichotheque())) {
            for (Unit unit : destination.getUnitList()) {
                zipOutputStream.putNextEntry(new ZipEntry(pathRoot + unit.getTreePath()));
                unit.writeTreeXmlFile(xmlWriter);
                bufWriter.flush();
                for (Lang lang : unit.getAvailableLangs()) {
                    for (MementoMotcle mementoMotcle : unit.getMementoMotcleList()) {
                        if (!mementoMotcle.hasLang(lang)) continue;
                        zipOutputStream.putNextEntry(new ZipEntry(pathRoot + unit.getL10nPath(mementoMotcle, lang)));
                        unit.writeNodeXmlFile(xmlWriter, mementoMotcle, lang, extractionContext);
                        bufWriter.flush();
                    }
                }
            }
            zipOutputStream.putNextEntry(new ZipEntry(pathRoot + destination.getOrderPath()));
            bufWriter.write(destination.getOrderTxt());
            bufWriter.flush();
        }
    }

    private static class MementoZipStreamProducer
    extends ZipStreamProducer {
        private final BdfServer bdfServer;

        private MementoZipStreamProducer(BdfServer bdfServer) {
            this.bdfServer = bdfServer;
        }

        public void writeZipStream(ZipOutputStream zipOutputStream) throws IOException {
            MementoZipBdfInstruction.zip(this.bdfServer, zipOutputStream, "");
        }
    }
}

