/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.xml.api;

import java.awt.Color;
import java.text.ParseException;
import java.util.function.Consumer;
import net.desmodo.atlas.AtlasAttributes;
import net.desmodo.atlas.AtlasEditor;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.ExistingGrilleNameException;
import net.desmodo.atlas.structure.ExistingIdctxtException;
import net.desmodo.atlas.structure.Grille;
import net.desmodo.atlas.structure.GrilleEditor;
import net.desmodo.atlas.structure.InvalidGrilleNameException;
import net.desmodo.atlas.structure.InvalidIdctxtException;
import net.desmodo.atlas.structure.RecursiveException;
import net.desmodo.atlas.structure.StructureEditor;
import net.desmodo.atlas.xml.api.AtlasDOMErrorHandler;
import net.desmodo.atlas.xml.api.AttributeDOMReader;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeBuilder;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.text.CleanedString;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class StructureDOMReader {
    private final AtlasDOMErrorHandler errorHandler;
    private final StructureEditor structureEditor;
    private String xpath;
    private final AttributeDOMReader attributeDOMReader;
    private final AtlasEditor atlasEditor;

    public StructureDOMReader(AtlasEditor atlasEditor, AtlasDOMErrorHandler errorHandler) {
        this.structureEditor = atlasEditor.getStructureEditor();
        this.errorHandler = errorHandler;
        this.attributeDOMReader = new AttributeDOMReader(atlasEditor, errorHandler);
        this.atlasEditor = atlasEditor;
    }

    public void readStructureElement(Element element, String xpath) {
        this.xpath = xpath;
        DOMUtils.readChildren((Element)element, (Consumer)new StructureConsumer());
    }

    private void setColor(Object attributesHolder, Element element) {
        CleanedString cleanedString = XMLUtils.toCleanedString((Element)element);
        if (cleanedString != null) {
            try {
                Color.decode(cleanedString.toString());
                Attribute attribute = AttributeBuilder.toAttribute((AttributeKey)AtlasAttributes.COLOR_KEY, (CleanedString)cleanedString);
                this.atlasEditor.putAttribute(attributesHolder, attribute);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private class StructureConsumer
    implements Consumer<Element> {
        private StructureConsumer() {
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("grille")) {
                String grilleName = element.getAttribute("name");
                if (grilleName.length() == 0) {
                    grilleName = element.getAttribute("grl");
                }
                if (grilleName.length() == 0) {
                    grilleName = element.getAttribute("nomgrille");
                }
                if (grilleName.length() == 0) {
                    StructureDOMReader.this.errorHandler.missingAttributeError("name", StructureDOMReader.this.xpath + "/grille");
                }
                Grille grille = StructureDOMReader.this.structureEditor.getStructure().getGrille(grilleName);
                GrilleEditor grilleEditor = null;
                if (grille == null) {
                    try {
                        grilleEditor = StructureDOMReader.this.structureEditor.createGrille(grilleName);
                    }
                    catch (InvalidGrilleNameException inme) {
                        StructureDOMReader.this.errorHandler.wrongAttributeError("name", grilleName, "InvalidGrilleName", StructureDOMReader.this.xpath + "/grille");
                        return;
                    }
                    catch (ExistingGrilleNameException enmg) {
                        throw new ShouldNotOccurException();
                    }
                } else {
                    grilleEditor = StructureDOMReader.this.structureEditor.getGrilleEditor(grille);
                }
                DOMUtils.readChildren((Element)element, (Consumer)new GrilleConsumer(grilleEditor));
            } else if (tagName.equals("familles")) {
                DOMUtils.readChildren((Element)element, (Consumer)new GrilleConsumer(StructureDOMReader.this.structureEditor.getGrilleEditor(StructureDOMReader.this.structureEditor.getStructure().getGrilleDesFamilles())));
            } else {
                StructureDOMReader.this.errorHandler.unknownTagWarning(tagName, StructureDOMReader.this.xpath);
            }
        }
    }

    private abstract class CtxtParentConsumer
    implements Consumer<Element> {
        protected GrilleEditor grilleEditor;
        protected String xp;

        protected CtxtParentConsumer(GrilleEditor grilleEditor) {
            this.grilleEditor = grilleEditor;
        }

        protected void setXPath(String xp) {
            this.xp = StructureDOMReader.this.xpath;
        }

        protected void addContexte(Element element, Contexte parent) {
            Contexte contexte;
            String idctxt = element.getAttribute("idctxt");
            if (idctxt.length() == 0) {
                StructureDOMReader.this.errorHandler.missingAttributeError("idctxt", this.xp + "/contexte");
                return;
            }
            try {
                contexte = this.grilleEditor.createContexte(idctxt);
            }
            catch (ExistingIdctxtException eie) {
                StructureDOMReader.this.errorHandler.wrongAttributeError("idctxt", idctxt, "ExistingIdctxt", this.xp + "/contexte");
                return;
            }
            catch (InvalidIdctxtException iie) {
                StructureDOMReader.this.errorHandler.wrongAttributeError("idctxt", idctxt, "InvalidIdctxt", this.xp + "/contexte");
                return;
            }
            String activeBoolean = element.getAttribute("active");
            if (activeBoolean.equals("0")) {
                this.grilleEditor.setActive(contexte, false);
            }
            if (parent != null) {
                try {
                    this.grilleEditor.setParent(contexte, parent);
                }
                catch (RecursiveException re) {
                    throw new ShouldNotOccurException((Exception)re);
                }
            }
            DOMUtils.readChildren((Element)element, (Consumer)new ContexteConsumer(this.grilleEditor, contexte, this.xp));
        }
    }

    private class ContexteConsumer
    extends CtxtParentConsumer {
        private final Contexte contexte;

        private ContexteConsumer(GrilleEditor grilleEditor, Contexte contexte, String xpath) {
            super(grilleEditor);
            this.setXPath(xpath + "/contexte[@idctxt='" + contexte.getIdctxt() + "']");
            this.contexte = contexte;
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("lib")) {
                try {
                    Label libelle = LabelUtils.readLabel((Element)element);
                    if (libelle != null) {
                        StructureDOMReader.this.atlasEditor.putLibelle(this.contexte, libelle);
                    }
                }
                catch (ParseException lie) {
                    StructureDOMReader.this.errorHandler.libLangAttributeError(element.getAttribute("xml:lang"), this.xp + "/lib");
                }
            } else if (tagName.equals("color")) {
                StructureDOMReader.this.setColor(this.contexte, element);
            } else if (tagName.equals("attr")) {
                StructureDOMReader.this.attributeDOMReader.readAttrElement(element, this.contexte, this.xp);
            } else if (tagName.equals("contexte")) {
                this.addContexte(element, this.contexte);
            } else {
                StructureDOMReader.this.errorHandler.unknownTagWarning(tagName, this.xp);
            }
        }
    }

    private class GrilleConsumer
    extends CtxtParentConsumer {
        private GrilleConsumer(GrilleEditor grilleEditor) {
            super(grilleEditor);
            String grlName = grilleEditor.getGrille().getGrilleName();
            if (grlName.length() == 0) {
                this.setXPath(StructureDOMReader.this.xpath + "/familles");
            } else {
                this.setXPath(StructureDOMReader.this.xpath + "/grille[@grl='" + grlName + "']");
            }
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            if (tagName.equals("lib")) {
                try {
                    Label libelle = LabelUtils.readLabel((Element)element);
                    if (libelle != null) {
                        StructureDOMReader.this.atlasEditor.putLibelle(this.grilleEditor.getGrille(), libelle);
                    }
                }
                catch (ParseException lie) {
                    StructureDOMReader.this.errorHandler.libLangAttributeError(element.getAttribute("xml:lang"), this.xp + "/lib");
                }
            } else if (tagName.equals("color")) {
                StructureDOMReader.this.setColor(this.grilleEditor.getGrille(), element);
            } else if (tagName.equals("attr")) {
                StructureDOMReader.this.attributeDOMReader.readAttrElement(element, this.grilleEditor.getGrille(), this.xp);
            } else if (tagName.equals("contexte")) {
                this.addContexte(element, null);
            } else {
                StructureDOMReader.this.errorHandler.unknownTagWarning(tagName, this.xp);
            }
        }
    }
}

