/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.wrapper;

import net.desmodo.atlas.AtlasUtils;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.tools.multilist.MultiListItem;
import net.desmodo.atlas.wrapper.GroupeItem;
import net.desmodo.atlas.wrapper.GroupeItemImpl;
import net.desmodo.atlas.wrapper.LibelleItem;
import net.desmodo.atlas.wrapper.LibelleItemManagerImpl;
import net.mapeadores.util.text.collation.CollationUnit;

class LibelleItemImpl
extends MultiListItem
implements LibelleItem {
    private final LibelleItemManagerImpl libelleItemManager;
    private String libelle;
    private final int termCode;
    private int sortedDescripteurLibelleItemIndex = -1;
    private GroupeItemImpl groupeItem;
    private final short termType;
    private CollationUnit collatedString;

    LibelleItemImpl(LibelleItemManagerImpl libelleItemManager, Term term) {
        super(null, LibelleItemImpl.getActiveMask(term));
        this.termCode = term.getCode();
        this.termType = term.getTermType();
        this.libelleItemManager = libelleItemManager;
        this.setLibelle(AtlasUtils.toLibelleString(term, libelleItemManager.getWorkingLang()));
    }

    @Override
    public Object getWrappedObject() {
        return this;
    }

    static int getActiveMask(Term term) {
        if (term instanceof Contexte) {
            if (!((Contexte)term).isActive()) {
                return 0;
            }
            return 1;
        }
        return 1;
    }

    void setLibelle(String libelle) {
        this.libelle = libelle;
        this.collatedString = new CollationUnit(libelle, this.libelleItemManager.getCollator());
    }

    GroupeItemImpl getGroupeItemImpl() {
        return this.groupeItem;
    }

    void setGroupeItemImpl(GroupeItemImpl internalGroupeItem) {
        internalGroupeItem.getInternalLibelleItemMultiList().add(this);
        this.groupeItem = internalGroupeItem;
    }

    void clear() {
        this.groupeItem.getInternalLibelleItemMultiList().remove(this);
        this.groupeItem = null;
    }

    @Override
    public String toString() {
        return this.libelle;
    }

    @Override
    public GroupeItem getGroupeItem() {
        return this.groupeItem;
    }

    @Override
    public int getGroupeIndex() {
        return this.getSecondaryIndex(0);
    }

    @Override
    public int getGroupeSize() {
        return this.groupeItem.getSize();
    }

    @Override
    public int getTermCode() {
        return this.termCode;
    }

    @Override
    public short getTermType() {
        return this.termType;
    }

    @Override
    public CollationUnit getCollatedString() {
        return this.collatedString;
    }

    public int getSortedDescripteurLibelleItemIndex() {
        return this.sortedDescripteurLibelleItemIndex;
    }

    public void setSortedDescripteurLibelleItemIndex(int sortedDescripteurLibelleItemIndex) {
        this.sortedDescripteurLibelleItemIndex = sortedDescripteurLibelleItemIndex;
    }
}

