/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.sxio;

import java.io.OutputStream;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import net.desmodo.atlas.sxio.SXContentSource;
import net.desmodo.atlas.sxio.SXIOException;

public class TransformSXContentSource
implements SXContentSource {
    String formatName;
    Transformer transformer;
    String encoding;
    Source source;

    public TransformSXContentSource(String formatName, Transformer transformer, Source source) {
        this.formatName = formatName;
        this.transformer = transformer;
        this.source = source;
        this.encoding = transformer.getOutputProperty("encoding");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public String getFormatName() {
        return this.formatName;
    }

    @Override
    public boolean needDeclaration() {
        return true;
    }

    @Override
    public boolean needRootElement() {
        return false;
    }

    @Override
    public void writeContent(OutputStream outputStream) throws SXIOException {
        try {
            this.transformer.transform(this.source, new StreamResult(outputStream));
        }
        catch (TransformerException te) {
            throw new SXIOException(te);
        }
    }
}

