/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.sxio;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.desmodo.atlas.sxio.SXContentSource;
import net.desmodo.atlas.sxio.SXIOException;
import net.desmodo.atlas.sxio.SXStylesSource;

public class SXIO {
    static final String metaZipEntry = "<?xml version='1.0' encoding='UTF-8'?>\n<!DOCTYPE office:document-meta PUBLIC '-//OpenOffice.org//DTD OfficeDocument 1.0//EN' 'office.dtd'><office:document-meta xmlns:office='http://openoffice.org/2000/office' xmlns:xlink='http://www.w3.org/1999/xlink' xmlns:dc='http://purl.org/dc/elements/1.1/' xmlns:meta='http://openoffice.org/2000/meta' xmlns:presentation='http://openoffice.org/2000/presentation' office:version='1.0'></office:document-meta>";
    static final String settingsZipEntry = "<?xml version='1.0' encoding='UTF-8'?>\n<!DOCTYPE office:document-settings PUBLIC '-//OpenOffice.org//DTD OfficeDocument 1.0//EN' 'office.dtd'><office:document-settings xmlns:office='http://openoffice.org/2000/office' xmlns:xlink='http://www.w3.org/1999/xlink' xmlns:presentation='http://openoffice.org/2000/presentation' xmlns:config='http://openoffice.org/2001/config' office:version='1.0'></office:document-settings>";
    static final String startStylesZipEntry = "<?xml version='1.0' encoding='UTF-8'?>\n<!DOCTYPE office:document-styles PUBLIC '-//OpenOffice.org//DTD OfficeDocument 1.0//EN' 'office.dtd'><office:document-styles xmlns:office='http://openoffice.org/2000/office' xmlns:style='http://openoffice.org/2000/style' xmlns:text='http://openoffice.org/2000/text' xmlns:table='http://openoffice.org/2000/table' xmlns:draw='http://openoffice.org/2000/drawing' xmlns:fo='http://www.w3.org/1999/XSL/Format' xmlns:xlink='http://www.w3.org/1999/xlink' xmlns:number='http://openoffice.org/2000/datastyle' xmlns:presentation='http://openoffice.org/2000/presentation' xmlns:svg='http://www.w3.org/2000/svg' xmlns:chart='http://openoffice.org/2000/chart' xmlns:dr3d='http://openoffice.org/2000/dr3d' xmlns:math='http://www.w3.org/1998/Math/MathML' xmlns:form='http://openoffice.org/2000/form' xmlns:script='http://openoffice.org/2000/script' office:version='1.0'>\n";
    static final String endStylesZipEntry = "</office:document-styles>";

    public static boolean write(File f, SXContentSource contentSource, SXStylesSource stylesSource) throws SXIOException, FileNotFoundException {
        return SXIO.write(new FileOutputStream(f), contentSource, stylesSource);
    }

    public static boolean write(OutputStream stream, SXContentSource contentSource, SXStylesSource stylesSource) throws SXIOException {
        try {
            ZipOutputStream ecriturezip = new ZipOutputStream(stream);
            SXIO.writeOthersZipEntries(ecriturezip, contentSource.getFormatName());
            SXIO.writeContentZipEntry(ecriturezip, contentSource);
            SXIO.writeStylesZipEntry(ecriturezip, stylesSource);
            ecriturezip.close();
        }
        catch (SXIOException sxioe) {
            throw sxioe;
        }
        catch (IOException ioe) {
            throw new SXIOException(ioe);
        }
        return true;
    }

    private static void writeContentZipEntry(ZipOutputStream zip, SXContentSource contentSource) throws IOException {
        ZipEntry entreezip = new ZipEntry("content.xml");
        zip.putNextEntry(entreezip);
        String encoding = contentSource.getEncoding();
        if (contentSource.needDeclaration()) {
            zip.write(SXIO.getDeclaration(encoding));
        }
        if (contentSource.needRootElement()) {
            zip.write("<office:document-content xmlns:office='http://openoffice.org/2000/office' xmlns:style='http://openoffice.org/2000/style' xmlns:text='http://openoffice.org/2000/text' xmlns:table='http://openoffice.org/2000/table' xmlns:draw='http://openoffice.org/2000/drawing' xmlns:fo='http://www.w3.org/1999/XSL/Format' xmlns:xlink='http://www.w3.org/1999/xlink' xmlns:number='http://openoffice.org/2000/datastyle' xmlns:presentation='http://openoffice.org/2000/presentation' xmlns:svg='http://www.w3.org/2000/svg' xmlns:chart='http://openoffice.org/2000/chart' xmlns:dr3d='http://openoffice.org/2000/dr3d' xmlns:math='http://www.w3.org/1998/Math/MathML' xmlns:form='http://openoffice.org/2000/form' xmlns:script='http://openoffice.org/2000/script' office:class='".getBytes(encoding));
            zip.write(SXIO.getSXClass(contentSource.getFormatName()).getBytes(encoding));
            zip.write("' office:version='1.0'>\n".getBytes(encoding));
        }
        contentSource.writeContent(zip);
        if (contentSource.needRootElement()) {
            zip.write("</office:document-content>".getBytes(encoding));
        }
        zip.closeEntry();
    }

    private static byte[] getDeclaration(String encoding) throws IOException {
        StringBuffer buf = new StringBuffer(62);
        buf.append("<?xml version='1.0' encoding='");
        buf.append(encoding);
        buf.append("'?>\n<!DOCTYPE office:document-content PUBLIC '-//OpenOffice.org//DTD OfficeDocument 1.0//EN' 'office.dtd'>");
        return buf.toString().getBytes(encoding);
    }

    private static void writeStylesZipEntry(ZipOutputStream zip, SXStylesSource stylesSource) throws IOException {
        ZipEntry entreezip = new ZipEntry("styles.xml");
        zip.putNextEntry(entreezip);
        String encoding = stylesSource.getEncoding();
        zip.write(startStylesZipEntry.getBytes(encoding));
        stylesSource.writeStyles(zip);
        zip.write(endStylesZipEntry.getBytes(encoding));
        zip.closeEntry();
    }

    private static void writeOthersZipEntries(ZipOutputStream zip, String formatName) throws IOException {
        ByteArrayInputStream lectureMeta = new ByteArrayInputStream(metaZipEntry.getBytes("UTF-8"));
        SXIO.saveZipEntry(zip, lectureMeta, "meta.xml");
        ByteArrayInputStream lectureSettings = new ByteArrayInputStream(settingsZipEntry.getBytes("UTF-8"));
        SXIO.saveZipEntry(zip, lectureSettings, "settings.xml");
        ByteArrayInputStream lectureManifest = new ByteArrayInputStream(SXIO.getManifestZipEntry(formatName).getBytes("UTF-8"));
        SXIO.saveZipEntry(zip, lectureManifest, "META-INF/manifest.xml");
    }

    private static void saveZipEntry(ZipOutputStream zip, ByteArrayInputStream is, String nom) throws IOException {
        int n;
        ZipEntry entreezip = new ZipEntry(nom);
        zip.putNextEntry(entreezip);
        byte[] buffer = new byte[1004];
        while ((n = is.read(buffer)) != -1) {
            zip.write(buffer, 0, n);
        }
        zip.closeEntry();
    }

    private static void saveZipEntry(ZipOutputStream zip, String[] textes, String nom) throws IOException {
        int pas = 1000;
        ZipEntry entreezip = new ZipEntry(nom);
        zip.putNextEntry(entreezip);
        for (int i = 0; i < textes.length; ++i) {
            String texte = textes[i];
            int length = texte.length();
            int tampon = Math.min(pas, length);
            int q = 0;
            while (tampon > 0) {
                byte[] buffer = texte.substring(q * pas, q * pas + tampon).getBytes("UTF-8");
                zip.write(buffer);
                tampon = Math.min(pas, length - ++q * pas);
            }
        }
        zip.closeEntry();
    }

    public static String getSXClass(String formatName) {
        if (formatName.equals("sxw")) {
            return "text";
        }
        if (formatName.equals("sxc")) {
            return "spreadsheet";
        }
        if (formatName.equals("sxd")) {
            return "drawing";
        }
        if (formatName.equals("sxi")) {
            return "presentation";
        }
        return "";
    }

    public static String getMimeType(String formatName) {
        if (formatName.equals("sxc")) {
            return "application/vnd.sun.xml.calc";
        }
        if (formatName.equals("sxw")) {
            return "application/vnd.sun.xml.writer";
        }
        if (formatName.equals("sxd")) {
            return "application/vnd.sun.xml.draw";
        }
        if (formatName.equals("sxi")) {
            return "application/vnd.sun.xml.impress";
        }
        return "";
    }

    private static String getManifestZipEntry(String formatName) {
        StringBuffer buf = new StringBuffer(100);
        buf.append("<?xml version='1.0' encoding='UTF-8'?>\n");
        buf.append("<!DOCTYPE manifest:manifest PUBLIC \"-//OpenOffice.org//DTD Manifest 1.0//EN\" \"Manifest.dtd\">\n");
        buf.append("<manifest:manifest xmlns:manifest='http://openoffice.org/2001/manifest'>\n");
        buf.append("<manifest:file-entry manifest:media-type='");
        buf.append(SXIO.getMimeType(formatName));
        buf.append("' manifest:full-path='/'/>\n");
        buf.append("<manifest:file-entry manifest:media-type='' manifest:full-path='Pictures/'/>\n");
        buf.append("<manifest:file-entry manifest:media-type='text/xml' manifest:full-path='content.xml'/>\n");
        buf.append("<manifest:file-entry manifest:media-type='text/xml' manifest:full-path='styles.xml'/>\n");
        buf.append(" <manifest:file-entry manifest:media-type='text/xml' manifest:full-path='meta.xml'/>\n");
        buf.append("<manifest:file-entry manifest:media-type='text/xml' manifest:full-path='settings.xml'/>\n");
        buf.append("</manifest:manifest>\n");
        return buf.toString();
    }
}

