/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.session;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.AtlasEditor;
import net.desmodo.atlas.AtlasURI;
import net.desmodo.atlas.AtlasUtils;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.commands.AttributesEdit;
import net.desmodo.atlas.commands.DescripteurEdit;
import net.desmodo.atlas.commands.TermEdit;
import net.desmodo.atlas.conf.Conf;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.descripteurs.DescripteursEditor;
import net.desmodo.atlas.descripteurs.DescripteursUtils;
import net.desmodo.atlas.descripteurs.ExistingIddescException;
import net.desmodo.atlas.descripteurs.UnremovableDescripteurException;
import net.desmodo.atlas.liens.Lien;
import net.desmodo.atlas.liens.LienExistantException;
import net.desmodo.atlas.liens.LienHierarchique;
import net.desmodo.atlas.liens.LienHierarchiqueGroup;
import net.desmodo.atlas.liens.LienHierarchiqueGroupList;
import net.desmodo.atlas.liens.LienHierarchiqueList;
import net.desmodo.atlas.liens.LienNaturel;
import net.desmodo.atlas.liens.LienStructurel;
import net.desmodo.atlas.liens.LienStructurelList;
import net.desmodo.atlas.liens.LienSurLuiMemeException;
import net.desmodo.atlas.liens.LienSymetrique;
import net.desmodo.atlas.liens.LienSymetriqueList;
import net.desmodo.atlas.liens.Liens;
import net.desmodo.atlas.liens.LiensEditor;
import net.desmodo.atlas.liens.LiensFilter;
import net.desmodo.atlas.liens.LiensUtils;
import net.desmodo.atlas.metadata.AtlasMetadata;
import net.desmodo.atlas.session.Navigation;
import net.desmodo.atlas.session.Session;
import net.desmodo.atlas.session.SessionConf;
import net.desmodo.atlas.session.SessionConfKeys;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.Grille;
import net.desmodo.atlas.structure.InvalidContexteException;
import net.desmodo.atlas.structure.Structure;
import net.desmodo.atlas.structure.StructureUtils;
import net.desmodo.atlas.ventilation.Liaison;
import net.desmodo.atlas.ventilation.Secteur;
import net.desmodo.atlas.wrapper.DisplayParameters;
import net.desmodo.atlas.wrapper.GroupeItem;
import net.desmodo.atlas.wrapper.LibelleItem;
import net.mapeadores.util.attr.AttributeChange;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.CleanedString;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.LabelChange;
import net.mapeadores.util.text.LabelUtils;

public final class SessionUtils
implements SessionConfKeys {
    private SessionUtils() {
    }

    public static Term getHomeTerm(String ventilationRootString, Atlas atlas) {
        Term terme = AtlasURI.parseURI(atlas, ventilationRootString);
        if (terme != null) {
            Contexte contexte;
            if (terme instanceof Grille) {
                terme = null;
            }
            if (terme instanceof Contexte && (StructureUtils.isSpecialContexte(contexte = (Contexte)terme) || StructureUtils.isFamille(contexte))) {
                terme = null;
            }
        }
        return terme;
    }

    public static DisplayParameters getDisplayParameters(SessionConf sessionConf) {
        return new DisplayParameters(sessionConf.getLang("lang.current"), sessionConf.getBoolean("lang.defaultlib"));
    }

    public static GroupeItem getFamilleGroupeItem(Session session, Descripteur descripteur) {
        LibelleItem li = session.getLibelleItemManager().getLibelleItem(descripteur.getCode());
        return li.getGroupeItem();
    }

    public static Lang getWorkingLang(Session session) {
        return session.getSessionConf().getLang("lang.current");
    }

    public static Term getTerm(Navigation navigation, int code) {
        return SessionUtils.getTerm(navigation.getSession(), code);
    }

    public static Term getTerm(Session session, int code) {
        Term term = session.getAtlas().getTerm(code);
        if (term == null) {
            throw new IllegalStateException("missingTerm :  more Term with code in argument of SessionUtils.getTerm");
        }
        return term;
    }

    public static Descripteur getDescripteur(Session session, int code) {
        try {
            Descripteur descripteur = (Descripteur)session.getAtlas().getTerm(code);
            if (descripteur == null) {
                throw new IllegalStateException("missingTerm : No  more Term with code in argument of SessionUtils.getTerm");
            }
            return descripteur;
        }
        catch (ClassCastException cce) {
            throw new IllegalStateException("illegalCodeException : le code ne correspond pas \u00e0 un descripteur");
        }
    }

    public static Contexte getContexte(Session session, int code) {
        try {
            Contexte contexte = (Contexte)session.getAtlas().getTerm(code);
            if (contexte == null) {
                throw new IllegalStateException("missingTerm : No  more Term with code in argument of SessionUtils.getTerm");
            }
            return contexte;
        }
        catch (ClassCastException cce) {
            throw new IllegalStateException("illegalCodeException : le code ne correspond pas \u00e0 un contexte");
        }
    }

    public static Grille getGrille(Session session, int code) {
        try {
            Grille grille = (Grille)session.getAtlas().getTerm(code);
            if (grille == null) {
                throw new IllegalStateException("missingTerm : No  more Term with code in argument of SessionUtils.getTerm");
            }
            return grille;
        }
        catch (ClassCastException cce) {
            throw new IllegalStateException("illegalCodeException : le code ne correspond pas \u00e0 un contexte");
        }
    }

    public static int getLienCount(Session session, int codeDescripteur) {
        Descripteur descripteur = SessionUtils.getDescripteur(session, codeDescripteur);
        return session.getAtlas().getLiens().getLienCount(descripteur);
    }

    public static boolean removeDescripteur(Session session, int codeDescripteur) {
        try {
            Descripteur descripteur = SessionUtils.getDescripteur(session, codeDescripteur);
            if (session.getAtlas().getLiens().getLienCount(descripteur) > 0) {
                return false;
            }
            session.getAtlasEditor().getDescripteursEditor().removeDescripteur(descripteur);
            return true;
        }
        catch (UnremovableDescripteurException ude) {
            throw new IllegalStateException("unremoveabledDescripteurException : Ne devrait pas arriver puisque le test a \u00e9t\u00e9 fait avant");
        }
    }

    public static boolean setFamille(Session session, int codeDescripteur, int codeFamille) {
        Atlas atlas = session.getAtlas();
        try {
            Descripteur descripteur = SessionUtils.getDescripteur(session, codeDescripteur);
            Contexte famille = SessionUtils.getContexte(session, codeFamille);
            boolean done = session.getAtlasEditor().getDescripteursEditor().setFamille(descripteur, famille);
            return done;
        }
        catch (InvalidContexteException cce) {
            throw new IllegalStateException("invalidContexteException : le code de famille ne correspond pas \u00e0 une famille");
        }
    }

    public static void setFamille(Session session, int[] codes, int codeFamille) {
        if (codes == null) {
            throw new IllegalArgumentException("codes is null");
        }
        AtlasEditor atlasEditor = session.getAtlasEditor();
        int length = codes.length;
        if (length == 0) {
            return;
        }
        try {
            Descripteur[] descripteurs = new Descripteur[length];
            for (int i = 0; i < length; ++i) {
                descripteurs[i] = SessionUtils.getDescripteur(session, codes[i]);
            }
            Contexte famille = SessionUtils.getContexte(session, codeFamille);
            atlasEditor.startCompoundEvent(session, "muliFamilleSet");
            for (int i = 0; i < length; ++i) {
                atlasEditor.getDescripteursEditor().setFamille(descripteurs[i], famille);
            }
            atlasEditor.endCompoundEvent(session, "descripteursMerge");
        }
        catch (InvalidContexteException cce) {
            throw new IllegalStateException("invalidContexteException : le code de famille ne correspond pas \u00e0 une famille");
        }
    }

    public static void mergeDescripteurs(Session session, int destinationCode, int[] codes) {
        int i;
        Liens liens = session.getAtlas().getLiens();
        AtlasEditor atlasEditor = session.getAtlasEditor();
        LiensEditor liensEditor = atlasEditor.getLiensEditor();
        int mergeSize = codes.length;
        Descripteur destinationdescripteur = SessionUtils.getDescripteur(session, destinationCode);
        Descripteur[] merged = new Descripteur[mergeSize];
        for (i = 0; i < mergeSize; ++i) {
            merged[i] = SessionUtils.getDescripteur(session, codes[i]);
        }
        atlasEditor.startCompoundEvent(session, "descripteursMerge");
        for (i = 0; i < mergeSize; ++i) {
            int j;
            LienSymetrique lsm;
            int j2;
            int j3;
            int j4;
            Descripteur desc = merged[i];
            if (liens.getLienCount(desc) <= 0) continue;
            Liens.LienLists lienLists = liens.getLienLists(desc);
            LienHierarchiqueGroupList listeLhg = lienLists.getLienHierarchiqueGroupList();
            int groupCount = listeLhg.getLienHierarchiqueGroupCount();
            ArrayList<LienNaturel> templist = new ArrayList<LienNaturel>();
            for (j4 = 0; j4 < groupCount; ++j4) {
                LienHierarchiqueGroup lhg = listeLhg.getLienHierarchiqueGroup(j4);
                Contexte contexte = lhg.getContexte();
                int lienCount = lhg.getLienHierarchiqueCount();
                for (int k = 0; k < lienCount; ++k) {
                    LienHierarchique lh = lhg.getLienHierarchique(k);
                    Descripteur descfils = lh.getDescripteurFils();
                    templist.add(lh);
                    if (descfils.equals(destinationdescripteur)) continue;
                    try {
                        liensEditor.createLienHierarchique(destinationdescripteur, descfils, contexte, -1);
                        continue;
                    }
                    catch (LienExistantException lienExistantException) {
                        continue;
                    }
                    catch (LienSurLuiMemeException lienSurLuiMemeException) {
                        continue;
                    }
                    catch (InvalidContexteException invalidContexteException) {
                        // empty catch block
                    }
                }
            }
            for (j4 = 0; j4 < templist.size(); ++j4) {
                LienHierarchique lh = (LienHierarchique)templist.get(j4);
                liensEditor.removeLienHierarchique(lh.getDescripteurPere(), lh.getDescripteurFils(), lh.getContexte());
            }
            templist.clear();
            LienHierarchiqueList listeLh = lienLists.getLienHierarchiqueList();
            int lhCount = listeLh.getLienHierarchiqueCount();
            for (j3 = 0; j3 < lhCount; ++j3) {
                LienHierarchique lh = listeLh.getLienHierarchique(j3);
                templist.add(lh);
                try {
                    liensEditor.createLienHierarchique(lh.getDescripteurPere(), destinationdescripteur, lh.getContexte(), lh.getLienHierarchiqueIndex());
                    continue;
                }
                catch (LienExistantException k) {
                    continue;
                }
                catch (LienSurLuiMemeException k) {
                    continue;
                }
                catch (InvalidContexteException k) {
                    // empty catch block
                }
            }
            for (j3 = 0; j3 < templist.size(); ++j3) {
                LienHierarchique lh = (LienHierarchique)templist.get(j3);
                liensEditor.removeLienHierarchique(lh.getDescripteurPere(), lh.getDescripteurFils(), lh.getContexte());
            }
            templist.clear();
            LienSymetriqueList listeLsm = lienLists.getLienSymetriqueList();
            int lsCount = listeLsm.getLienSymetriqueCount();
            for (j2 = 0; j2 < lsCount; ++j2) {
                lsm = listeLsm.getLienSymetrique(j2);
                templist.add(lsm);
                try {
                    int index = 1;
                    int otherindex = 0;
                    Descripteur other = lsm.getDescripteur(otherindex);
                    if (other.equals(desc)) {
                        otherindex = 1;
                        index = 0;
                        other = lsm.getDescripteur(otherindex);
                    }
                    if (other.equals(destinationdescripteur)) continue;
                    liensEditor.createLienSymetrique(destinationdescripteur, lsm.getContexte(index), other, lsm.getContexte(otherindex));
                    continue;
                }
                catch (LienSurLuiMemeException index) {
                    continue;
                }
                catch (LienExistantException index) {
                    // empty catch block
                }
            }
            for (j2 = 0; j2 < templist.size(); ++j2) {
                lsm = (LienSymetrique)templist.get(j2);
                liensEditor.removeLienSymetrique(lsm.getDescripteur(0), lsm.getDescripteur(1));
            }
            templist.clear();
            LienStructurelList listeLst = lienLists.getLienStructurelList();
            int lstCount = listeLst.getLienStructurelCount();
            for (j = 0; j < lstCount; ++j) {
                LienStructurel lst = listeLst.getLienStructurel(j);
                templist.add(lst);
                try {
                    liensEditor.addDescripteur(lst.getContexte1(), lst.getContexte2(), destinationdescripteur, DescripteursUtils.indexOf(lst.getDescripteurList(), desc));
                    continue;
                }
                catch (LienExistantException lienExistantException) {
                    continue;
                }
                catch (InvalidContexteException invalidContexteException) {
                    // empty catch block
                }
            }
            for (j = 0; j < templist.size(); ++j) {
                LienStructurel lst = (LienStructurel)templist.get(j);
                liensEditor.removeDescripteur(lst.getContexte1(), lst.getContexte2(), desc);
            }
        }
        DescripteursEditor descripteursEditor = atlasEditor.getDescripteursEditor();
        for (int i2 = 0; i2 < mergeSize; ++i2) {
            Descripteur desc = merged[i2];
            try {
                descripteursEditor.removeDescripteur(desc);
                continue;
            }
            catch (UnremovableDescripteurException ude) {
                throw new IllegalStateException("unremoveabledDescripteurException : Ne devrait pas arriver puisque tous les liens ont \u00e9t\u00e9 supprim\u00e9s avant");
            }
        }
        atlasEditor.endCompoundEvent(session, "descripteursMerge");
    }

    public static boolean removeLiaison(Session session, Liaison liaison) {
        Lien lien = liaison.getLien();
        if (!(lien instanceof LienNaturel)) {
            return false;
        }
        LiensEditor liensEditor = session.getAtlasEditor().getLiensEditor();
        if (lien instanceof LienSymetrique) {
            LienSymetrique lsm = (LienSymetrique)lien;
            liensEditor.removeLienSymetrique(lsm.getDescripteur(0), lsm.getDescripteur(1));
        } else if (lien instanceof LienHierarchique) {
            LienHierarchique lh = (LienHierarchique)lien;
            liensEditor.removeLienHierarchique(lh.getDescripteurPere(), lh.getDescripteurFils(), lh.getContexte());
        } else if (lien instanceof LienStructurel) {
            LienStructurel lienStructurel = (LienStructurel)lien;
            Term term = liaison.getTerm();
            if (term instanceof Descripteur) {
                Descripteur descripteur = (Descripteur)term;
                liensEditor.removeDescripteur(lienStructurel.getContexte1(), lienStructurel.getContexte2(), descripteur);
            } else {
                try {
                    Descripteur descripteur = (Descripteur)liaison.getSecteur().getVentilation().getRoot();
                    liensEditor.removeDescripteur(lienStructurel.getContexte1(), lienStructurel.getContexte2(), descripteur);
                }
                catch (ClassCastException cce) {
                    throw new ClassCastException("liaison.getVentilation().getRoot() has to be an instance of Descripteur");
                }
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean changeSecteur(Session session, Liaison liaison, Secteur secteur) throws LienExistantException, LienSurLuiMemeException, InvalidContexteException {
        if (liaison.getSecteur().equals(secteur)) {
            return false;
        }
        Lien lien = liaison.getLien();
        if (!(lien instanceof LienNaturel)) {
            return false;
        }
        AtlasEditor atlasEditor = session.getAtlasEditor();
        LiensEditor liensEditor = atlasEditor.getLiensEditor();
        Term secteurTerm = secteur.getSecteurTerm();
        Term liaisonTerm = liaison.getTerm();
        Term rootTerm = liaison.getSecteur().getVentilation().getRoot();
        if (rootTerm == null) {
            throw new IllegalStateException("nullVentilationRoot : SessionUtils ne traite pas des cas o\u00f9 la racine de la ventilation est nulle");
        }
        short secteurType = secteurTerm.getTermType();
        if (lien instanceof LienSymetrique) {
            LienSymetrique lsm = (LienSymetrique)lien;
            if (secteurType == 3 || secteurType == 5) {
                int descindex = 0;
                int otherindex = 1;
                if (!lsm.getDescripteur(0).equals(liaison.getTerm())) {
                    descindex = 1;
                    otherindex = 0;
                }
                liensEditor.setContexteOfLienSymetrique(lsm.getDescripteur(descindex), (Contexte)secteurTerm, lsm.getDescripteur(otherindex));
                return true;
            } else {
                if (secteurType != 1) throw new IllegalStateException("should not occur");
                if (rootTerm.getTermType() != 3) {
                    throw new IllegalStateException("badRootType : lorsque le secteur est un descripteur, VentilationRoot doit \u00eatre un contexte d'une grille pour que le changement de contexte puisse se faire");
                }
                Contexte contexte = (Contexte)rootTerm;
                Descripteur otherdescripteur = (Descripteur)liaisonTerm;
                atlasEditor.startCompoundEvent(session, "lienSymetriqueTranslation");
                liensEditor.createLienSymetrique((Descripteur)secteurTerm, contexte, otherdescripteur, contexte);
                liensEditor.removeLienSymetrique(lsm.getDescripteur(0), lsm.getDescripteur(1));
                atlasEditor.endCompoundEvent(session, "lienSymetriqueChange");
            }
            return true;
        } else if (lien instanceof LienHierarchique) {
            LienHierarchique lh = (LienHierarchique)lien;
            if (secteurType == 3 || secteurType == 5) {
                atlasEditor.startCompoundEvent(session, "lienHierarchiqueTranslation");
                liensEditor.createLienHierarchique(lh.getDescripteurPere(), lh.getDescripteurFils(), (Contexte)secteurTerm, -1);
                liensEditor.removeLienHierarchique(lh.getDescripteurPere(), lh.getDescripteurFils(), lh.getContexte());
                atlasEditor.endCompoundEvent(session, "lienHierarchiqueTranslation");
                return true;
            } else {
                if (secteurType != 1) throw new IllegalStateException("unexpectedOperation : la m\u00e9thode ne sait pas g\u00e9rer le changement de secteur avec un secteur dont le terme est de type = " + String.valueOf(secteurType));
                if (rootTerm.getTermType() != 3) {
                    throw new IllegalStateException("badRootType : lorsque le secteur est un descripteur, VentilationRoot doit \u00eatre un contexte d'une grille pour que le changement de contexte puisse se faire");
                }
                Contexte contexte = (Contexte)rootTerm;
                Descripteur otherdescripteur = (Descripteur)liaisonTerm;
                atlasEditor.startCompoundEvent(session, "lienHierarchiqueTranslation");
                if (otherdescripteur.equals(lh.getDescripteurPere())) {
                    liensEditor.createLienHierarchique(otherdescripteur, (Descripteur)secteurTerm, contexte, -1);
                } else {
                    liensEditor.createLienHierarchique((Descripteur)secteurTerm, otherdescripteur, contexte, -1);
                }
                liensEditor.removeLienHierarchique(lh.getDescripteurPere(), lh.getDescripteurFils(), lh.getContexte());
                atlasEditor.endCompoundEvent(session, "lienHierarchiqueTranslation");
            }
            return true;
        } else {
            if (!(lien instanceof LienStructurel)) return true;
            LienStructurel lienStructurel = (LienStructurel)lien;
            if (liaisonTerm instanceof Descripteur) {
                if (secteurType != 3) {
                    throw new IllegalStateException("unsupportedOperation : SessionUtils ne sait pas traiter les changements de secteur d'un lien structurel lorsque le secteur n'est pas un contexte de grille");
                }
                Contexte newContexte = (Contexte)secteurTerm;
                if (rootTerm.getTermType() != 3) {
                    throw new IllegalStateException("unsupportedOperation : SessionUtils ne sait pas traiter les changements de secteur d'un lien structurel lorsque le secteur n'est pas un contexte de grille");
                }
                Descripteur descripteur = (Descripteur)liaisonTerm;
                atlasEditor.startCompoundEvent(session, "descripteurInLienStructurelTranslation");
                liensEditor.addDescripteur((Contexte)rootTerm, newContexte, descripteur, -1);
                liensEditor.removeDescripteur(lienStructurel.getContexte1(), lienStructurel.getContexte2(), descripteur);
                atlasEditor.endCompoundEvent(session, "descripteurInLienStructurelTranslation");
                return true;
            } else {
                if (liaisonTerm.getTermType() != 3) throw new IllegalStateException("invalidLiaisonImplementation : La liaison comprend un lien structurel (donc un lien naturel) et son terme n'est ni un descripteur ni un contexte de grille");
                Contexte contexte1 = null;
                Contexte contexte2 = null;
                Descripteur olddescripteur = null;
                Descripteur newdescripteur = null;
                if (rootTerm instanceof Descripteur) {
                    newdescripteur = olddescripteur = (Descripteur)rootTerm;
                    if (secteurType != 3) {
                        throw new IllegalStateException("unsupportedOperation : SessionUtils ne sait pas traiter les changements de secteur d'un lien structurel");
                    }
                    contexte1 = (Contexte)secteurTerm;
                    contexte2 = (Contexte)liaisonTerm;
                } else if (secteurTerm instanceof Descripteur) {
                    if (rootTerm.getTermType() != 3) {
                        throw new IllegalStateException("unsupportedOperation : SessionUtils ne sait pas traiter les changements de secteur d'un lien structurel");
                    }
                    contexte1 = lienStructurel.getContexte1();
                    contexte2 = lienStructurel.getContexte2();
                    Term oldSecteurTerm = liaison.getSecteur().getSecteurTerm();
                    if (oldSecteurTerm.getTermType() != 1) {
                        throw new IllegalStateException("unsupportedOperation : SessionUtils ne sait pas traiter les changements de secteur d'un lien structurel");
                    }
                    olddescripteur = (Descripteur)oldSecteurTerm;
                    newdescripteur = (Descripteur)secteurTerm;
                }
                atlasEditor.startCompoundEvent(session, "descripteurInLienStructurelTranslation");
                liensEditor.addDescripteur(contexte1, contexte2, newdescripteur, -1);
                liensEditor.removeDescripteur(lienStructurel.getContexte1(), lienStructurel.getContexte2(), olddescripteur);
                atlasEditor.endCompoundEvent(session, "descripteurInLienStructurelTranslation");
            }
        }
        return true;
    }

    public static void createDoubleLienHierarchique(Session session, int codepere1, int codepere2, int codefils, boolean compoundEvent) throws LienExistantException, LienSurLuiMemeException {
        if (codepere1 == codepere2) {
            throw new IllegalArgumentException("codepere1 == codepere2");
        }
        AtlasEditor atlasEditor = session.getAtlasEditor();
        LiensEditor liensEditor = atlasEditor.getLiensEditor();
        Atlas atlas = session.getAtlas();
        Liens liens = atlas.getLiens();
        try {
            Descripteur descripteurpere1 = SessionUtils.getDescripteur(session, codepere1);
            Descripteur descripteurpere2 = SessionUtils.getDescripteur(session, codepere2);
            Descripteur descripteurfils = SessionUtils.getDescripteur(session, codefils);
            Contexte horsgrille = StructureUtils.getHorsgrilleContexte(atlas.getStructure());
            Liens.LienLists lists1 = liens.getLienLists(descripteurpere1, descripteurfils);
            Liens.LienLists lists2 = liens.getLienLists(descripteurpere2, descripteurfils);
            int count1 = lists1.getLienHierarchiqueGroupList().getLienHierarchiqueGroupCount();
            int count2 = lists2.getLienHierarchiqueGroupList().getLienHierarchiqueGroupCount();
            if (count1 > 0 && count2 > 0) {
                throw new LienExistantException();
            }
            if (compoundEvent) {
                atlasEditor.startCompoundEvent(session, "doubleLienHierarchique");
            }
            if (count1 == 0) {
                liensEditor.createLienHierarchique(descripteurpere1, descripteurfils, horsgrille, -1);
            }
            if (count2 == 0) {
                liensEditor.createLienHierarchique(descripteurpere2, descripteurfils, horsgrille, -1);
            }
            if (compoundEvent) {
                atlasEditor.endCompoundEvent(session, "doubleLienHierarchique");
            }
        }
        catch (InvalidContexteException ice) {
            throw new IllegalStateException("invalidContexte : le code contexte doit correspondre \u00e0 hors grille ou \u00e0 un contexte de grille");
        }
    }

    public static void createDoubleLienSymetrique(Session session, int codedescripteur1, int codedescripteur2, int codedescripteurdestination, boolean compoundEvent) throws LienExistantException, LienSurLuiMemeException {
        if (codedescripteur1 == codedescripteur2) {
            throw new IllegalArgumentException("codedescripteur1 == codedescripteur2");
        }
        AtlasEditor atlasEditor = session.getAtlasEditor();
        LiensEditor liensEditor = atlasEditor.getLiensEditor();
        Atlas atlas = session.getAtlas();
        Liens liens = atlas.getLiens();
        Descripteur descripteur1 = SessionUtils.getDescripteur(session, codedescripteur1);
        Descripteur descripteur2 = SessionUtils.getDescripteur(session, codedescripteur2);
        Descripteur descripteurdestination = SessionUtils.getDescripteur(session, codedescripteurdestination);
        Contexte horsgrille = StructureUtils.getHorsgrilleContexte(atlas.getStructure());
        Liens.LienLists lists1 = liens.getLienLists(descripteur1, descripteurdestination);
        Liens.LienLists lists2 = liens.getLienLists(descripteur2, descripteurdestination);
        int count1 = lists1.getLienSymetriqueList().getLienSymetriqueCount();
        int count2 = lists2.getLienSymetriqueList().getLienSymetriqueCount();
        if (count1 > 0 && count2 > 0) {
            throw new LienExistantException();
        }
        if (compoundEvent) {
            atlasEditor.startCompoundEvent(session, "doubleLienSymetrique");
        }
        if (count1 == 0) {
            liensEditor.createLienSymetrique(descripteur1, horsgrille, descripteurdestination, horsgrille);
        }
        if (count2 == 0) {
            liensEditor.createLienSymetrique(descripteur2, horsgrille, descripteurdestination, horsgrille);
        }
        if (compoundEvent) {
            atlasEditor.endCompoundEvent(session, "doubleLienSymetrique");
        }
    }

    public static void createLienStructurel(Session session, int codecontexte1, int codecontexte2, int codedescripteur) throws LienExistantException {
        LiensEditor liensEditor = session.getAtlasEditor().getLiensEditor();
        Atlas atlas = session.getAtlas();
        try {
            Descripteur descripteur = SessionUtils.getDescripteur(session, codedescripteur);
            Contexte contexte1 = SessionUtils.getContexte(session, codecontexte1);
            Contexte contexte2 = SessionUtils.getContexte(session, codecontexte2);
            liensEditor.addDescripteur(contexte1, contexte2, descripteur, -1);
        }
        catch (InvalidContexteException ice) {
            throw new IllegalStateException("invalidContexte : le code contexte doit correspondre \u00e0 hors grille ou \u00e0 un contexte de grille");
        }
    }

    public static void createLienSymetrique(Session session, int codedescripteur1, int codecontexte1, int codedescripteur2, int codecontexte2) throws LienExistantException, LienSurLuiMemeException {
        Descripteur descripteur1 = SessionUtils.getDescripteur(session, codedescripteur1);
        Descripteur descripteur2 = SessionUtils.getDescripteur(session, codedescripteur2);
        Contexte contexte1 = SessionUtils.getContexte(session, codecontexte1);
        Contexte contexte2 = SessionUtils.getContexte(session, codecontexte2);
        session.getAtlasEditor().getLiensEditor().createLienSymetrique(descripteur1, contexte1, descripteur2, contexte2);
    }

    public static void createLienHierarchique(Session session, int codepere, int codefils, int codecontexte) throws LienExistantException, LienSurLuiMemeException {
        if (codepere == codefils) {
            throw new LienSurLuiMemeException();
        }
        LiensEditor liensEditor = session.getAtlasEditor().getLiensEditor();
        Atlas atlas = session.getAtlas();
        try {
            Descripteur descripteurpere = SessionUtils.getDescripteur(session, codepere);
            Descripteur descripteurfils = SessionUtils.getDescripteur(session, codefils);
            Contexte contexte = SessionUtils.getContexte(session, codecontexte);
            liensEditor.createLienHierarchique(descripteurpere, descripteurfils, contexte, -1);
        }
        catch (InvalidContexteException ice) {
            throw new IllegalStateException("invalidContexte : le code contexte doit correspondre \u00e0 hors grille ou \u00e0 un contexte de grille");
        }
    }

    public static Descripteur createDescripteur(Session session, CharSequence charSequence) {
        AtlasEditor atlasEditor = session.getAtlasEditor();
        DescripteursEditor descripteursEditor = atlasEditor.getDescripteursEditor();
        try {
            atlasEditor.startCompoundEvent(session, "descripteurCreation");
            Descripteur descripteur = descripteursEditor.createDescripteur(session.getIddescPrefix(), -2);
            CleanedString cleanedString = CleanedString.newInstance((CharSequence)charSequence);
            if (cleanedString != null) {
                atlasEditor.putLibelle(descripteur, LabelUtils.toLabel((Lang)SessionUtils.getWorkingLang(session), (CleanedString)cleanedString));
            }
            atlasEditor.endCompoundEvent(session, "descripteurCreation");
            return descripteur;
        }
        catch (ExistingIddescException eie) {
            throw new IllegalStateException("existingIddesc : la m\u00e9thode session.getNewIddesc() est cens\u00e9e retourner un iddesc qui n'existe pas");
        }
    }

    public static Descripteur[] createDescripteurs(Session session, String[] textes, int codefamille, boolean includeInCompoundEvent) {
        AtlasEditor atlasEditor = session.getAtlasEditor();
        DescripteursEditor descripteursEditor = atlasEditor.getDescripteursEditor();
        Contexte famille = SessionUtils.getContexte(session, codefamille);
        try {
            if (includeInCompoundEvent) {
                atlasEditor.startCompoundEvent(session, "descripteursCreation");
            }
            Lang workingLang = SessionUtils.getWorkingLang(session);
            Descripteur[] descripteurs = new Descripteur[textes.length];
            for (int i = 0; i < textes.length; ++i) {
                Descripteur descripteur = descripteursEditor.createDescripteur(session.getIddescPrefix(), -2);
                CleanedString cleanedString = CleanedString.newInstance((CharSequence)textes[i]);
                if (cleanedString != null) {
                    atlasEditor.putLibelle(descripteur, LabelUtils.toLabel((Lang)workingLang, (CleanedString)cleanedString));
                }
                descripteursEditor.setFamille(descripteur, famille);
                descripteurs[i] = descripteur;
            }
            if (includeInCompoundEvent) {
                atlasEditor.endCompoundEvent(session, "descripteursCreation");
            }
            return descripteurs;
        }
        catch (ExistingIddescException eie) {
            throw new IllegalStateException("existingIddesc : la m\u00e9thode session.getNewIddesc() est cens\u00e9e retourner un iddesc qui n'existe pas");
        }
        catch (InvalidContexteException ice) {
            throw new IllegalStateException("invalidContexte : le code contexte doit correspondre \u00e0 une famille ou \u00e0 sans famille");
        }
    }

    public static Set<Integer> getFamillesLimitationSet(Conf conf, Structure structure) {
        HashSet<Integer> famillesLimitationSet = new HashSet<Integer>();
        String[] idctxtArray = conf.getStringArray("limitation.familles.idctxtarray");
        Grille grilleDesFamilles = structure.getGrilleDesFamilles();
        for (String idctxt : idctxtArray) {
            if (idctxt.length() == 0) {
                famillesLimitationSet.add(structure.getSpecialContexte((short)6).getCode());
                continue;
            }
            Contexte contexte = grilleDesFamilles.getContexteByIdctxt(idctxt);
            if (contexte == null) continue;
            famillesLimitationSet.add(contexte.getCode());
        }
        return famillesLimitationSet;
    }

    public static LiensFilter getLienFilter(Conf conf) {
        return LiensUtils.getLiensFilter(conf.getStringArray("limitation.liens.typearray"));
    }

    public static boolean editTitre(Session session, TermEdit termEdit) {
        Term titre = session.getAtlas().getAtlasMetadata().getTitre();
        AtlasEditor atlasEditor = session.getAtlasEditor();
        boolean done = false;
        atlasEditor.startCompoundEvent(session, "titreEdit");
        boolean commonDone = SessionUtils.innerTermEdit(atlasEditor, termEdit, titre);
        if (commonDone) {
            done = true;
        }
        atlasEditor.endCompoundEvent(session, "titreEdit");
        return done;
    }

    public static boolean editAttributes(Session session, AttributesEdit attributesEdit) {
        boolean doneAttribute;
        AtlasMetadata atlasMetadata = session.getAtlas().getAtlasMetadata();
        AtlasEditor atlasEditor = session.getAtlasEditor();
        AttributeChange attributeChange = attributesEdit.getAttributeChange();
        boolean done = false;
        atlasEditor.startCompoundEvent(session, "metadataAttributesEdit");
        if (attributeChange != null && (doneAttribute = AtlasUtils.updateAttributes(atlasEditor, atlasMetadata, attributeChange))) {
            done = true;
        }
        atlasEditor.endCompoundEvent(session, "metadataAttributesEdit");
        return done;
    }

    public static boolean editDescripteur(Session session, DescripteurEdit descripteurEdit) {
        Descripteur descripteur = descripteurEdit.getDescripteur();
        AtlasEditor atlasEditor = session.getAtlasEditor();
        DescripteursEditor descripteursEditor = atlasEditor.getDescripteursEditor();
        boolean done = false;
        atlasEditor.startCompoundEvent(session, "descripteurEdit");
        boolean commonDone = SessionUtils.innerTermEdit(atlasEditor, descripteurEdit, descripteur);
        if (commonDone) {
            done = true;
        }
        Contexte famille = descripteurEdit.getFamilleContexte();
        try {
            boolean familleDone = descripteursEditor.setFamille(descripteur, famille);
            if (familleDone) {
                done = true;
            }
        }
        catch (InvalidContexteException ice) {
            throw new IllegalStateException("invalidContexte : le code contexte doit correspondre \u00e0 une famille ou \u00e0 sans famille");
        }
        atlasEditor.endCompoundEvent(session, "descripteurEdit");
        return done;
    }

    public static Descripteur createDescripteur(Session session, DescripteurEdit descripteurEdit) {
        AtlasEditor atlasEditor = session.getAtlasEditor();
        DescripteursEditor descripteursEditor = atlasEditor.getDescripteursEditor();
        Descripteur descripteur = null;
        atlasEditor.startCompoundEvent(session, "descripteurCreation");
        try {
            descripteur = descripteursEditor.createDescripteur(session.getIddescPrefix(), -2);
        }
        catch (ExistingIddescException eie) {
            throw new IllegalStateException("existingIddesc : la m\u00e9thode session.getNewIddesc() est cens\u00e9e retourner un iddesc qui n'existe pas");
        }
        SessionUtils.innerTermEdit(atlasEditor, descripteurEdit, descripteur);
        Contexte famille = descripteurEdit.getFamilleContexte();
        try {
            descripteursEditor.setFamille(descripteur, famille);
        }
        catch (InvalidContexteException ice) {
            throw new IllegalStateException("invalidContexte : le code contexte doit correspondre \u00e0 une famille ou \u00e0 sans famille");
        }
        atlasEditor.endCompoundEvent(session, "descripteurCreation");
        return descripteur;
    }

    private static boolean innerTermEdit(AtlasEditor atlasEditor, TermEdit termEdit, Term term) {
        boolean doneAttribute;
        AttributeChange attributeChange;
        boolean done = false;
        LabelChange labelChange = termEdit.getLabelChange();
        if (labelChange != null) {
            boolean stepDone;
            for (Label label : labelChange.getChangedLabels()) {
                stepDone = atlasEditor.putLibelle(term, label);
                if (!stepDone) continue;
                done = true;
            }
            for (Lang lang : labelChange.getRemovedLangList()) {
                stepDone = atlasEditor.removeLibelle(term, lang);
                if (!stepDone) continue;
                done = true;
            }
        }
        if ((attributeChange = termEdit.getAttributeChange()) != null && (doneAttribute = AtlasUtils.updateAttributes(atlasEditor, term, attributeChange))) {
            done = true;
        }
        return done;
    }

    public static void updateLastFamille(Session session, GroupeItem famille) {
        if (famille == null) {
            session.getSessionConf().setInteger("trans.lastfamille.code", -1);
        } else {
            session.getSessionConf().setInteger("trans.lastfamille.code", famille.getTermCode());
        }
    }

    public static void updateDescripeurIndex(Session session, Contexte contexte1, Contexte contexte2, int[] newCodeArray) {
        AtlasEditor atlasEditor = session.getAtlasEditor();
        LiensEditor liensEditor = atlasEditor.getLiensEditor();
        atlasEditor.startCompoundEvent(session, "descripteurIndex");
        int p = 0;
        for (int i = 0; i < newCodeArray.length; ++i) {
            Descripteur descripteur = SessionUtils.getDescripteur(session, newCodeArray[i]);
            LienStructurel lienStructurel = liensEditor.setDescripteurIndex(contexte1, contexte2, descripteur, p);
            if (lienStructurel == null) continue;
            ++p;
        }
        atlasEditor.endCompoundEvent(session, "descripteurIndex");
    }

    public static void updateDescripeurIndex(Session session, Descripteur descripteurPere, Contexte contexte, int[] newCodeArray) {
        AtlasEditor atlasEditor = session.getAtlasEditor();
        LiensEditor liensEditor = atlasEditor.getLiensEditor();
        atlasEditor.startCompoundEvent(session, "descripteurIndex");
        int p = 0;
        for (int i = 0; i < newCodeArray.length; ++i) {
            Descripteur descripteur = SessionUtils.getDescripteur(session, newCodeArray[i]);
            LienHierarchique lienHierarchique = liensEditor.setLienHierarchiqueIndex(descripteurPere, descripteur, contexte, p);
            if (lienHierarchique == null) continue;
            ++p;
        }
        atlasEditor.endCompoundEvent(session, "descripteurIndex");
    }
}

