/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.session;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.AtlasURI;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.conf.Conf;
import net.desmodo.atlas.conf.ConfEvent;
import net.desmodo.atlas.session.NavigationEvent;
import net.desmodo.atlas.session.NavigationKey;
import net.desmodo.atlas.session.NavigationListener;
import net.desmodo.atlas.session.NavigationUnit;
import net.desmodo.atlas.session.Session;
import net.desmodo.atlas.session.SessionConf;
import net.desmodo.atlas.session.SessionConfKeys;
import net.desmodo.atlas.ventilation.LiaisonFilter;
import net.desmodo.atlas.ventilation.Transversalite;
import net.desmodo.atlas.ventilation.UnsupportedVentilationNameException;
import net.desmodo.atlas.ventilation.UnsupportedVentilationRootException;
import net.desmodo.atlas.ventilation.Ventilation;
import net.desmodo.atlas.ventilation.VentilationFactory;
import net.desmodo.atlas.ventilation.VentilationName;
import net.desmodo.atlas.ventilation.VentilationParameters;
import net.desmodo.atlas.wrapper.VentilationNameItem;

public class Navigation
implements SessionConfKeys {
    private boolean atHome = true;
    private NavigationListener[] navigationListeners = new NavigationListener[0];
    private Stack<NavigationKey> previousNavigationKey = new Stack();
    private Stack<NavigationKey> nextNavigationKey = new Stack();
    private NavigationKey currentNavigationKey;
    private Ventilation currentVentilation;
    private Session session;
    private Transversalite currentTransversalite;
    private NavigationCurrentState currentNavigationUnit = new NavigationCurrentState();

    public Navigation(Navigation navigation) {
        this.atHome = navigation.atHome;
        this.currentNavigationKey = navigation.currentNavigationKey;
        this.currentVentilation = navigation.currentVentilation;
        this.session = navigation.session;
        this.currentTransversalite = navigation.currentTransversalite;
    }

    public void unbind() {
        this.navigationListeners = new NavigationListener[0];
    }

    public Navigation(Session session, NavigationKey navigationKey) {
        this(session, navigationKey.getVentilationRoot(), navigationKey.getVentilationName());
    }

    public Navigation(Session session, Term root, VentilationName ventilationName) {
        this.session = session;
        this.currentNavigationKey = new NavigationKey(root, ventilationName);
        this.atHome = this.currentNavigationKey.equals(session.getHomeNavigationKey());
        this.loadVentilation(this.currentNavigationKey);
        if (session.getSessionConf().getBoolean("extension.transversalite")) {
            this.currentTransversalite = new Transversalite(this.currentVentilation);
        }
    }

    public Session getSession() {
        return this.session;
    }

    public NavigationUnit getCurrentNavigationUnit() {
        return this.currentNavigationUnit;
    }

    public VentilationNameItem getCurrentVentilationNameItem() {
        return this.session.getVentilationNameItemManager().getVentilationNameItem(this.currentNavigationKey.getVentilationName());
    }

    public Term getCurrentVentilationRoot() {
        return this.currentNavigationKey.getVentilationRoot();
    }

    public Ventilation getCurrentVentilation() {
        return this.currentVentilation;
    }

    public Transversalite getCurrentTransversalite() {
        return this.currentTransversalite;
    }

    public void goNext() {
        if (!this.nextNavigationKey.isEmpty()) {
            NavigationKey newNavigationKey = this.nextNavigationKey.pop();
            this.previousNavigationKey.push(this.currentNavigationKey);
            int mask = this.setCurrentNavigationKey(newNavigationKey);
            this.fireNavigationChanged(mask);
        }
    }

    public void setCurrentNavigationKeyAsHome() {
        this.session.setHomeNavigationKey(this.currentNavigationKey);
    }

    public NavigationKey getPrevious() {
        if (!this.previousNavigationKey.isEmpty()) {
            return (NavigationKey)this.previousNavigationKey.lastElement();
        }
        return null;
    }

    public void goPrevious() {
        if (!this.previousNavigationKey.isEmpty()) {
            NavigationKey newNavigationKey = this.previousNavigationKey.pop();
            this.nextNavigationKey.push(this.currentNavigationKey);
            int mask = this.setCurrentNavigationKey(newNavigationKey);
            this.fireNavigationChanged(mask);
        }
    }

    public void goHome() {
        if (!this.atHome) {
            this.changeNavigationKey(this.session.getHomeNavigationKey());
        }
    }

    public void changeVentilationRootAndName(Term ventilationRoot, VentilationName ventilationName) {
        NavigationKey newNavigationKey = new NavigationKey(ventilationRoot, ventilationName);
        int mask = this.currentNavigationKey.getDifferenceMask(newNavigationKey);
        if (mask != 0) {
            this.changeNavigationKey(newNavigationKey);
        }
    }

    public void changeVentilationName(VentilationName newVentilationName) {
        if (!newVentilationName.equals(this.currentNavigationKey.getVentilationName())) {
            NavigationKey newNavigationKey = new NavigationKey(this.currentNavigationKey.getVentilationRoot(), newVentilationName);
            this.changeNavigationKey(newNavigationKey);
        }
    }

    public void changeVentilationRoot(Term ventilationRoot) {
        NavigationKey newNavigationKey = new NavigationKey(ventilationRoot, this.currentNavigationKey.getVentilationName());
        int mask = this.currentNavigationKey.getDifferenceMask(newNavigationKey);
        if (mask != 0) {
            this.changeNavigationKey(newNavigationKey);
        }
    }

    private void changeNavigationKey(NavigationKey newNavigationKey) {
        this.previousNavigationKey.push(this.currentNavigationKey);
        this.nextNavigationKey.clear();
        int mask = this.setCurrentNavigationKey(newNavigationKey);
        this.fireNavigationChanged(mask);
    }

    private int setCurrentNavigationKey(NavigationKey newNavigationKey) {
        int mask = this.currentNavigationKey.getDifferenceMask(newNavigationKey);
        if (mask != 0) {
            this.currentNavigationKey = newNavigationKey;
            this.loadVentilation(newNavigationKey);
            if (this.session.getSessionConf().getBoolean("extension.transversalite")) {
                this.currentTransversalite = new Transversalite(this.currentVentilation);
                mask |= 0x20;
            }
        }
        return mask |= this.checkHome(newNavigationKey);
    }

    private int checkHome(NavigationKey newNavigationKey) {
        if (this.atHome) {
            if (!newNavigationKey.equals(this.session.getHomeNavigationKey())) {
                this.atHome = false;
                return 8;
            }
            return 0;
        }
        if (newNavigationKey.equals(this.session.getHomeNavigationKey())) {
            this.atHome = true;
            return 8;
        }
        return 0;
    }

    public boolean hasNext() {
        return !this.nextNavigationKey.isEmpty();
    }

    public boolean hasPrevious() {
        return !this.previousNavigationKey.isEmpty();
    }

    public boolean isAtHome() {
        return this.atHome;
    }

    protected void fireNavigationChanged(int mask) {
        this.fireNavigationChanged(mask, null);
    }

    protected void fireNavigationChanged(int mask, List<String> paramNameList) {
        if (mask == 0) {
            return;
        }
        NavigationEvent navigationEvent = new NavigationEvent(this, mask);
        if (paramNameList != null) {
            navigationEvent.setParamNameList(paramNameList);
        }
        for (int i = 0; i < this.navigationListeners.length; ++i) {
            this.navigationListeners[i].navigationChanged(navigationEvent);
        }
    }

    public void addNavigationListener(NavigationListener navigationListener) {
        int length = this.navigationListeners.length;
        for (int i = 0; i < length; ++i) {
            if (!this.navigationListeners[i].equals(navigationListener)) continue;
            return;
        }
        NavigationListener[] nvtab = new NavigationListener[length + 1];
        System.arraycopy(this.navigationListeners, 0, nvtab, 0, length);
        nvtab[length] = navigationListener;
        this.navigationListeners = nvtab;
    }

    public void removeNavigationListener(NavigationListener navigationListener) {
        int length = this.navigationListeners.length;
        int index = -1;
        for (int i = 0; i < length; ++i) {
            if (!this.navigationListeners[i].equals(navigationListener)) continue;
            index = i;
            break;
        }
        if (index != -1) {
            NavigationListener[] nvtab = new NavigationListener[length - 1];
            if (index == 0) {
                System.arraycopy(this.navigationListeners, 1, nvtab, 0, length - 1);
            } else if (index == length - 1) {
                System.arraycopy(this.navigationListeners, 0, nvtab, 0, length - 1);
            } else {
                System.arraycopy(this.navigationListeners, 0, nvtab, 0, index);
                System.arraycopy(this.navigationListeners, index + 1, nvtab, index, length - index - 1);
            }
            this.navigationListeners = nvtab;
        }
    }

    private void loadVentilation(NavigationKey navigationKey) {
        VentilationName ventilationName = navigationKey.getVentilationName();
        Term ventilationRoot = navigationKey.getVentilationRoot();
        VentilationFactory ventilationFactory = this.session.getVentilationFactory();
        InternalVentilationParameters ventilationParameters = new InternalVentilationParameters(ventilationRoot, ventilationName);
        try {
            Ventilation ventilation;
            this.currentVentilation = ventilation = ventilationFactory.getVentilation(ventilationParameters);
        }
        catch (UnsupportedVentilationRootException uvne) {
            throw new IllegalStateException("unsupportedVentilationRoot : VentilationRoot non support\u00e9 = " + AtlasURI.toURIString(ventilationRoot));
        }
        catch (UnsupportedVentilationNameException uvne) {
            throw new IllegalStateException("unsupportedVentilationName : le nom de ventilation suivant n'est pas support\u00e9 : " + ventilationName.toUriString());
        }
    }

    void confChanged(ConfEvent confEvent) {
        int mask = 0;
        boolean updateVentilation = false;
        boolean updateTransversalite = false;
        ArrayList<String> paramNameList = new ArrayList<String>();
        for (int i = 0; i < confEvent.getParamNameCount(); ++i) {
            String paramName = confEvent.getParamName(i);
            boolean done = false;
            if ((mask & 0x10) == 0 && SessionConf.concernVentilationFilter(paramName)) {
                updateVentilation = true;
                mask |= 0x10;
                done = true;
            }
            if ((mask & 0x20) == 0 && paramName.equals("extension.transversalite")) {
                mask |= 0x20;
                boolean b = this.session.getSessionConf().getBoolean(paramName);
                if (!b) {
                    this.currentTransversalite = null;
                } else {
                    updateTransversalite = true;
                }
                done = true;
            }
            if ((mask & 8) == 0 && (paramName.equals("home.ventilationname") || paramName.equals("home.ventilationroot"))) {
                mask |= 8;
                this.atHome = this.currentNavigationKey.equals(this.session.getHomeNavigationKey());
                done = true;
            }
            if (SessionConf.concernSkin(paramName)) {
                mask |= 0x100;
                done = true;
            } else if (paramName.equals("ventparam.famille.recursive") || paramName.equals("ventparam.famille.liens.typearray")) {
                updateVentilation = true;
                done = true;
            } else if (paramName.equals("display.link")) {
                mask |= 0x200;
                done = true;
            } else if (paramName.equals("display.poids")) {
                mask |= 0x200;
                done = true;
            } else if (paramName.equals("display.lientype")) {
                mask |= 0x200;
                done = true;
            } else if (paramName.equals("display.lienindex")) {
                mask |= 0x200;
                done = true;
            }
            if (!done) continue;
            paramNameList.add(paramName);
        }
        if (paramNameList.size() > 0) {
            mask |= 0x400;
        }
        if (updateVentilation) {
            this.updateVentilation(mask, paramNameList);
        } else if (updateTransversalite) {
            this.currentTransversalite = new Transversalite(this.currentVentilation);
        } else {
            this.fireNavigationChanged(mask, paramNameList);
        }
    }

    void updateVentilation(int mask, List<String> confParam) {
        mask |= 4;
        this.loadVentilation(this.currentNavigationKey);
        if (this.session.getSessionConf().getBoolean("extension.transversalite")) {
            this.currentTransversalite = new Transversalite(this.currentVentilation);
            mask |= 0x20;
        }
        this.fireNavigationChanged(mask, confParam);
    }

    void removeRoot(Term term) {
        Term trm;
        Term trm2;
        NavigationKey navigationKey;
        Iterator it;
        if (this.previousNavigationKey.size() > 0) {
            it = this.previousNavigationKey.iterator();
            while (it.hasNext()) {
                navigationKey = (NavigationKey)it.next();
                trm2 = navigationKey.getVentilationRoot();
                if (trm2 == null || !trm2.equals(term)) continue;
                it.remove();
            }
        }
        if (this.nextNavigationKey.size() > 0) {
            it = this.nextNavigationKey.iterator();
            while (it.hasNext()) {
                navigationKey = (NavigationKey)it.next();
                trm2 = navigationKey.getVentilationRoot();
                if (trm2 == null || !trm2.equals(term)) continue;
                it.remove();
            }
        }
        if ((trm = this.currentNavigationKey.getVentilationRoot()) != null && trm.equals(term)) {
            NavigationKey lastKey;
            NavigationKey homeKey = this.session.getHomeNavigationKey();
            if (this.previousNavigationKey.size() > 0 && (lastKey = (NavigationKey)this.previousNavigationKey.get(this.previousNavigationKey.size() - 1)).equals(homeKey)) {
                this.previousNavigationKey.pop();
            }
            int mask = this.setCurrentNavigationKey(homeKey);
            this.fireNavigationChanged(mask);
        }
    }

    private class NavigationCurrentState
    implements NavigationUnit {
        private NavigationCurrentState() {
        }

        @Override
        public VentilationName getVentilationName() {
            return Navigation.this.currentNavigationKey.getVentilationName();
        }

        @Override
        public Ventilation getVentilation() {
            return Navigation.this.currentVentilation;
        }

        @Override
        public Transversalite getTransversalite() {
            return Navigation.this.currentTransversalite;
        }
    }

    private class InternalVentilationParameters
    implements VentilationParameters {
        private final Term ventilationRoot;
        private final VentilationName ventilationName;

        private InternalVentilationParameters(Term ventilationRoot, VentilationName ventilationName) {
            this.ventilationRoot = ventilationRoot;
            this.ventilationName = ventilationName;
        }

        @Override
        public Atlas getAtlas() {
            return Navigation.this.session.getAtlas();
        }

        @Override
        public Term getVentilationRoot() {
            return this.ventilationRoot;
        }

        @Override
        public LiaisonFilter getLiaisonFilter() {
            return Navigation.this.session.getLiaisonFilter();
        }

        @Override
        public Conf getSessionConf() {
            return Navigation.this.session.getSessionConf();
        }

        @Override
        public VentilationName getVentilationName() {
            return this.ventilationName;
        }
    }
}

