/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.impl;

import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.AtlasEditor;
import net.desmodo.atlas.event.StructureEvent;
import net.desmodo.atlas.event.StructureListener;
import net.desmodo.atlas.impl.AtlasImpl;
import net.desmodo.atlas.impl.GrilleImpl;
import net.desmodo.atlas.impl.TermCoder;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.ContexteList;
import net.desmodo.atlas.structure.ExistingGrilleNameException;
import net.desmodo.atlas.structure.Grille;
import net.desmodo.atlas.structure.GrilleEditor;
import net.desmodo.atlas.structure.GrilleList;
import net.desmodo.atlas.structure.InvalidGrilleNameException;
import net.desmodo.atlas.structure.Structure;
import net.desmodo.atlas.structure.StructureEditor;
import net.desmodo.atlas.structure.StructureUtils;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.misc.ArrayUtils;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.Labels;

class StructureImpl
implements Structure {
    private final AtlasImpl atlas;
    private final GrilleImpl grilleDesFamilles;
    private final TermCoder termCoder;
    private GrilleImpl[] grilles;
    private final SpecialContexte contexteSansFamille;
    private final SpecialContexte contexteHorsGrille;
    private final InternalGrilleList grilleList = new InternalGrilleList();
    private StructureListener[] structureListeners = new StructureListener[0];
    private final StructureEditorImpl structureEditor = new StructureEditorImpl();

    StructureImpl(AtlasImpl atlas, TermCoder termCoder) {
        this.atlas = atlas;
        this.termCoder = termCoder;
        int codeSansFamille = termCoder.getNewCode();
        int codeHorsGrille = termCoder.getNewCode();
        this.contexteSansFamille = new SpecialContexte(6, codeSansFamille);
        this.contexteHorsGrille = new SpecialContexte(5, codeHorsGrille);
        termCoder.setTerm(codeSansFamille, this.contexteSansFamille);
        termCoder.setTerm(codeHorsGrille, this.contexteHorsGrille);
        this.grilles = new GrilleImpl[0];
        int codeGrilleDesFamilles = termCoder.getNewCode();
        this.grilleDesFamilles = new GrilleImpl(this, "", codeGrilleDesFamilles, termCoder);
    }

    @Override
    public void addStructureListener(StructureListener structureListener) {
        this.structureListeners = (StructureListener[])ArrayUtils.addUnique((Object[])this.structureListeners, (Object)structureListener, (Object[])new StructureListener[this.structureListeners.length + 1]);
    }

    @Override
    public void removeStructureListener(StructureListener structureListener) {
        if (this.structureListeners.length > 0) {
            this.structureListeners = (StructureListener[])ArrayUtils.removeUnique((Object[])this.structureListeners, (Object)structureListener, (Object[])new StructureListener[this.structureListeners.length - 1]);
        }
    }

    @Override
    public Atlas getAtlas() {
        return this.atlas;
    }

    @Override
    public Grille getGrille(String grilleName) {
        if (grilleName.length() == 0) {
            return this.grilleDesFamilles;
        }
        for (GrilleImpl grille : this.grilles) {
            if (!grilleName.equals(grille.getGrilleName())) continue;
            return grille;
        }
        return null;
    }

    @Override
    public Grille getGrilleDesFamilles() {
        return this.grilleDesFamilles;
    }

    @Override
    public GrilleList getGrilleList() {
        return this.grilleList;
    }

    @Override
    public Contexte getSpecialContexte(short type) {
        switch (type) {
            case 5: {
                return this.contexteHorsGrille;
            }
            case 6: {
                return this.contexteSansFamille;
            }
        }
        return null;
    }

    StructureEditor getStructureEditor() {
        return this.structureEditor;
    }

    AtlasEditor getAtlasEditor() {
        return this.atlas.getAtlasEditor();
    }

    void setSpecialContexteLibs(short type, Labels labels) {
        SpecialContexte contexte = (SpecialContexte)this.getSpecialContexte(type);
        contexte.sourceLabels = labels;
    }

    void setGrilledesfamillesLibs(Labels labels) {
        GrilleImpl.GrilleEditorImpl grilleEditor = this.grilleDesFamilles.getGrilleEditor();
        for (Label label : labels) {
            grilleEditor.getAtlasEditor().putLibelle(this.grilleDesFamilles, label);
        }
    }

    void fireContexteCreated(Contexte contexte) {
        int length = this.structureListeners.length;
        if (length > 0) {
            StructureEvent structureEvent = new StructureEvent((Structure)this, contexte);
            for (int i = 0; i < length; ++i) {
                this.structureListeners[i].contexteCreated(structureEvent);
            }
        }
    }

    void fireGrilleCreated(Grille grille) {
        int length = this.structureListeners.length;
        if (length > 0) {
            StructureEvent structureEvent = new StructureEvent((Structure)this, grille);
            for (int i = 0; i < length; ++i) {
                this.structureListeners[i].grilleCreated(structureEvent);
            }
        }
    }

    void fireGrilleRemoved(Grille grille) {
        int length = this.structureListeners.length;
        if (length > 0) {
            StructureEvent structureEvent = new StructureEvent((Structure)this, grille);
            for (int i = 0; i < length; ++i) {
                this.structureListeners[i].grilleRemoved(structureEvent);
            }
        }
    }

    void fireParentChanged(Contexte contexte, Contexte oldParent) {
        int length = this.structureListeners.length;
        if (length > 0) {
            StructureEvent structureEvent = new StructureEvent((Structure)this, contexte, oldParent);
            for (int i = 0; i < length; ++i) {
                this.structureListeners[i].parentChanged(structureEvent);
            }
        }
    }

    void fireActiveChanged(Contexte contexte, boolean oldactive) {
        int length = this.structureListeners.length;
        if (length > 0) {
            StructureEvent structureEvent = new StructureEvent((Structure)this, contexte, oldactive);
            for (int i = 0; i < length; ++i) {
                this.structureListeners[i].activeChanged(structureEvent);
            }
        }
    }

    void fireChildIndexChanged(Contexte contexte, int oldChildIndex) {
        int length = this.structureListeners.length;
        if (length > 0) {
            StructureEvent structureEvent = new StructureEvent((Structure)this, contexte, oldChildIndex);
            for (int i = 0; i < length; ++i) {
                this.structureListeners[i].childIndexChanged(structureEvent);
            }
        }
    }

    void fireContexteRemoved(Contexte contexte) {
        int length = this.structureListeners.length;
        if (length > 0) {
            StructureEvent structureEvent = new StructureEvent((Structure)this, contexte);
            for (int i = 0; i < length; ++i) {
                this.structureListeners[i].contexteRemoved(structureEvent);
            }
        }
    }

    private void unbindGrille(GrilleImpl grille, int index) {
        this.termCoder.setTerm(grille.getCode(), null);
        int currentLength = this.grilles.length;
        GrilleImpl[] nvgrilles = new GrilleImpl[currentLength - 1];
        if (index == 0) {
            System.arraycopy(this.grilles, 1, nvgrilles, 0, currentLength - 1);
        } else if (index == currentLength - 1) {
            System.arraycopy(this.grilles, 0, nvgrilles, 0, currentLength - 1);
        } else {
            System.arraycopy(this.grilles, 0, nvgrilles, 0, index);
            System.arraycopy(this.grilles, index + 1, nvgrilles, index, currentLength - 1 - index);
        }
        this.grilles = nvgrilles;
    }

    static /* synthetic */ GrilleImpl[] access$302(StructureImpl x0, GrilleImpl[] x1) {
        x0.grilles = x1;
        return x1;
    }

    private class InternalGrilleList
    implements GrilleList {
        private InternalGrilleList() {
        }

        @Override
        public Grille getGrille(int index) {
            return StructureImpl.this.grilles[index];
        }

        @Override
        public int getGrilleCount() {
            return StructureImpl.this.grilles.length;
        }
    }

    private class StructureEditorImpl
    implements StructureEditor {
        StructureEditorImpl() {
        }

        @Override
        public GrilleEditor createGrille(String grilleName) throws ExistingGrilleNameException, InvalidGrilleNameException {
            if (!grilleName.equals(grilleName.trim())) {
                throw new InvalidGrilleNameException(grilleName);
            }
            if (StructureImpl.this.getGrille(grilleName) != null) {
                throw new ExistingGrilleNameException(grilleName);
            }
            int code = StructureImpl.this.termCoder.getNewCode();
            GrilleImpl nvgrille = new GrilleImpl(StructureImpl.this, grilleName, code, StructureImpl.this.termCoder);
            StructureImpl.this.termCoder.setTerm(code, nvgrille);
            int currentLength = StructureImpl.this.grilles.length;
            GrilleImpl[] nvgrilles = new GrilleImpl[currentLength + 1];
            System.arraycopy(StructureImpl.this.grilles, 0, nvgrilles, 0, currentLength);
            nvgrilles[currentLength] = nvgrille;
            StructureImpl.access$302(StructureImpl.this, nvgrilles);
            StructureImpl.this.fireGrilleCreated(nvgrille);
            return nvgrille.getGrilleEditor();
        }

        @Override
        public boolean removeGrille(Grille grille) {
            if (grille.getGrilleName().length() == 0) {
                throw new IllegalArgumentException("Grille des Familles cannot be removed");
            }
            int index = -1;
            for (int i = 0; i < StructureImpl.this.grilles.length; ++i) {
                if (!grille.equals(StructureImpl.this.grilles[i])) continue;
                index = i;
                break;
            }
            if (index == -1) {
                return false;
            }
            if (grille.getFirstLevelContexteList().getContexteCount() > 0) {
                return false;
            }
            StructureImpl.this.unbindGrille((GrilleImpl)grille, index);
            StructureImpl.this.fireGrilleRemoved(grille);
            return true;
        }

        @Override
        public GrilleEditor getGrilleEditor(Grille grille) {
            GrilleImpl altasimplGrille = (GrilleImpl)grille;
            return altasimplGrille.getGrilleEditor();
        }

        @Override
        public Structure getStructure() {
            return StructureImpl.this;
        }
    }

    private class SpecialContexte
    implements Contexte {
        private short specialType;
        private int code;
        private Labels sourceLabels;

        private SpecialContexte(short specialType, int code) {
            this.specialType = specialType;
            this.code = code;
            switch (specialType) {
                case 5: {
                    break;
                }
            }
        }

        @Override
        public Atlas getAtlas() {
            return StructureImpl.this.atlas;
        }

        @Override
        public short getTermType() {
            return this.specialType;
        }

        @Override
        public ContexteList getChildren() {
            return StructureUtils.EMPTY_CONTEXTE_LIST;
        }

        @Override
        public int getCode() {
            return this.code;
        }

        @Override
        public int getChildIndex() {
            return -1;
        }

        @Override
        public Grille getGrille() {
            switch (this.specialType) {
                case 5: {
                    return null;
                }
                case 6: {
                    return StructureImpl.this.grilleDesFamilles;
                }
            }
            return null;
        }

        @Override
        public String getIdctxt() {
            return "";
        }

        @Override
        public Labels getLabels() {
            return this.sourceLabels;
        }

        @Override
        public Contexte getParent() {
            return null;
        }

        @Override
        public boolean isActive() {
            return true;
        }

        @Override
        public Attributes getAttributes() {
            return AttributeUtils.EMPTY_ATTRIBUTES;
        }
    }
}

