/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.display.layers.cartecentree;

import java.awt.Dimension;
import java.awt.Point;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.List;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.AtlasURI;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.descripteurs.DescripteurList;
import net.desmodo.atlas.descripteurs.Descripteurs;
import net.desmodo.atlas.display.AwtSvgWriter;
import net.desmodo.atlas.display.Translation;
import net.desmodo.atlas.display.blocks.BlockLocator;
import net.desmodo.atlas.display.blocks.LiaisonBlock;
import net.desmodo.atlas.display.blocks.LibelleBlock;
import net.desmodo.atlas.display.blocks.LinkBlock;
import net.desmodo.atlas.display.layers.cartecentree.CartecentreeLayer;
import net.desmodo.atlas.display.layers.cartecentree.CartecentreeLayerDisplay;
import net.desmodo.atlas.display.layers.common.LinkLayer;
import net.desmodo.atlas.display.layers.common.LinkLayerDisplay;
import net.desmodo.atlas.display.overflow.Overflow;
import net.desmodo.atlas.session.Navigation;
import net.desmodo.atlas.session.Session;
import net.desmodo.atlas.session.SessionConfKeys;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.ContexteList;
import net.desmodo.atlas.structure.StructureUtils;
import net.desmodo.atlas.ventilation.Secteur;
import net.desmodo.atlas.ventilation.VentilationName;
import net.mapeadores.util.geometry.CartesianOrigin;
import net.mapeadores.util.xml.ns.NameSpace;

public class SvgExport
implements SessionConfKeys {
    private final File directory;
    private final CartecentreeLayer cartecentreeLayer;
    private Navigation navigation;
    private Templates templates;
    private String extension;
    private CurrentTerm currentTerm;
    private LinkLayer linkLayer;
    private static final NameSpace atlasNameSpace = new NameSpace("atlas", "http://mapeadores.net/atlas");

    public SvgExport(File directory, CartecentreeLayer cartecentreeLayer) {
        this.directory = directory;
        this.cartecentreeLayer = cartecentreeLayer;
    }

    public static void exportUnique(File svgFile, CartecentreeLayer cartecentreeLayer) throws IOException {
        File directory = svgFile.getParentFile();
        String svgName = svgFile.getName();
        SvgExport svgExport = new SvgExport(directory, cartecentreeLayer);
        svgExport.exportSvg(svgName);
    }

    public void exportAtlas(Session session, Templates templates, String extension) throws IOException, TransformerException {
        this.templates = templates;
        if (extension.length() == 0) {
            extension = "xhtml";
        }
        this.extension = extension;
        boolean displayLink = session.getSessionConf().getBoolean("display.link");
        if (displayLink) {
            this.linkLayer = new LinkLayer();
            this.linkLayer.setBlockLocator(new InternalBlockLocator());
        } else {
            this.linkLayer = null;
        }
        Atlas atlas = session.getAtlas();
        Descripteurs descripteurs = atlas.getDescripteurs();
        ContexteList contexteList = StructureUtils.getContexteList(atlas.getStructure().getGrilleDesFamilles(), false);
        this.navigation = new Navigation(session, null, VentilationName.VENTILATION_NATURELLE);
        int contexteCount = contexteList.getContexteCount();
        for (int i = 0; i < contexteCount; ++i) {
            Contexte famille = contexteList.getContexte(i);
            this.exportDescripteurList(descripteurs.getInFamilleDescripteurList(famille));
        }
        DescripteurList sansfamilleList = descripteurs.getInFamilleDescripteurList(StructureUtils.getSansfamilleContexte(atlas.getStructure()));
        this.exportDescripteurList(sansfamilleList);
    }

    private void exportDescripteurList(DescripteurList descripteurList) throws IOException, TransformerException {
        int descripteurCount = descripteurList.getDescripteurCount();
        for (int i = 0; i < descripteurCount; ++i) {
            this.exportDescripteur(descripteurList.getDescripteur(i));
        }
    }

    private void exportDescripteur(Descripteur descripteur) throws IOException, TransformerException {
        this.currentTerm = new CurrentTerm(descripteur);
        this.navigation.changeVentilationRoot(descripteur);
        this.cartecentreeLayer.setVentilation(this.navigation.getCurrentNavigationUnit());
        if (this.linkLayer != null) {
            this.linkLayer.update();
        }
        this.exportSvg(new File(this.currentTerm.getTargetDirectory(), "ventilation_naturelle.svg"));
    }

    private void exportSvg(File f) throws IOException, TransformerException {
        XmlExport xmlExport = new XmlExport(new FileOutputStream(f));
        xmlExport.export(this.cartecentreeLayer);
        if (this.templates != null) {
            String name = f.getName();
            name = name.substring(0, name.length() - 4) + "." + this.extension;
            File destination = new File(f.getParent(), name);
            try {
                Transformer transformer = this.templates.newTransformer();
                this.setParameter(transformer);
                transformer.transform(new StreamSource(f), new StreamResult(destination));
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                // empty catch block
            }
            if (!name.equals(f.getName())) {
                f.delete();
            }
        }
    }

    private void setParameter(Transformer transformer) {
        transformer.setParameter("ATLAS_VENTILATIONROOT", this.currentTerm.uri);
        transformer.setParameter("ATLAS_PATH", this.currentTerm.getAtlasPath());
    }

    private void exportSvg(String svgFileName) throws IOException {
        XmlExport xmlExport = new XmlExport(new FileOutputStream(new File(this.directory, svgFileName)));
        xmlExport.export(this.cartecentreeLayer);
    }

    class InternalBlockLocator
    implements BlockLocator {
        InternalBlockLocator() {
        }

        @Override
        public LibelleBlock getActiveLibelleBlockAt(Point P) {
            LibelleBlock centralBlock = SvgExport.this.cartecentreeLayer.getCentralBlock();
            if (centralBlock == null) {
                return null;
            }
            if (centralBlock.contains(P)) {
                return centralBlock;
            }
            return null;
        }

        @Override
        public LiaisonBlock getLiaisonBlockAt(Point P) {
            return SvgExport.this.cartecentreeLayer.getLiaisonBlockLayer().getLiaisonBlockAt(P);
        }

        @Override
        public LibelleBlock getBordureLibelleBlockAt(Point P) {
            for (LibelleBlock bordureBox : SvgExport.this.cartecentreeLayer.getBordureLibelleList()) {
                if (!bordureBox.contains(P)) continue;
                return bordureBox;
            }
            return null;
        }

        @Override
        public List getActiveLibelleBlockList() {
            LibelleBlock centralBlock = SvgExport.this.cartecentreeLayer.getCentralBlock();
            if (centralBlock == null) {
                return Collections.EMPTY_LIST;
            }
            return Collections.singletonList(centralBlock);
        }

        @Override
        public List getLiaisonBlockList() {
            return SvgExport.this.cartecentreeLayer.getLiaisonBlockLayer().getLiaisonBlockList();
        }

        @Override
        public List getBordureLibelleBlockList() {
            return SvgExport.this.cartecentreeLayer.getBordureLibelleList();
        }

        @Override
        public LibelleBlock getBordureLibelleBlock(Secteur secteur) {
            return SvgExport.this.cartecentreeLayer.getBordureBlock(secteur);
        }

        @Override
        public LinkBlock getLinkBlockAt(Point P) {
            return null;
        }
    }

    private class CurrentTerm {
        Term current;
        String uri;
        String[] uriTokens;

        CurrentTerm(Term term) {
            this.current = term;
            this.uri = AtlasURI.toURIString(term);
            this.uriTokens = AtlasURI.toURITokens(term);
        }

        private File getTargetDirectory() throws IOException {
            File targetDirectory = SvgExport.this.directory;
            for (int i = 0; i < this.uriTokens.length; ++i) {
                targetDirectory = new File(targetDirectory, this.uriTokens[i]);
            }
            targetDirectory.mkdirs();
            return targetDirectory;
        }

        private String getAtlasPath() {
            int length = this.uriTokens.length;
            if (length == 0) {
                return ".";
            }
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    buf.append("/");
                }
                buf.append("..");
            }
            return buf.toString();
        }
    }

    private class XmlExport {
        AwtSvgWriter svgWriter;
        BufferedWriter writer;
        Translation translation;
        private CartesianOrigin cartesianOrigin;

        XmlExport(OutputStream outputStream) throws IOException {
            this.writer = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
            this.svgWriter = new AwtSvgWriter(false);
            this.svgWriter.setAppendable(this.writer);
            this.svgWriter.setIndentLength(0);
            this.svgWriter.appendXMLDeclaration();
        }

        private void export(CartecentreeLayer cartecentreeLayer) throws IOException {
            this.cartesianOrigin = cartecentreeLayer.getCartesianOrigin();
            Overflow overflow = cartecentreeLayer.getOverflow();
            this.translation = new Translation(overflow.getWestOverflow(), overflow.getNorthOverflow());
            Dimension dim = overflow.getRealSize();
            this.svgWriter.addNameSpace(NameSpace.XLINK_NAMESPACE);
            this.svgWriter.addNameSpace(atlasNameSpace);
            this.svgWriter.openSvg(dim.width, dim.height);
            CartecentreeLayerDisplay.exportSVG(cartecentreeLayer, this.svgWriter, this.translation);
            if (SvgExport.this.linkLayer != null) {
                LinkLayerDisplay.exportSVG(SvgExport.this.linkLayer, this.svgWriter, this.translation);
            }
            this.svgWriter.closeSvg();
            this.writer.close();
        }
    }
}

