/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.conf;

import java.awt.Font;
import java.awt.Rectangle;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import net.desmodo.atlas.conf.Conf;
import net.desmodo.atlas.conf.ConfUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.primitives.PositiveInteger;

public class StringMapConf
implements Conf {
    private final Map<String, String> stringMap = new HashMap<String, String>();
    private final Conf defaultConf;

    public StringMapConf(Conf defaultConf) {
        this.defaultConf = defaultConf;
    }

    @Override
    public boolean isTransient(String name) {
        return this.defaultConf.isTransient(name);
    }

    @Override
    public Map<String, String> toStringMap(boolean excludeTransient) {
        Map<String, String> map = this.defaultConf.toStringMap(excludeTransient);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String name = entry.getKey();
            if (excludeTransient && this.isTransient(name)) continue;
            map.put(name, entry.getValue());
        }
        return map;
    }

    @Override
    public boolean getBoolean(String name) {
        Boolean bool;
        String value = this.stringMap.get(name);
        if (value != null && (bool = ConfUtils.booleanTest(value)) != null) {
            return bool;
        }
        return this.defaultConf.getBoolean(name);
    }

    @Override
    public File getDirectory(String name) {
        File dir;
        String value = this.stringMap.get(name);
        if (value != null && (dir = ConfUtils.directoryTest(value)) != null) {
            return dir;
        }
        return this.defaultConf.getDirectory(name);
    }

    @Override
    public int getInteger(String name) {
        Integer itg;
        String value = this.stringMap.get(name);
        if (value != null && (itg = ConfUtils.integerTest(value)) != null) {
            return itg;
        }
        return this.defaultConf.getInteger(name);
    }

    @Override
    public int getPositiveInteger(String name) {
        PositiveInteger positiveInteger;
        String value = this.stringMap.get(name);
        if (value != null && (positiveInteger = ConfUtils.positiveIntegerTest(value)) != null) {
            return positiveInteger.intValue();
        }
        return this.defaultConf.getPositiveInteger(name);
    }

    @Override
    public String getString(String name) {
        String value = this.stringMap.get(name);
        if (value != null) {
            return value;
        }
        return this.defaultConf.getString(name);
    }

    @Override
    public Font getFont(String name) {
        String value = this.stringMap.get(name);
        if (value != null) {
            return ConfUtils.toFont(value);
        }
        return this.defaultConf.getFont(name);
    }

    @Override
    public Rectangle getRectangle(String name) {
        String value = this.stringMap.get(name);
        if (value != null) {
            return ConfUtils.toRectangle(value);
        }
        return this.defaultConf.getRectangle(name);
    }

    @Override
    public Lang getLang(String name) {
        Lang lang;
        String value = this.stringMap.get(name);
        if (value != null && (lang = ConfUtils.langTest(value)) != null) {
            return lang;
        }
        return this.defaultConf.getLang(name);
    }

    @Override
    public MessageFormat getMessageFormat(String name) {
        MessageFormat messageFormat;
        String value = this.stringMap.get(name);
        if (value != null && (messageFormat = ConfUtils.messageFormatTest(value)) != null) {
            return messageFormat;
        }
        return this.defaultConf.getMessageFormat(name);
    }

    @Override
    public File getFile(String name) {
        File f;
        String value = this.stringMap.get(name);
        if (value != null && !(f = new File(value)).isDirectory()) {
            return f;
        }
        return this.defaultConf.getFile(name);
    }

    @Override
    public String[] getStringArray(String name) {
        String value = this.stringMap.get(name);
        if (value != null) {
            return ConfUtils.toStringArray(value);
        }
        return this.defaultConf.getStringArray(name);
    }

    @Override
    public URL getURL(String name) {
        String value = this.stringMap.get(name);
        if (value != null) {
            try {
                URL url = new URL(value);
                return url;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return this.defaultConf.getURL(name);
    }

    public void put(String name, String value) {
        if (value == null) {
            this.stringMap.remove(name);
        } else {
            this.stringMap.put(name, value);
        }
    }
}

