/*
 * Decompiled with CFR 0.152.
 */
package net.desmodo.atlas.boxes;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.util.HashMap;
import java.util.Map;
import net.desmodo.atlas.AtlasAttributes;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.boxes.BoxSkin;
import net.desmodo.atlas.boxes.BoxSkinKey;
import net.desmodo.atlas.boxes.DefaultBoxSkin;
import net.desmodo.atlas.boxes.TextBox;
import net.desmodo.atlas.boxes.TextBoxManager;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.session.Session;
import net.desmodo.atlas.session.SessionConf;
import net.desmodo.atlas.session.SessionConfKeys;
import net.desmodo.atlas.session.SessionUtils;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.Grille;
import net.desmodo.atlas.structure.StructureUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.StringUtils;

public class DefaultTextBoxManager
implements TextBoxManager,
SessionConfKeys {
    private final Map<Integer, BoxesBuffer> boxesBufferMap = new HashMap<Integer, BoxesBuffer>();
    private Map<BoxSkinKey, BoxSkin> boxSkinMap = new HashMap<BoxSkinKey, BoxSkin>();
    private Session session;
    private Container referenceContainer = new Container();
    private int lineMax = -1;
    private int lineLength = 21;
    private int chapeauLength = 33;
    private Font bordureFont;
    private Font liaisonFont;
    private Lang workingLang;
    private boolean defaultLib;

    public DefaultTextBoxManager(Session session) {
        this.session = session;
        this.initConfBuffer();
    }

    @Override
    public TextBox getTextBox(short textBoxType, int code) {
        BoxesBuffer boxes = this.boxesBufferMap.get(code);
        if (boxes == null) {
            boxes = new BoxesBuffer(code);
            this.boxesBufferMap.put(code, boxes);
        }
        return boxes.getTextBox(textBoxType);
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    public void clearBuffer() {
        this.boxesBufferMap.clear();
        this.boxSkinMap.clear();
        this.initConfBuffer();
    }

    public void clearBuffer(Term term) {
        this.boxesBufferMap.remove(term.getCode());
    }

    private void initConfBuffer() {
        SessionConf sessionConf = this.session.getSessionConf();
        boolean limitation = sessionConf.getBoolean("skin.linelimitation");
        this.lineMax = limitation ? sessionConf.getPositiveInteger("skin.linemax") : -1;
        this.lineLength = sessionConf.getPositiveInteger("skin.linelength");
        this.chapeauLength = sessionConf.getPositiveInteger("skin.chapeaulength");
        this.bordureFont = sessionConf.getFont("skin.font.bordure");
        this.liaisonFont = sessionConf.getFont("skin.font.liaison");
        this.workingLang = sessionConf.getLang("lang.current");
        this.defaultLib = sessionConf.getBoolean("lang.defaultlib");
    }

    private BoxSkin getBoxSkin(short textBoxType, int code) {
        if (textBoxType == 0) {
            return this.getBordureBoxSkin();
        }
        if (textBoxType == -1) {
            return this.getChapeauBoxSkin();
        }
        Term term = SessionUtils.getTerm(this.session, code);
        if (term instanceof Descripteur) {
            return this.getBoxSkin((Descripteur)term, textBoxType);
        }
        if (term instanceof Contexte) {
            return this.getBoxSkin((Contexte)term, textBoxType);
        }
        return this.getBordureBoxSkin();
    }

    private BoxSkin getBoxSkin(Descripteur descripteur, short textBoxType) {
        BoxSkinKey key = BoxSkinKey.getBoxSkinKey(descripteur, textBoxType);
        BoxSkin boxSkin = this.boxSkinMap.get(key);
        if (boxSkin == null) {
            Color familleColor = Color.WHITE;
            Contexte famille = descripteur.getFamille();
            if (!StructureUtils.isSansfamilleContexte(famille)) {
                familleColor = AtlasAttributes.getColor(famille);
            }
            boxSkin = this.createDescripteurBoxSkin(key, familleColor, textBoxType);
            this.boxSkinMap.put(key, boxSkin);
        }
        return boxSkin;
    }

    private BoxSkin getBoxSkin(Contexte contexte, short textBoxType) {
        BoxSkinKey key = BoxSkinKey.getBoxSkinKey(contexte, textBoxType);
        if (key.equals(BoxSkinKey.BORDURE_KEY)) {
            return this.getBordureBoxSkin();
        }
        BoxSkin boxSkin = this.boxSkinMap.get(key);
        if (boxSkin == null) {
            Contexte parent = contexte.getParent();
            Grille grille = contexte.getGrille();
            Color parentColor = AtlasAttributes.getColor(parent != null ? parent : grille);
            boxSkin = this.createContexteBoxSkin(key, parentColor);
            this.boxSkinMap.put(key, boxSkin);
        }
        return boxSkin;
    }

    private BoxSkin getBordureBoxSkin() {
        BoxSkinKey key = BoxSkinKey.BORDURE_KEY;
        DefaultBoxSkin bordureBoxSkin = (DefaultBoxSkin)this.boxSkinMap.get(key);
        if (bordureBoxSkin == null) {
            bordureBoxSkin = new DefaultBoxSkin(key, this.session);
            bordureBoxSkin.setOpaque(false);
            bordureBoxSkin.setPaddingInsets(new Insets(0, 0, 0, 3));
            bordureBoxSkin.setBackgroundColor(Color.WHITE);
            bordureBoxSkin.setTextColor(Color.BLACK);
            bordureBoxSkin.setFont(this.bordureFont);
            this.boxSkinMap.put(key, bordureBoxSkin);
        }
        return bordureBoxSkin;
    }

    private BoxSkin getChapeauBoxSkin() {
        BoxSkinKey key = BoxSkinKey.CHAPEAU_KEY;
        DefaultBoxSkin chapeauBoxSkin = (DefaultBoxSkin)this.boxSkinMap.get(key);
        if (chapeauBoxSkin == null) {
            chapeauBoxSkin = new DefaultBoxSkin(key, this.session);
            chapeauBoxSkin.setOpaque(false);
            chapeauBoxSkin.setPaddingInsets(new Insets(0, 0, 0, 3));
            chapeauBoxSkin.setBackgroundColor(Color.WHITE);
            chapeauBoxSkin.setTextColor(Color.RED);
            chapeauBoxSkin.setFont(this.bordureFont);
            this.boxSkinMap.put(key, chapeauBoxSkin);
        }
        return chapeauBoxSkin;
    }

    private BoxSkin createDescripteurBoxSkin(BoxSkinKey key, Color familleColor, short textBoxType) {
        Color borderColor;
        switch (textBoxType) {
            case 2: {
                borderColor = Color.GRAY;
                break;
            }
            default: {
                borderColor = Color.BLACK;
            }
        }
        DefaultBoxSkin boxSkin = new DefaultBoxSkin(key, this.session);
        boxSkin.setOpaque(true);
        boxSkin.setPaddingInsets(new Insets(0, 3, 2, 3));
        boxSkin.setBackgroundColor(familleColor);
        boxSkin.setBorderColor(borderColor);
        boxSkin.setTextColor(Color.BLACK);
        boxSkin.setFont(this.liaisonFont);
        return boxSkin;
    }

    private BoxSkin createContexteBoxSkin(BoxSkinKey key, Color borderColor) {
        DefaultBoxSkin boxSkin = new DefaultBoxSkin(key, this.session);
        boxSkin.setOpaque(true);
        boxSkin.setPaddingInsets(new Insets(0, 3, 2, 3));
        boxSkin.setBackgroundColor(Color.WHITE);
        boxSkin.setBorderColor(borderColor);
        boxSkin.setTextColor(Color.BLACK);
        boxSkin.setFont(this.liaisonFont);
        return boxSkin;
    }

    private class BoxesBuffer {
        private BufferedTextBox chapeauTextBox;
        private BufferedTextBox[] blocTextBoxArray = new BufferedTextBox[5];
        private String[] libelleLines;
        private String libelle;
        private short category;
        private int termCode;

        private BoxesBuffer(int code) {
            Term term = SessionUtils.getTerm(DefaultTextBoxManager.this.session, code);
            this.termCode = term.getCode();
            Label libelleObj = term.getLabels().getLabel(DefaultTextBoxManager.this.workingLang);
            if (libelleObj == null && DefaultTextBoxManager.this.defaultLib) {
                libelleObj = term.getLabels().getFirstLabel();
            }
            this.libelle = libelleObj != null ? libelleObj.getLabelString() : "- ? -";
            this.libelleLines = StringUtils.wrap((String)this.libelle, (int)DefaultTextBoxManager.this.lineLength, (int)DefaultTextBoxManager.this.lineMax);
        }

        public TextBox getTextBox(short textBoxType) {
            if (textBoxType == -1) {
                return this.getChapeauTextBox();
            }
            return this.getBlocTextBox(textBoxType);
        }

        private BufferedTextBox getChapeauTextBox() {
            if (this.chapeauTextBox == null) {
                BoxSkin boxSkin = DefaultTextBoxManager.this.getBoxSkin((short)-1, this.termCode);
                this.chapeauTextBox = new BufferedTextBox(boxSkin, DefaultTextBoxManager.this.chapeauLength);
            }
            return this.chapeauTextBox;
        }

        private BufferedTextBox getBlocTextBox(short textBoxType) {
            if (textBoxType < 0 || textBoxType > 5) {
                throw new IllegalArgumentException("type argument has bad value");
            }
            BufferedTextBox textBox = this.blocTextBoxArray[textBoxType];
            if (textBox == null) {
                BoxSkin boxSkin = DefaultTextBoxManager.this.getBoxSkin(textBoxType, this.termCode);
                this.blocTextBoxArray[textBoxType] = textBox = new BufferedTextBox(boxSkin);
            }
            return textBox;
        }

        private class BufferedTextBox
        implements TextBox {
            private BoxSkin boxSkin;
            private InternalLine[] internalLines;
            private Dimension dimension;
            private int lineAscent;
            private int lineDescent;

            private FontMetrics commonInit(BoxSkin boxSkin) {
                this.boxSkin = boxSkin;
                FontMetrics fontMetrics = DefaultTextBoxManager.this.referenceContainer.getFontMetrics(boxSkin.getFont());
                this.lineAscent = fontMetrics.getAscent() + 1;
                this.lineDescent = fontMetrics.getDescent();
                return fontMetrics;
            }

            private BufferedTextBox(BoxSkin boxSkin) {
                FontMetrics fontMetrics = this.commonInit(boxSkin);
                Insets padding = boxSkin.getPaddingInsets();
                int lineCount = BoxesBuffer.this.libelleLines.length;
                this.internalLines = new InternalLine[lineCount];
                int lineLengthMax = 0;
                int[] lineLengths = new int[lineCount];
                for (int i = 0; i < lineCount; ++i) {
                    String strg_line = BoxesBuffer.this.libelleLines[i];
                    int lng = fontMetrics.stringWidth(strg_line);
                    lineLengthMax = Math.max(lineLengthMax, lng);
                    lineLengths[i] = lng;
                }
                int y = padding.top;
                for (int i = 0; i < lineCount; ++i) {
                    Point startPoint = new Point(padding.left + (lineLengthMax - lineLengths[i]) / 2, y += this.lineAscent);
                    this.internalLines[i] = new InternalLine(i, startPoint, lineLengths[i]);
                }
                this.dimension = new Dimension(padding.left + lineLengthMax + padding.right, padding.top + y + this.lineDescent + padding.bottom);
            }

            private BufferedTextBox(BoxSkin boxSkin, int chapeauLength) {
                FontMetrics fontMetrics = this.commonInit(boxSkin);
                Insets padding = boxSkin.getPaddingInsets();
                this.internalLines = new InternalLine[1];
                String strg_line = BoxesBuffer.this.libelle;
                if (strg_line.length() > chapeauLength) {
                    strg_line = strg_line.substring(0, chapeauLength) + "...";
                }
                int lng = fontMetrics.stringWidth(strg_line);
                int y = padding.top + this.lineAscent;
                Point startPoint = new Point(padding.left, y);
                this.internalLines[0] = new InternalLine(strg_line, startPoint, lng);
                this.dimension = new Dimension(padding.left + lng + padding.right, padding.top + y + this.lineDescent + padding.bottom);
            }

            @Override
            public BoxSkin getBoxSkin() {
                return this.boxSkin;
            }

            @Override
            public Dimension getDimension() {
                return this.dimension;
            }

            @Override
            public String getText() {
                return BoxesBuffer.this.libelle;
            }

            @Override
            public TextBox.Line getLine(int i) {
                return this.internalLines[i];
            }

            @Override
            public int getLineCount() {
                return this.internalLines.length;
            }

            private class InternalLine
            implements TextBox.Line {
                private final Point startPoint;
                private final int lineLength;
                private final String lineString;

                private InternalLine(String lineString, Point startPoint, int lineLength) {
                    this.startPoint = startPoint;
                    this.lineLength = lineLength;
                    this.lineString = lineString;
                }

                private InternalLine(int index, Point startPoint, int lineLength) {
                    this.startPoint = startPoint;
                    this.lineLength = lineLength;
                    this.lineString = BoxesBuffer.this.libelleLines[index];
                }

                @Override
                public int getLineAscent() {
                    return BufferedTextBox.this.lineAscent;
                }

                @Override
                public int getLineDescent() {
                    return BufferedTextBox.this.lineDescent;
                }

                @Override
                public int getLineLength() {
                    return this.lineLength;
                }

                @Override
                public String getLineString() {
                    return this.lineString;
                }

                @Override
                public Point getStartPoint() {
                    return this.startPoint;
                }
            }
        }
    }
}

