/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmoservice.importation;

import fr.exemole.bdfext.desmoservice.api.DesmoserviceContext;
import fr.exemole.bdfext.desmoservice.atlas.BdfAtlasUtils;
import fr.exemole.bdfext.desmoservice.atlas.engines.EngineUtils;
import fr.exemole.bdfserver.api.users.BdfUser;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.Term;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.descripteurs.DescripteurList;
import net.desmodo.atlas.descripteurs.Descripteurs;
import net.desmodo.atlas.liens.LienHierarchiqueGroup;
import net.desmodo.atlas.liens.LienHierarchiqueGroupList;
import net.desmodo.atlas.session.SessionSource;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.ContexteList;
import net.desmodo.atlas.structure.Grille;
import net.fichotheque.ExistingIdException;
import net.fichotheque.Fichotheque;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.alias.AliasHolder;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.croisement.CroisementEditor;
import net.fichotheque.croisement.Croisements;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.ThesaurusEditor;
import net.fichotheque.tools.FichothequeTools;
import net.fichotheque.tools.croisement.CroisementChangeEngine;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.text.Label;

public class SessionUpdateEngine {
    private final DesmoserviceContext desmoserviceContext;
    private final BdfUser bdfUser;
    private final AliasHolder coreAliasHolder;
    private final String name;
    private final FichothequeEditor fichothequeEditor;
    private final Map<String, Motcle> descripteurMap = new HashMap<String, Motcle>();

    private SessionUpdateEngine(DesmoserviceContext desmoserviceContext, BdfUser bdfUser, String name, FichothequeEditor fichothequeEditor) {
        this.desmoserviceContext = desmoserviceContext;
        this.coreAliasHolder = desmoserviceContext.getCoreAliasHolder();
        this.name = name;
        this.fichothequeEditor = fichothequeEditor;
        this.bdfUser = bdfUser;
    }

    public static void run(String name, SessionSource sessionSource, DesmoserviceContext desmoserviceContext, BdfUser bdfUser, FichothequeEditor fichothequeEditor) {
        SessionUpdateEngine engine = new SessionUpdateEngine(desmoserviceContext, bdfUser, name, fichothequeEditor);
        engine.init();
        engine.run(sessionSource);
    }

    private void init() {
        String prefix = this.name + "/";
        int prefixLength = prefix.length();
        Thesaurus descripteurThesaurus = this.coreAliasHolder.getThesaurus("descripteur");
        for (Motcle motcle : descripteurThesaurus.getMotcleList()) {
            String idalpha = motcle.getIdalpha();
            if (!idalpha.startsWith(prefix)) continue;
            this.descripteurMap.put(idalpha.substring(prefixLength), motcle);
        }
    }

    private void run(SessionSource sessionSource) {
        Atlas atlas = sessionSource.getAtlas();
        this.updateDescripteurs(atlas);
        this.removeDescripteurs();
        this.updateLiens(atlas);
    }

    private void removeDescripteurs() {
        Corpus lienhierarchiqueCorpus = this.coreAliasHolder.getCorpus("lienhierarchique");
        ArrayList<FicheMeta> removeList = new ArrayList<FicheMeta>();
        for (Motcle remainingMotcle : this.descripteurMap.values()) {
            Croisements lienCroisements = this.fichothequeEditor.getFichotheque().getCroisements((SubsetItem)remainingMotcle, (Subset)lienhierarchiqueCorpus);
            for (Croisements.Entry lienEntry : lienCroisements.getEntryList()) {
                if (!EngineUtils.isPere(lienEntry.getCroisement())) continue;
                removeList.add((FicheMeta)lienEntry.getSubsetItem());
            }
            FichothequeTools.remove((FichothequeEditor)this.fichothequeEditor, (Motcle)remainingMotcle);
        }
        for (FicheMeta ficheMeta : removeList) {
            FichothequeTools.remove((FichothequeEditor)this.fichothequeEditor, (FicheMeta)ficheMeta);
        }
    }

    private void updateDescripteur(Descripteur descripteur, ThesaurusEditor descripteurEditor, Motcle familleMotcle) {
        CroisementChangeEngine engine;
        CroisementEditor croisementEditor2;
        String iddescString = descripteur.getIddesc().toString();
        Motcle descripteurMotcle = this.descripteurMap.get(iddescString);
        if (descripteurMotcle != null) {
            this.descripteurMap.remove(iddescString);
            if (familleMotcle == null) {
                croisementEditor2 = this.fichothequeEditor.getCroisementEditor();
                engine = CroisementChangeEngine.clearExistingEngine((SubsetItem)descripteurMotcle, Collections.singleton(IncludeKey.newInstance((SubsetKey)this.coreAliasHolder.getThesaurus("famille").getSubsetKey(), (String)"", (int)1)));
                croisementEditor2.updateCroisements((SubsetItem)descripteurMotcle, engine.toCroisementChanges());
            }
        } else {
            try {
                descripteurMotcle = descripteurEditor.createMotcle(-1, this.name + "/" + iddescString);
            }
            catch (ParseException | ExistingIdException croisementEditor2) {
                // empty catch block
            }
        }
        SessionUpdateEngine.copy(descripteur, descripteurMotcle, descripteurEditor);
        if (familleMotcle != null) {
            croisementEditor2 = this.fichothequeEditor.getCroisementEditor();
            engine = CroisementChangeEngine.clearExistingEngine((SubsetItem)descripteurMotcle);
            engine.addLien((SubsetItem)familleMotcle, "", 1);
            croisementEditor2.updateCroisements((SubsetItem)descripteurMotcle, engine.toCroisementChanges());
        }
    }

    private void updateDescripteurs(Atlas atlas) {
        Thesaurus familleThesaurus = this.coreAliasHolder.getThesaurus("famille");
        Thesaurus descripteurThesaurus = this.coreAliasHolder.getThesaurus("descripteur");
        ThesaurusEditor descripteurEditor = this.fichothequeEditor.getThesaurusEditor(descripteurThesaurus);
        Descripteurs descripteurs = atlas.getDescripteurs();
        Grille grille = atlas.getStructure().getGrilleDesFamilles();
        this.initDescripteurs(grille.getFirstLevelContexteList(), descripteurs, descripteurEditor, familleThesaurus);
        Contexte sansfamille = atlas.getStructure().getSpecialContexte((short)6);
        DescripteurList descripteurList = atlas.getDescripteurs().getInFamilleDescripteurList(sansfamille);
        int descripteurCount = descripteurList.getDescripteurCount();
        for (int j = 0; j < descripteurCount; ++j) {
            this.updateDescripteur(descripteurList.getDescripteur(j), descripteurEditor, null);
        }
    }

    private void initDescripteurs(ContexteList contexteList, Descripteurs descripteurs, ThesaurusEditor descripteurEditor, Thesaurus familleThesaurus) {
        int count = contexteList.getContexteCount();
        for (int i = 0; i < count; ++i) {
            Contexte contexte = contexteList.getContexte(i);
            Motcle familleMotcle = familleThesaurus.getMotcleByIdalpha(this.name + "/" + contexte.getIdctxt());
            DescripteurList descripteurList = descripteurs.getInFamilleDescripteurList(contexte);
            int descripteurCount = descripteurList.getDescripteurCount();
            for (int j = 0; j < descripteurCount; ++j) {
                this.updateDescripteur(descripteurList.getDescripteur(j), descripteurEditor, familleMotcle);
            }
            this.initDescripteurs(contexte.getChildren(), descripteurs, descripteurEditor, familleThesaurus);
        }
    }

    private void updateLiens(Atlas atlas) {
        Thesaurus descripteurThesaurus = this.coreAliasHolder.getThesaurus("descripteur");
        CroisementEditor croisementEditor = this.fichothequeEditor.getCroisementEditor();
        Corpus lhCorpus = this.coreAliasHolder.getCorpus("lienhierarchique");
        Fichotheque fichotheque = lhCorpus.getFichotheque();
        ArrayList<SubsetItem> otherList = new ArrayList<SubsetItem>();
        for (FicheMeta ficheMeta : lhCorpus.getFicheMetaList()) {
            Croisements croisements = fichotheque.getCroisements((SubsetItem)ficheMeta, (Subset)descripteurThesaurus);
            otherList.clear();
            for (Croisements.Entry entry : croisements.getEntryList()) {
                otherList.add(entry.getSubsetItem());
            }
            for (SubsetItem other : otherList) {
                croisementEditor.updateCroisement((SubsetItem)ficheMeta, other, BdfAtlasUtils.FILSREMOVE_CROISEMENTCHANGE);
            }
        }
        Thesaurus grilleThesaurus = this.coreAliasHolder.getThesaurus("grille");
        LienHierarchiqueGroupList list = atlas.getLiens().getLienHierarchiqueGroupList();
        int count = list.getLienHierarchiqueGroupCount();
        for (int i = 0; i < count; ++i) {
            LienHierarchiqueGroup lhg = list.getLienHierarchiqueGroup(i);
            Motcle pereMotcle = descripteurThesaurus.getMotcleByIdalpha(this.name + "/" + lhg.getDescripteurPere().getIddesc());
            Contexte contexte = lhg.getContexte();
            Motcle contexteMotcle = null;
            if (contexte.getGrille() != null) {
                contexteMotcle = grilleThesaurus.getMotcleByIdalpha(this.name + "/" + contexte.getGrille().getGrilleName() + "/" + contexte.getIdctxt());
            }
            int lhCount = lhg.getLienHierarchiqueCount();
            for (int j = 0; j < lhCount; ++j) {
                Motcle filsMotcle = descripteurThesaurus.getMotcleByIdalpha(this.name + "/" + lhg.getLienHierarchique(j).getDescripteurFils().getIddesc());
                EngineUtils.setLienHierarchique(this.fichothequeEditor, pereMotcle, contexteMotcle, filsMotcle, lhCorpus, grilleThesaurus, descripteurThesaurus);
            }
        }
    }

    private static void copy(Term term, Motcle motcle, ThesaurusEditor thesaurusEditor) {
        for (Label label : term.getLabels()) {
            thesaurusEditor.putLabel(motcle, label);
        }
        FichothequeEditor fichothequeEditor = thesaurusEditor.getFichothequeEditor();
        for (Attribute attribute : term.getAttributes()) {
            fichothequeEditor.putAttribute((Object)motcle, attribute);
        }
    }
}

