/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmoservice.atlas;

import fr.exemole.bdfext.desmoservice.atlas.BdfAtlas;
import fr.exemole.bdfext.desmoservice.atlas.BdfGrille;
import java.util.ArrayList;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.event.StructureListener;
import net.desmodo.atlas.l10n.AtlasL10n;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.ContexteList;
import net.desmodo.atlas.structure.Grille;
import net.desmodo.atlas.structure.GrilleList;
import net.desmodo.atlas.structure.Structure;
import net.desmodo.atlas.structure.StructureUtils;
import net.fichotheque.thesaurus.Motcle;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.text.Labels;

class BdfStructure
implements Structure {
    private final BdfAtlas bdfAtlas;
    private final SpecialContexte horsGrilleContexte = new SpecialContexte(5);
    private final SpecialContexte sansFamilleContexte = new SpecialContexte(6);
    private BdfGrille grilleDesFamilles;
    private GrilleList grilleList = null;

    BdfStructure(BdfAtlas bdfAtlas) {
        this.bdfAtlas = bdfAtlas;
    }

    @Override
    public Contexte getSpecialContexte(short specialType) {
        switch (specialType) {
            case 5: {
                return this.horsGrilleContexte;
            }
            case 6: {
                return this.sansFamilleContexte;
            }
        }
        return null;
    }

    @Override
    public synchronized GrilleList getGrilleList() {
        if (this.grilleList == null) {
            ArrayList<BdfGrille> list = new ArrayList<BdfGrille>();
            for (Motcle motcle : this.bdfAtlas.grilleThesaurus.getFirstLevelList()) {
                if (!motcle.getIdalpha().startsWith(this.bdfAtlas.atlasPrefix)) continue;
                list.add(this.bdfAtlas.getBdfGrille(motcle));
            }
            this.grilleList = StructureUtils.toGrilleList(list.toArray(new BdfGrille[list.size()]));
        }
        return this.grilleList;
    }

    @Override
    public Grille getGrille(String grilleName) {
        return this.bdfAtlas.getGrille(grilleName);
    }

    @Override
    public synchronized Grille getGrilleDesFamilles() {
        if (this.grilleDesFamilles == null) {
            Motcle familleMotcle = this.bdfAtlas.familleThesaurus.getMotcleByIdalpha(this.bdfAtlas.atlasMotcle.getIdalpha());
            this.grilleDesFamilles = this.bdfAtlas.getBdfGrille(familleMotcle);
        }
        return this.grilleDesFamilles;
    }

    @Override
    public Atlas getAtlas() {
        return this.bdfAtlas;
    }

    @Override
    public void addStructureListener(StructureListener structureListener) {
    }

    @Override
    public void removeStructureListener(StructureListener structureListener) {
    }

    private class SpecialContexte
    implements Contexte {
        private final short specialType;
        private final int code;
        private final Labels sourceLabels;

        private SpecialContexte(short specialType) {
            this.specialType = specialType;
            this.code = specialType;
            this.sourceLabels = AtlasL10n.getSpecialTypeLabels(specialType);
        }

        @Override
        public Atlas getAtlas() {
            return BdfStructure.this.bdfAtlas;
        }

        @Override
        public short getTermType() {
            return this.specialType;
        }

        @Override
        public ContexteList getChildren() {
            return StructureUtils.EMPTY_CONTEXTE_LIST;
        }

        @Override
        public int getCode() {
            return this.code;
        }

        @Override
        public int getChildIndex() {
            return -1;
        }

        @Override
        public Grille getGrille() {
            switch (this.specialType) {
                case 5: {
                    return null;
                }
                case 6: {
                    return BdfStructure.this.getGrilleDesFamilles();
                }
            }
            return null;
        }

        @Override
        public String getIdctxt() {
            return "";
        }

        @Override
        public Labels getLabels() {
            return this.sourceLabels;
        }

        @Override
        public Contexte getParent() {
            return null;
        }

        @Override
        public boolean isActive() {
            return true;
        }

        @Override
        public Attributes getAttributes() {
            return AttributeUtils.EMPTY_ATTRIBUTES;
        }
    }
}

