/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmoservice.atlas;

import fr.exemole.bdfext.desmoservice.atlas.BdfAtlas;
import fr.exemole.bdfext.desmoservice.atlas.BdfAtlasUtils;
import fr.exemole.bdfext.desmoservice.atlas.BdfContexte;
import fr.exemole.bdfext.desmoservice.atlas.BdfDescripteur;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.descripteurs.Descripteur;
import net.desmodo.atlas.descripteurs.DescripteurList;
import net.desmodo.atlas.descripteurs.Descripteurs;
import net.desmodo.atlas.descripteurs.DescripteursUtils;
import net.desmodo.atlas.descripteurs.Iddesc;
import net.desmodo.atlas.event.DescripteursListener;
import net.desmodo.atlas.structure.Contexte;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.croisement.Croisements;
import net.fichotheque.thesaurus.Motcle;

class BdfDescripteurs
implements Descripteurs {
    private final BdfAtlas bdfAtlas;
    private final Map<Integer, DescripteurList> descripteurListMap = new HashMap<Integer, DescripteurList>();

    BdfDescripteurs(BdfAtlas bdfAtlas) {
        this.bdfAtlas = bdfAtlas;
    }

    @Override
    public Atlas getAtlas() {
        return this.bdfAtlas;
    }

    @Override
    public synchronized DescripteurList getInFamilleDescripteurList(Contexte famille) {
        int code = famille.getCode();
        DescripteurList descripteurList = this.descripteurListMap.get(code);
        if (descripteurList != null) {
            return descripteurList;
        }
        if (famille.getTermType() == 6) {
            ArrayList<BdfDescripteur> resultList = new ArrayList<BdfDescripteur>();
            for (Motcle descripteurMotcle : this.bdfAtlas.descripteurThesaurus.getMotcleList()) {
                if (!descripteurMotcle.getIdalpha().startsWith(this.bdfAtlas.atlasPrefix) || BdfAtlasUtils.containsFamilleCroisement(this.bdfAtlas.fichotheque.getCroisements((SubsetItem)descripteurMotcle, (Subset)this.bdfAtlas.familleThesaurus))) continue;
                BdfDescripteur bdfDescripteur = this.bdfAtlas.getBdfDescripteur(descripteurMotcle);
                bdfDescripteur.setFamille(famille);
                resultList.add(bdfDescripteur);
            }
            descripteurList = DescripteursUtils.toDescripteurList(resultList.toArray(new BdfDescripteur[resultList.size()]));
        } else {
            Croisements descripteurCroisements = this.bdfAtlas.fichotheque.getCroisements((SubsetItem)((BdfContexte)famille).getMotcle(), (Subset)this.bdfAtlas.descripteurThesaurus);
            ArrayList<BdfDescripteur> resultList = new ArrayList<BdfDescripteur>();
            for (Croisements.Entry entry : descripteurCroisements.getEntryList()) {
                if (!BdfAtlasUtils.isFamilleCroisement(entry.getCroisement())) continue;
                BdfDescripteur bdfDescripteur = this.bdfAtlas.getBdfDescripteur((Motcle)entry.getSubsetItem());
                bdfDescripteur.setFamille(famille);
                resultList.add(bdfDescripteur);
            }
            descripteurList = DescripteursUtils.toDescripteurList(resultList.toArray(new BdfDescripteur[resultList.size()]));
        }
        this.descripteurListMap.put(code, descripteurList);
        return descripteurList;
    }

    @Override
    public Descripteur getDescripteurByIddesc(Iddesc iddesc) {
        return this.bdfAtlas.getDescripteurByIddesc(iddesc);
    }

    @Override
    public void addDescripteursListener(DescripteursListener descripteursListener) {
    }

    @Override
    public void removeDescripteursListener(DescripteursListener descripteursListener) {
    }
}

