/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmoservice.atlas;

import fr.exemole.bdfext.desmoservice.DesmoserviceSpace;
import fr.exemole.bdfext.desmoservice.atlas.BdfAtlas;
import fr.exemole.bdfext.desmoservice.atlas.BdfGrille;
import java.util.List;
import net.desmodo.atlas.Atlas;
import net.desmodo.atlas.structure.Contexte;
import net.desmodo.atlas.structure.ContexteList;
import net.desmodo.atlas.structure.Grille;
import net.desmodo.atlas.structure.StructureUtils;
import net.fichotheque.thesaurus.Motcle;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.text.Labels;

class BdfContexte
implements Contexte {
    private final BdfAtlas bdfAtlas;
    private final int code;
    private final Motcle motcle;
    private final short type;
    private BdfGrille bdfGrille = null;
    private boolean parentInit = false;
    private BdfContexte parentContexte = null;
    private boolean childrenInit = false;
    private ContexteList contexteList = null;

    BdfContexte(BdfAtlas bdfAtlas, Motcle motcle, short type, int code) {
        this.bdfAtlas = bdfAtlas;
        this.type = type;
        this.code = code;
        this.motcle = motcle;
    }

    @Override
    public synchronized ContexteList getChildren() {
        if (!this.childrenInit) {
            List motcleList = this.motcle.getChildList();
            int count = motcleList.size();
            if (count == 0) {
                this.contexteList = StructureUtils.EMPTY_CONTEXTE_LIST;
            } else {
                Contexte[] array = new BdfContexte[count];
                for (int i = 0; i < count; ++i) {
                    BdfContexte child = this.bdfAtlas.getBdfContexte((Motcle)motcleList.get(i));
                    child.setParent(this);
                    if (this.bdfGrille != null) {
                        child.setGrille(this.bdfGrille);
                    }
                    array[i] = child;
                }
                this.contexteList = StructureUtils.toContexteList(array);
            }
            this.childrenInit = true;
        }
        return this.contexteList;
    }

    @Override
    public synchronized Contexte getParent() {
        if (!this.parentInit) {
            Motcle parent = this.motcle.getParent();
            if (parent == null) {
                throw new IllegalStateException("mot.getParent() == null pour un contexte");
            }
            Motcle grandparent = parent.getParent();
            if (grandparent == null) {
                this.setParent(null);
            } else {
                this.setParent(this.bdfAtlas.getBdfContexte(parent));
            }
        }
        return this.parentContexte;
    }

    @Override
    public int getChildIndex() {
        return this.motcle.getChildIndex();
    }

    @Override
    public String getIdctxt() {
        int idx2;
        String idalpha = this.motcle.getIdalpha();
        if (this.type == 4) {
            int length = this.bdfAtlas.atlasPrefix.length();
            if (idalpha.length() <= length) {
                throw new IllegalStateException("Idalpha (" + idalpha + ") doit commencer par " + this.bdfAtlas.atlasPrefix);
            }
            return idalpha.substring(length);
        }
        String idctxt = "";
        int idx = idalpha.indexOf(47);
        if (idx != -1 && (idx2 = idalpha.indexOf(47, idx + 1)) != -1) {
            idctxt = idalpha.substring(idx2 + 1);
        }
        if (idctxt.isEmpty()) {
            throw new IllegalStateException("Idalpha (" + idalpha + ") doit commencer par " + this.bdfAtlas.atlasPrefix + " suivi du nom de la grille");
        }
        return idctxt;
    }

    @Override
    public synchronized Grille getGrille() {
        if (this.bdfGrille == null) {
            Motcle parent;
            Motcle ancetre = this.motcle.getParent();
            if (ancetre == null) {
                throw new IllegalStateException("mot.getParent() == null pour un contexte");
            }
            while ((parent = ancetre.getParent()) != null) {
                ancetre = parent;
            }
            this.bdfGrille = this.bdfAtlas.getBdfGrille(ancetre);
        }
        return this.bdfGrille;
    }

    @Override
    public boolean isActive() {
        Attribute attribute = this.motcle.getAttributes().getAttribute(DesmoserviceSpace.ACTIVE_KEY);
        if (attribute == null) {
            return true;
        }
        return !attribute.getFirstValue().equals("0");
    }

    @Override
    public Atlas getAtlas() {
        return this.bdfAtlas;
    }

    @Override
    public short getTermType() {
        return this.type;
    }

    @Override
    public Attributes getAttributes() {
        return this.motcle.getAttributes();
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public Labels getLabels() {
        return this.motcle.getLabels();
    }

    Motcle getMotcle() {
        return this.motcle;
    }

    void setParent(BdfContexte parentContexte) {
        this.parentInit = true;
        this.parentContexte = parentContexte;
    }

    void setGrille(BdfGrille bdfGrille) {
        this.bdfGrille = bdfGrille;
    }
}

