/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.producers.json.api;

import fr.exemole.bdfext.desmography.DesmodojsSpace;
import fr.exemole.bdfext.desmography.DesmographySpace;
import fr.exemole.bdfext.desmography.DesmographyUtils;
import fr.exemole.bdfext.desmography.atlas.Atlas;
import fr.exemole.bdfext.desmography.atlas.engines.SearchEngine;
import fr.exemole.bdfext.desmography.producers.json.AbstractJsonProducer;
import fr.exemole.bdfext.desmography.producers.json.ErrorJsonProducer;
import fr.exemole.bdfext.desmography.producers.json.WarningHandler;
import fr.exemole.bdfext.desmography.producers.json.api.AxesJsonProducer;
import fr.exemole.bdfext.desmography.producers.json.api.FamiliesJsonProducer;
import fr.exemole.bdfext.desmography.producers.json.api.GridsJsonProducer;
import fr.exemole.bdfext.desmography.producers.json.api.IndexJsonProducer;
import fr.exemole.bdfext.desmography.producers.json.api.MetadataJsonProducer;
import fr.exemole.bdfext.desmography.producers.json.api.ResourcesJsonProducer;
import fr.exemole.bdfext.desmography.producers.json.api.SummaryJsonProducer;
import fr.exemole.bdfext.desmography.producers.json.api.TermsJsonProducer;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import fr.exemole.bdfserver.tools.exportation.table.BdfTableExportUtils;
import fr.exemole.bdfserver.tools.instruction.BdfInstructionUtils;
import fr.exemole.bdfserver.tools.roles.PermissionSummaryBuilder;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.Fiches;
import net.fichotheque.exportation.table.CellConverter;
import net.fichotheque.exportation.table.SumCellConverter;
import net.fichotheque.extraction.ExtractionContext;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.corpus.FichesBuilder;
import net.fichotheque.tools.permission.PermissionUtils;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.utils.TableExportUtils;
import net.fichotheque.utils.ThesaurusUtils;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.conditions.ConditionsUtils;
import net.mapeadores.util.conditions.TextCondition;
import net.mapeadores.util.json.JsonProducer;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangContext;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.localisation.LangsUtils;
import net.mapeadores.util.localisation.ListLangContextBuilder;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.localisation.UserLangContext;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;

public final class ApiJsonProducerFactory {
    private static final Set<SubsetItem> EMPTY_SET = Collections.emptySet();

    private ApiJsonProducerFactory() {
    }

    public static JsonProducer getJsonProducer(BdfServer bdfServer, RequestMap requestMap, BdfUser bdfUser) {
        AbstractJsonProducer abstractJsonProducer;
        WarningHandler warningHandler = new WarningHandler();
        try {
            abstractJsonProducer = ApiJsonProducerFactory.getJsonProducer(bdfServer, requestMap, bdfUser, warningHandler);
        }
        catch (ErrorMessageException eme) {
            MessageLocalisation messageLocalisation = BdfInstructionUtils.getMessageLocalisation((RequestMap)requestMap, (BdfServer)bdfServer, (UserLangContext)bdfUser);
            abstractJsonProducer = new ErrorJsonProducer(eme.getErrorMessage(), messageLocalisation);
        }
        if (!warningHandler.isEmpty() && requestMap.isTrue("warnings")) {
            abstractJsonProducer.setWarningHandler(warningHandler);
        }
        return abstractJsonProducer;
    }

    private static AbstractJsonProducer getJsonProducer(BdfServer bdfServer, RequestMap requestMap, BdfUser bdfUser, WarningHandler warningHandler) throws ErrorMessageException {
        String type = ApiJsonProducerFactory.getMandatoryValue(requestMap, "type");
        String desmographyName = ApiJsonProducerFactory.getMandatoryValue(requestMap, "desmography");
        String version = ApiJsonProducerFactory.getMandatoryValue(requestMap, "version");
        Atlas atlas = DesmographyUtils.getAtlas(bdfServer, desmographyName);
        if (type.equals("axes")) {
            return ApiJsonProducerFactory.getAxesJsonProducer(bdfServer, requestMap, atlas, version, warningHandler);
        }
        if (type.equals("resources")) {
            return ApiJsonProducerFactory.getResourcesJsonProducer(bdfServer, requestMap, atlas, version, warningHandler);
        }
        if (type.equals("summary")) {
            PermissionSummary permissionSummary = null;
            if (bdfUser != null) {
                permissionSummary = PermissionSummaryBuilder.build((BdfServer)bdfServer, (BdfUser)bdfUser);
            }
            return ApiJsonProducerFactory.getSummaryJsonProducer(bdfServer, requestMap, atlas, version, permissionSummary, warningHandler);
        }
        if (type.equals("families")) {
            return ApiJsonProducerFactory.getFamiliesJsonProducer(bdfServer, requestMap, atlas, version, warningHandler);
        }
        if (type.equals("grids")) {
            return ApiJsonProducerFactory.getGridsJsonProducer(bdfServer, requestMap, atlas, version, warningHandler);
        }
        if (type.equals("terms")) {
            return ApiJsonProducerFactory.getTermsJsonProducer(bdfServer, requestMap, atlas, version, warningHandler);
        }
        if (type.equals("metadata")) {
            return ApiJsonProducerFactory.getMetadataJsonProducer(bdfServer, requestMap, atlas, version, warningHandler);
        }
        if (type.equals("index")) {
            return ApiJsonProducerFactory.getIndexJsonProducer(bdfServer, requestMap, atlas, version, warningHandler);
        }
        throw new ErrorMessageException("_ error.unknown.parametervalue", new Object[]{"type", type});
    }

    private static AbstractJsonProducer getMetadataJsonProducer(BdfServer bdfServer, RequestMap requestMap, Atlas atlas, String version, WarningHandler warningHandler) throws ErrorMessageException {
        Lang lang = ApiJsonProducerFactory.getPreferredLang(bdfServer, atlas, requestMap);
        return new MetadataJsonProducer(atlas, lang);
    }

    private static AbstractJsonProducer getIndexJsonProducer(BdfServer bdfServer, RequestMap requestMap, Atlas atlas, String version, WarningHandler warningHandler) throws ErrorMessageException {
        Lang lang = ApiJsonProducerFactory.getLang(requestMap);
        return new IndexJsonProducer(atlas, lang);
    }

    private static AbstractJsonProducer getSummaryJsonProducer(BdfServer bdfServer, RequestMap requestMap, Atlas atlas, String version, PermissionSummary permissionSummary, WarningHandler warningHandler) throws ErrorMessageException {
        Motcle term;
        Lang lang = ApiJsonProducerFactory.getLang(requestMap);
        String termName = ApiJsonProducerFactory.getMandatoryValue(requestMap, "term");
        try {
            term = atlas.getTermThesaurus().getMotcleById(Integer.parseInt(termName));
        }
        catch (NumberFormatException nfe) {
            term = atlas.getTermThesaurus().getMotcleByIdalpha(termName);
        }
        if (term == null) {
            throw new ErrorMessageException("_ error.unknown.parametervalue", new Object[]{"term", termName});
        }
        CellConverter propertiesCellConverter = ApiJsonProducerFactory.getCellConverter(bdfServer, atlas, lang, requestMap);
        return new SummaryJsonProducer(atlas, term, lang, permissionSummary, propertiesCellConverter);
    }

    private static AbstractJsonProducer getFamiliesJsonProducer(BdfServer bdfServer, RequestMap requestMap, Atlas atlas, String version, WarningHandler warningHandler) throws ErrorMessageException {
        Lang lang = ApiJsonProducerFactory.getLang(requestMap);
        return new FamiliesJsonProducer(atlas, lang);
    }

    private static AbstractJsonProducer getGridsJsonProducer(BdfServer bdfServer, RequestMap requestMap, Atlas atlas, String version, WarningHandler warningHandler) throws ErrorMessageException {
        Lang lang = ApiJsonProducerFactory.getLang(requestMap);
        return new GridsJsonProducer(atlas, lang);
    }

    private static AbstractJsonProducer getAxesJsonProducer(BdfServer bdfServer, RequestMap requestMap, Atlas atlas, String version, WarningHandler warningHandler) throws ErrorMessageException {
        Lang lang = ApiJsonProducerFactory.getLang(requestMap);
        String axesParam = ApiJsonProducerFactory.getMandatoryValue(requestMap, "axes");
        String[] axes = StringUtils.getTechnicalTokens((String)axesParam, (boolean)true);
        boolean includeRoots = false;
        boolean ignoreEmptyLeaf = false;
        String ignoreParam = requestMap.getParameter("ignore");
        if (ignoreParam != null && ignoreParam.contains("empty_leaf")) {
            ignoreEmptyLeaf = true;
        }
        CellConverter propertiesCellConverter = ApiJsonProducerFactory.getCellConverter(bdfServer, atlas, lang, requestMap);
        Set<Motcle> termSet = ApiJsonProducerFactory.getTerms(requestMap, atlas, warningHandler, true);
        return new AxesJsonProducer(atlas, termSet, axes, lang, ignoreEmptyLeaf, propertiesCellConverter);
    }

    private static AbstractJsonProducer getResourcesJsonProducer(BdfServer bdfServer, RequestMap requestMap, Atlas atlas, String version, WarningHandler warningHandler) throws ErrorMessageException {
        Set<SubsetItem> itemSet;
        Lang lang = ApiJsonProducerFactory.getLang(requestMap);
        String source = requestMap.getParameter("source");
        if (source == null) {
            source = "resources";
        }
        switch (source) {
            case "resources": {
                itemSet = ApiJsonProducerFactory.fromResources(requestMap, atlas, warningHandler);
                break;
            }
            case "corpuslist_attribute": {
                itemSet = ApiJsonProducerFactory.fromCorpusListAttribute(atlas, lang);
                break;
            }
            default: {
                throw new ErrorMessageException("_ error.unknown.parametervalue", new Object[]{"source", source});
            }
        }
        boolean withIndexation = false;
        CellConverter propertiesCellEngine = ApiJsonProducerFactory.getCellConverter(bdfServer, atlas, lang, requestMap);
        String fields = requestMap.getParameter("fields");
        if (fields != null) {
            String[] fieldTokens;
            String[] stringArray = fieldTokens = StringUtils.getTechnicalTokens((String)fields, (boolean)true);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String token;
                switch (token = stringArray[i]) {
                    case "indexation": {
                        withIndexation = true;
                    }
                }
            }
        }
        return new ResourcesJsonProducer(atlas, itemSet, lang, withIndexation, propertiesCellEngine);
    }

    private static Set<SubsetItem> fromResources(RequestMap requestMap, Atlas atlas, WarningHandler warningHandler) throws ErrorMessageException {
        LinkedHashSet<SubsetItem> itemSet = new LinkedHashSet<SubsetItem>();
        String resources = ApiJsonProducerFactory.getMandatoryValue(requestMap, "resources");
        String[] tokens = StringUtils.getTechnicalTokens((String)resources, (boolean)true);
        warningHandler.setCurrentParameter("resources");
        for (String token : tokens) {
            boolean done = false;
            int idx = token.indexOf(47);
            if (idx != -1) {
                try {
                    SubsetItem subsetItem;
                    SubsetKey subsetKey = SubsetKey.parse((String)token.substring(0, idx));
                    int id = Integer.parseInt(token.substring(idx + 1));
                    Subset subset = atlas.getTermThesaurus().getFichotheque().getSubset(subsetKey);
                    if (subset != null && (subsetItem = subset.getSubsetItemById(id)) != null) {
                        itemSet.add(subsetItem);
                        done = true;
                    }
                }
                catch (NumberFormatException | ParseException exception) {
                    // empty catch block
                }
            }
            if (done) continue;
            warningHandler.addWarning("_ error.unknown.parametervalue", token);
        }
        if (itemSet.isEmpty()) {
            throw new ErrorMessageException("_ error.wrong.parametervalue", new Object[]{"resources", resources});
        }
        return itemSet;
    }

    private static Set<SubsetItem> fromCorpusListAttribute(Atlas atlas, Lang lang) {
        Attribute attribute = atlas.getTermThesaurus().getThesaurusMetadata().getAttributes().getAttribute(DesmodojsSpace.CORPUSLIST_KEY);
        if (attribute == null) {
            return EMPTY_SET;
        }
        FichesBuilder fichesBuilder = FichesBuilder.build((String)"title-asc", (Lang)lang);
        for (String value : attribute) {
            Corpus corpus = FichothequeUtils.getCorpus((Fichotheque)atlas.getFichotheque(), (String)value);
            if (corpus == null) continue;
            fichesBuilder.addAll((Collection)corpus.getFicheMetaList());
        }
        Fiches fiches = fichesBuilder.toFiches();
        LinkedHashSet<SubsetItem> itemSet = new LinkedHashSet<SubsetItem>();
        for (Fiches.Entry entry : fiches.getEntryList()) {
            itemSet.addAll(entry.getSubsetItemList());
        }
        return itemSet;
    }

    private static AbstractJsonProducer getTermsJsonProducer(BdfServer bdfServer, RequestMap requestMap, Atlas atlas, String version, WarningHandler warningHandler) throws ErrorMessageException {
        Lang lang = ApiJsonProducerFactory.getLang(requestMap);
        Collection<Object> terms = ApiJsonProducerFactory.getTerms(requestMap, atlas, warningHandler, false);
        String qParameter = requestMap.getParameter("q");
        if (qParameter != null && !qParameter.isEmpty()) {
            String qMode = requestMap.getParameter("q-mode");
            if (qMode != null && qMode.equals("union")) {
                qParameter = "|" + qParameter;
            }
            TextCondition condition = ConditionsUtils.parseSimpleCondition((String)qParameter);
            terms = SearchEngine.searchTerms(bdfServer, atlas, condition, lang, terms);
        }
        if (terms == null) {
            terms = ThesaurusUtils.EMPTY_MOTCLELIST;
        }
        return new TermsJsonProducer(atlas, terms, lang);
    }

    public static String getMandatoryValue(RequestMap requestMap, String paramName) throws ErrorMessageException {
        return DesmographyUtils.getMandatoryValue(requestMap, paramName);
    }

    public static Lang getLang(RequestMap requestMap) throws ErrorMessageException {
        String langString = ApiJsonProducerFactory.getMandatoryValue(requestMap, "lang");
        try {
            return Lang.parse((String)langString);
        }
        catch (ParseException pe) {
            throw new ErrorMessageException("_ error.wrong.lang", new Object[]{langString});
        }
    }

    private static Set<Motcle> getTerms(RequestMap requestMap, Atlas atlas, WarningHandler warningHandler, boolean mandatory) throws ErrorMessageException {
        String termNames;
        if (mandatory) {
            termNames = ApiJsonProducerFactory.getMandatoryValue(requestMap, "terms");
        } else {
            termNames = requestMap.getParameter("terms");
            if (termNames == null || termNames.isEmpty()) {
                return null;
            }
        }
        String[] tokens = StringUtils.getTechnicalTokens((String)termNames, (boolean)true);
        LinkedHashSet<Motcle> termSet = new LinkedHashSet<Motcle>();
        warningHandler.setCurrentParameter("terms");
        for (String token : tokens) {
            Motcle term;
            try {
                term = atlas.getTermThesaurus().getMotcleById(Integer.parseInt(token));
            }
            catch (NumberFormatException nfe) {
                term = null;
            }
            if (term != null) {
                termSet.add(term);
                continue;
            }
            warningHandler.addWarning("_ error.unknown.parametervalue", token);
        }
        if (termSet.isEmpty()) {
            throw new ErrorMessageException("_ error.wrong.parametervalue", new Object[]{"terms", termNames});
        }
        return termSet;
    }

    private static CellConverter getCellConverter(BdfServer bdfServer, Atlas atlas, Lang lang, RequestMap requestMap) {
        Thesaurus termThesaurus = atlas.getTermThesaurus();
        Attribute attribute = termThesaurus.getThesaurusMetadata().getAttributes().getAttribute(DesmographySpace.TABLEEXPORT_KEY);
        if (attribute == null) {
            return TableExportUtils.EMPTY_CELLCONVERTER;
        }
        String tableExportName = attribute.getFirstValue();
        ExtractionContext extractionContext = BdfServerUtils.initExtractionContextBuilder((BdfServer)bdfServer, (LangContext)ListLangContextBuilder.build((Lang)lang), (PermissionSummary)PermissionUtils.FICHOTHEQUEADMIN_PERMISSIONSUMMARY).toExtractionContext();
        SumCellConverter cellConverter = BdfTableExportUtils.getCellConverterFromName((BdfServer)bdfServer, (ExtractionContext)extractionContext, (String)tableExportName, null, (boolean)false);
        if (cellConverter == null) {
            return TableExportUtils.EMPTY_CELLCONVERTER;
        }
        return cellConverter;
    }

    private static Lang getPreferredLang(BdfServer bdfServer, Atlas atlas, RequestMap requestMap) {
        Langs authorizedLangs = atlas.getLangs();
        String userLangsString = requestMap.getParameter("userlangs");
        if (userLangsString == null) {
            return (Lang)authorizedLangs.get(0);
        }
        Langs userLangs = LangsUtils.toCleanLangs((String)userLangsString);
        if (userLangs.isEmpty()) {
            return (Lang)authorizedLangs.get(0);
        }
        for (Lang userLang : userLangs) {
            Lang lang = LangsUtils.checkLang((Lang)userLang, (List)authorizedLangs);
            if (lang == null) continue;
            return lang;
        }
        return (Lang)authorizedLangs.get(0);
    }
}

