/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfext.desmography.atlas.engines;

import fr.exemole.bdfext.desmography.api.AtlasEdition;
import fr.exemole.bdfext.desmography.atlas.Atlas;
import fr.exemole.bdfext.desmography.atlas.AtlasUtils;
import fr.exemole.bdfext.desmography.atlas.RelationEditor;
import fr.exemole.bdfext.desmography.atlas.RelationTrace;
import fr.exemole.bdfext.desmography.atlas.engines.AtlasEditionReport;
import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fichotheque.ExistingIdException;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.croisement.Croisements;
import net.fichotheque.croisement.Liaison;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.ParentRecursivityException;
import net.fichotheque.thesaurus.ThesaurusEditor;
import net.fichotheque.tools.FichothequeTools;
import net.fichotheque.tools.thesaurus.ThesaurusTools;
import net.fichotheque.utils.CroisementUtils;
import net.fichotheque.utils.ThesaurusUtils;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeChange;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.LabelChange;

public class AtlasEditionEngine {
    private final Atlas atlas;
    private final BdfServer bdfServer;
    private final FichothequeEditor fichothequeEditor;
    private final ThesaurusEditor termThesaurusEditor;
    private final RelationEditor relationEditor;
    private final MessageHandler messageHandler;
    private final AtlasEditionReport atlasEditionReport;

    public AtlasEditionEngine(Atlas atlas, BdfParameters bdfParameters, FichothequeEditor fichothequeEditor, MessageHandler messageHandler) {
        this.atlas = atlas;
        this.relationEditor = RelationEditor.newInstance(bdfParameters, fichothequeEditor, atlas);
        this.termThesaurusEditor = fichothequeEditor.getThesaurusEditor(atlas.getTermThesaurus());
        this.bdfServer = bdfParameters.getBdfServer();
        this.fichothequeEditor = fichothequeEditor;
        this.messageHandler = messageHandler;
        this.atlasEditionReport = new AtlasEditionReport();
    }

    public AtlasEditionReport runEdition(AtlasEdition atlasEdition) {
        ArrayList<AtlasEdition.TermRemove> termRemoveList = new ArrayList<AtlasEdition.TermRemove>();
        ArrayList<AtlasEdition.TermMerge> termMergeList = new ArrayList<AtlasEdition.TermMerge>();
        for (AtlasEdition.EditionUnit unit : atlasEdition.getEditionUnitList()) {
            if (unit instanceof AtlasEdition.TermCreation) {
                this.runTermCreation((AtlasEdition.TermCreation)unit);
                continue;
            }
            if (unit instanceof AtlasEdition.TermChange) {
                this.runTermChange((AtlasEdition.TermChange)unit);
                continue;
            }
            if (unit instanceof AtlasEdition.FamilyRemove) {
                this.runFamilyRemove((AtlasEdition.FamilyRemove)unit);
                continue;
            }
            if (unit instanceof AtlasEdition.FamilyAdd) {
                this.runFamilyAdd((AtlasEdition.FamilyAdd)unit);
                continue;
            }
            if (unit instanceof AtlasEdition.InferiorsRemove) {
                this.runInferiorsRemove((AtlasEdition.InferiorsRemove)unit);
                continue;
            }
            if (unit instanceof AtlasEdition.HierarchyAdd) {
                this.runHierarchyAdd((AtlasEdition.HierarchyAdd)unit);
                continue;
            }
            if (unit instanceof AtlasEdition.HierarchyCreation) {
                this.runHierarchyCreation((AtlasEdition.HierarchyCreation)unit);
                continue;
            }
            if (unit instanceof AtlasEdition.TermRemove) {
                termRemoveList.add((AtlasEdition.TermRemove)unit);
                continue;
            }
            if (!(unit instanceof AtlasEdition.TermMerge)) continue;
            termMergeList.add((AtlasEdition.TermMerge)unit);
        }
        for (AtlasEdition.TermMerge termMerge : termMergeList) {
            this.runTermMerge(termMerge);
        }
        for (AtlasEdition.TermRemove termRemove : termRemoveList) {
            this.runTermRemove(termRemove);
        }
        return this.atlasEditionReport;
    }

    private void runTermRemove(AtlasEdition.TermRemove termRemove) {
        Motcle term = termRemove.getTerm();
        Croisements croisements = AtlasUtils.getRelationCroisements(this.atlas, term);
        ArrayList<FicheMeta> removeList = new ArrayList<FicheMeta>();
        for (Croisements.Entry entry : croisements.getEntryList()) {
            FicheMeta relation = (FicheMeta)entry.getSubsetItem();
            if (!this.testRemove(relation, term)) continue;
            removeList.add(relation);
        }
        for (FicheMeta relation : removeList) {
            this.relationEditor.removeRelation(relation);
        }
        FichothequeTools.remove((FichothequeEditor)this.fichothequeEditor, (Motcle)term);
    }

    private boolean testRemove(FicheMeta relation, Motcle term) {
        List<Motcle> inferiors;
        List<Motcle> superiors = AtlasUtils.superiors(this.atlas, relation);
        if (superiors.size() == 1 && superiors.get(0).equals(term)) {
            return true;
        }
        boolean testInferiors = false;
        switch (AtlasUtils.getRelationType(relation)) {
            case "hierarchy": 
            case "subsectors": 
            case "subfamilies": {
                testInferiors = true;
            }
        }
        return testInferiors && (inferiors = AtlasUtils.inferiors(this.atlas, relation)).size() == 1 && inferiors.get(0).equals(term);
    }

    private void runTermMerge(AtlasEdition.TermMerge termMerge) {
        Motcle source = termMerge.getTerm();
        Motcle destination = termMerge.getDestinationTerm();
        if (ThesaurusUtils.isDescendant((Motcle)destination, (Motcle)source)) {
            return;
        }
        Set<RelationTrace> relationTraceSet = AtlasEditionEngine.getSuperiorTraceSet(this.atlas, destination);
        Croisements croisements = AtlasUtils.getRelationCroisements(this.atlas, source);
        ArrayList<FicheMeta> removeList = new ArrayList<FicheMeta>();
        for (Croisements.Entry entry : croisements.getEntryList()) {
            FicheMeta relation = (FicheMeta)entry.getSubsetItem();
            if (!this.testMerge(relation, source, destination, relationTraceSet)) continue;
            removeList.add(relation);
        }
        for (FicheMeta relation : removeList) {
            this.relationEditor.removeRelation(relation);
        }
        try {
            ThesaurusTools.merge((FichothequeEditor)this.fichothequeEditor, (Motcle)source, (Motcle)destination, (Langs)this.atlas.getLangs());
        }
        catch (ParentRecursivityException pre) {
            throw new ShouldNotOccurException("test done before");
        }
    }

    private boolean testMerge(FicheMeta relation, Motcle source, Motcle destination, Set<RelationTrace> relationTraceSet) {
        List<Motcle> superiors = AtlasUtils.superiors(this.atlas, relation);
        List<Motcle> inferiors = AtlasUtils.inferiors(this.atlas, relation);
        String relationType = AtlasUtils.getRelationType(relation);
        if (superiors.contains(source) && inferiors.contains(destination)) {
            if (inferiors.size() == 1) {
                switch (relationType) {
                    case "hierarchy": 
                    case "subsectors": 
                    case "subfamilies": {
                        return true;
                    }
                }
            }
            this.relationEditor.removeInferior(relation, destination);
        }
        if (inferiors.contains(source)) {
            boolean remove = false;
            if (superiors.contains(destination)) {
                remove = true;
            } else {
                RelationTrace relationTrace = RelationTrace.traceSuperiors(this.atlas, relation);
                if (relationTraceSet.contains(relationTrace)) {
                    remove = true;
                }
            }
            if (remove) {
                if (inferiors.size() == 1) {
                    switch (relationType) {
                        case "hierarchy": 
                        case "subsectors": 
                        case "subfamilies": {
                            return true;
                        }
                    }
                }
                this.relationEditor.removeInferior(relation, source);
            }
        }
        return false;
    }

    private void runTermCreation(AtlasEdition.TermCreation termCreation) {
        Motcle newTerm;
        try {
            newTerm = this.termThesaurusEditor.createMotcle(-1, null);
        }
        catch (ParseException | ExistingIdException e) {
            throw new ShouldNotOccurException((Exception)e);
        }
        for (Attribute attribute : termCreation.getAttributes()) {
            this.fichothequeEditor.putAttribute((Object)newTerm, attribute);
        }
        for (Label label : termCreation.getLabels()) {
            this.termThesaurusEditor.putLabel(newTerm, label);
        }
        this.atlasEditionReport.addTermCreation(newTerm);
        Motcle family = termCreation.getFamily();
        if (family != null) {
            this.relationEditor.addToFamily(family, newTerm);
        }
    }

    private void runTermChange(AtlasEdition.TermChange termChange) {
        Motcle motcle = termChange.getTerm();
        AttributeChange attributeChange = termChange.getAttributeChange();
        for (Attribute attribute : attributeChange.getChangedAttributes()) {
            this.fichothequeEditor.putAttribute((Object)motcle, attribute);
        }
        for (AttributeKey removedAttributeKey : attributeChange.getRemovedAttributeKeyList()) {
            this.fichothequeEditor.removeAttribute((Object)motcle, removedAttributeKey);
        }
        LabelChange labelChange = termChange.getLabelChange();
        for (Label label : labelChange.getChangedLabels()) {
            this.termThesaurusEditor.putLabel(motcle, label);
        }
        for (Lang lang : labelChange.getRemovedLangList()) {
            this.termThesaurusEditor.removeLabel(motcle, lang);
        }
    }

    private void runFamilyRemove(AtlasEdition.FamilyRemove familyRemove) {
        this.relationEditor.removeFromFamily(familyRemove.getFamily(), familyRemove.getTerm());
    }

    private void runFamilyAdd(AtlasEdition.FamilyAdd familyAdd) {
        this.relationEditor.addToFamily(familyAdd.getFamily(), familyAdd.getTerm());
    }

    private void runInferiorsRemove(AtlasEdition.InferiorsRemove inferiorsRemove) {
        FicheMeta relation = inferiorsRemove.getRelation();
        this.relationEditor.removeInferiors(relation, inferiorsRemove.getInferiors());
        if (AtlasUtils.isRemoveableRelation(this.atlas, relation)) {
            this.relationEditor.removeRelation(relation);
        }
    }

    private void runHierarchyAdd(AtlasEdition.HierarchyAdd hierarchyAdd) {
        this.relationEditor.createHierarchy(hierarchyAdd.getSuperiors(), hierarchyAdd.getInferiors(), hierarchyAdd.getSectors());
    }

    private void runHierarchyCreation(AtlasEdition.HierarchyCreation hierarchyCreation) {
        Collection<Motcle> inferiors;
        Collection<Motcle> superiors;
        Motcle newTerm;
        try {
            newTerm = this.termThesaurusEditor.createMotcle(-1, null);
        }
        catch (ParseException | ExistingIdException e) {
            throw new ShouldNotOccurException((Exception)e);
        }
        for (Attribute attribute : hierarchyCreation.getAttributes()) {
            this.fichothequeEditor.putAttribute((Object)newTerm, attribute);
        }
        for (Label label : hierarchyCreation.getLabels()) {
            this.termThesaurusEditor.putLabel(newTerm, label);
        }
        this.atlasEditionReport.addTermCreation(newTerm);
        if (hierarchyCreation.getRelationRole().equals("superior")) {
            superiors = Collections.singleton(newTerm);
            inferiors = hierarchyCreation.getOthers();
        } else {
            superiors = hierarchyCreation.getOthers();
            inferiors = Collections.singleton(newTerm);
        }
        this.relationEditor.createHierarchy(superiors, inferiors, hierarchyCreation.getSectors());
        Motcle family = hierarchyCreation.getFamily();
        if (family != null) {
            this.relationEditor.addToFamily(family, newTerm);
        }
    }

    public static boolean needConfirmation(AtlasEdition atlasEdition) {
        for (AtlasEdition.EditionUnit unit : atlasEdition.getEditionUnitList()) {
            if (unit instanceof AtlasEdition.TermRemove) {
                return true;
            }
            if (!(unit instanceof AtlasEdition.TermMerge)) continue;
            return true;
        }
        return false;
    }

    private static Set<RelationTrace> getSuperiorTraceSet(Atlas atlas, Motcle term) {
        HashSet<RelationTrace> relationTraceSet = new HashSet<RelationTrace>();
        for (Liaison liaison : CroisementUtils.filter((Croisements)AtlasUtils.getRelationCroisements(atlas, term), (String)"inferior")) {
            relationTraceSet.add(RelationTrace.traceSuperiors(atlas, (FicheMeta)liaison.getSubsetItem()));
        }
        return relationTraceSet;
    }
}

