/* global Bdf,AddendaDoc */

AddendaDoc.UploadConfirm = {};

AddendaDoc.UploadConfirm.ARGS = {
    clientId: "",
    callKey: "",
    tmpFileName: "",
    extension: "",
    tmpUrl: "",
    size: "",
    unitSize: ""
     
};

AddendaDoc.UploadConfirm.init = function (args) {
    var genId = Bdf.generateId();
    $$(args.clientId).html(Bdf.render("document:client-uploadconfirm", {
        args: args,
        genId: genId
    }));
    $$(genId, "cancel").click(_cancel);
    $$(genId, "confirm").click(_confirm).focus();

    
    function _cancel() {
        let callback = _getCallback();
        if (callback) {
            callback(false);
        }
        if (window.opener) {
            window.close();
        }
    }
    
    function _confirm() {
        let callback = _getCallback();
        if (callback) {
            callback({
                callKey: args.callKey,
                tmpFileName: args.tmpFileName,
                extension: args.extension
            });
        }
        if (window.opener) {
            window.close();
        }
    }
    
    function _getCallback() {
        let callerWindow;
        if (window.opener) {
            callerWindow = window.opener;
        } else {
            callerWindow = window.parent;
        }
        return callerWindow.Bdf.getCallback(args.callKey);
    }
};
    
$(function () {
    Bdf.initTemplates();
    AddendaDoc.UploadConfirm.init(AddendaDoc.UploadConfirm.ARGS );
});