/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.servlets;

import java.io.File;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import net.mapeadores.util.annotation.Nullable;

public final class ServletUtils {
    private ServletUtils() {
    }

    @Nullable
    public static String getInitParameter(ServletContext servletContext, String name) {
        String value = servletContext.getInitParameter(name);
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() == 0) {
            return null;
        }
        return value;
    }

    public static boolean getBooleanInitParameter(ServletContext servletContext, String name) {
        String value = servletContext.getInitParameter(name);
        if (value == null) {
            return false;
        }
        switch (value = value.trim().toLowerCase()) {
            case "true": 
            case "on": 
            case "1": {
                return true;
            }
        }
        return false;
    }

    public static String getServletContextName(ServletContext servletContext) {
        String contextPath = servletContext.getContextPath();
        if (contextPath.length() == 0) {
            return "ROOT";
        }
        return contextPath.substring(1);
    }

    public static String getFullUrl(String canonicalUrl, HttpServletRequest request) {
        if (canonicalUrl.length() > 0) {
            String queryString;
            String pathInfo = request.getPathInfo();
            StringBuilder buf = new StringBuilder(canonicalUrl);
            if (pathInfo != null && pathInfo.length() > 1) {
                buf.append(pathInfo, 1, pathInfo.length());
            }
            if ((queryString = request.getQueryString()) != null) {
                buf.append("?").append(queryString);
            }
            return buf.toString();
        }
        StringBuffer requestURL = request.getRequestURL();
        String queryString = request.getQueryString();
        if (queryString == null) {
            requestURL.append('?').append(queryString);
        }
        return requestURL.toString();
    }

    @Nullable
    public static File getRealFile(ServletContext servletContext, String path) {
        String realPath = servletContext.getRealPath(path);
        if (realPath == null) {
            return null;
        }
        File file = new File(realPath);
        if (!file.exists()) {
            return null;
        }
        return file;
    }
}

