/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.money;

import java.text.ParseException;
import java.util.AbstractList;
import java.util.Collection;
import java.util.LinkedHashSet;
import net.mapeadores.util.money.Currencies;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.text.StringUtils;

public final class CurrenciesUtils {
    public static final Currencies EMPTY_CURRENCIES = new EmptyCurrencies();

    private CurrenciesUtils() {
    }

    public static Currencies toCleanCurrencies(String s) {
        ExtendedCurrency[] array = CurrenciesUtils.toCleanCurrencyArray(s);
        return new ArrayCurrencies(array);
    }

    public static ExtendedCurrency[] toCleanCurrencyArray(String s) {
        String[] tokens = StringUtils.getTechnicalTokens(s, true);
        LinkedHashSet<ExtendedCurrency> currencySet = new LinkedHashSet<ExtendedCurrency>();
        for (String token : tokens) {
            try {
                ExtendedCurrency lang = ExtendedCurrency.parse(token);
                currencySet.add(lang);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return currencySet.toArray(new ExtendedCurrency[currencySet.size()]);
    }

    public static boolean areEquals(Currencies currencies, Collection<ExtendedCurrency> collection) {
        int length = collection.size();
        if (length != currencies.size()) {
            return false;
        }
        if (length == 0) {
            return true;
        }
        int p = 0;
        for (ExtendedCurrency currency : collection) {
            if (!currency.equals(currencies.get(p))) {
                return false;
            }
            ++p;
        }
        return true;
    }

    public static Currencies fromCollection(Collection<ExtendedCurrency> collection) {
        ExtendedCurrency[] array = collection.toArray(new ExtendedCurrency[collection.size()]);
        return new ArrayCurrencies(array);
    }

    public static Currencies wrap(ExtendedCurrency ... currencies) {
        if (currencies == null || currencies.length == 0) {
            return EMPTY_CURRENCIES;
        }
        return new ArrayCurrencies(currencies);
    }

    private static class ArrayCurrencies
    extends AbstractList<ExtendedCurrency>
    implements Currencies {
        private final ExtendedCurrency[] array;

        private ArrayCurrencies(ExtendedCurrency[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public ExtendedCurrency get(int i) {
            return this.array[i];
        }
    }

    private static class EmptyCurrencies
    extends AbstractList<ExtendedCurrency>
    implements Currencies {
        private EmptyCurrencies() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public ExtendedCurrency get(int i) {
            throw new IndexOutOfBoundsException("currencyCount = 0");
        }
    }

    private static class SingletonCurrencies
    extends AbstractList<ExtendedCurrency>
    implements Currencies {
        private final ExtendedCurrency currency;

        private SingletonCurrencies(ExtendedCurrency currency) {
            this.currency = currency;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public ExtendedCurrency get(int i) {
            if (i != 0) {
                throw new IndexOutOfBoundsException("currencyCount = 1");
            }
            return this.currency;
        }
    }
}

