/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.logging;

import java.util.ArrayList;
import java.util.List;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.logging.SourceLog;
import net.mapeadores.util.logging.SourceMessage;

public class SourceLogBuilder
implements MessageHandler {
    private final String name;
    private final List<InternalSourceMessage> sourceMessageList = new ArrayList<InternalSourceMessage>();

    public SourceLogBuilder() {
        this.name = "";
    }

    public SourceLogBuilder(String name) {
        this.name = name;
    }

    public boolean hasMessage() {
        return !this.sourceMessageList.isEmpty();
    }

    public boolean isEmpty() {
        return this.sourceMessageList.isEmpty();
    }

    @Override
    public void addMessage(String category, Message message) {
        if (category == null) {
            throw new IllegalArgumentException("category is null");
        }
        if (message == null) {
            throw new IllegalArgumentException("message is null");
        }
        this.sourceMessageList.add(new InternalSourceMessage(category, message));
    }

    public List<SourceMessage> filter(String category) {
        ArrayList<SourceMessage> list = new ArrayList<SourceMessage>();
        for (InternalSourceMessage sourceMessage : this.sourceMessageList) {
            if (!sourceMessage.getCategory().startsWith(category)) continue;
            list.add(sourceMessage);
        }
        return list;
    }

    public List<SourceMessage> filterWarning() {
        return this.filter("warning.");
    }

    public List<SourceMessage> filterSevere() {
        return this.filter("severe.");
    }

    public String toRawString() {
        StringBuilder buf = new StringBuilder();
        for (SourceMessage sourceMessage : this.sourceMessageList) {
            if (buf.length() > 0) {
                buf.append("\n");
            }
            buf.append(sourceMessage.getMessageKey());
            Object[] values = sourceMessage.getMessageValues();
            int length = values.length;
            if (length <= 0) continue;
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    buf.append(" / ");
                } else {
                    buf.append(": ");
                }
                buf.append(values[i].toString());
            }
        }
        return buf.toString();
    }

    public SourceLog toSourceLog() {
        List<SourceMessage> finalList = LogUtils.wrap(this.sourceMessageList.toArray(new SourceMessage[this.sourceMessageList.size()]));
        return new InternalSourceLog(this.name, finalList);
    }

    public static SourceLogBuilder init() {
        return new SourceLogBuilder();
    }

    public static SourceLogBuilder init(String name) {
        return new SourceLogBuilder(name);
    }

    private static class InternalSourceMessage
    implements SourceMessage {
        private final String category;
        private final Message message;

        private InternalSourceMessage(String category, Message message) {
            this.category = category;
            this.message = message;
        }

        @Override
        public String getCategory() {
            return this.category;
        }

        @Override
        public String getMessageKey() {
            return this.message.getMessageKey();
        }

        @Override
        public List<Object> getMessageValueList() {
            return this.message.getMessageValueList();
        }

        @Override
        public Object[] getMessageValues() {
            return this.message.getMessageValues();
        }
    }

    private static class InternalSourceLog
    implements SourceLog {
        private final String name;
        private final List<SourceMessage> sourceMessageList;

        private InternalSourceLog(String name, List<SourceMessage> sourceMessageList) {
            this.name = name;
            this.sourceMessageList = sourceMessageList;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public List<SourceMessage> getSourceMessageList() {
            return this.sourceMessageList;
        }
    }
}

