/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.opendocument.css;

import java.io.File;
import net.mapeadores.opendocument.css.extraction.CssExtraction;

public class Main {
    private Main() {
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("org.w3c.css.sac.parser", "com.steadystate.css.parser.SACParserCSS2");
        int length = args.length;
        if (length == 0) {
            Main.missingArgument();
            return;
        }
        String options = args[0];
        if (options.startsWith("-")) {
            if (length == 1) {
                Main.missingArgument();
                return;
            }
            options = options.substring(1);
            String[] temp = new String[length - 1];
            System.arraycopy(args, 1, temp, 0, length - 1);
            args = temp;
        } else {
            options = "";
        }
        if (options.indexOf(101) != -1) {
            Main.extract(options, args);
        }
    }

    private static void extract(String options, String[] args) throws Exception {
        boolean force = options.indexOf(102) != -1;
        boolean withCss = options.indexOf(99) != -1;
        boolean withXml = options.indexOf(120) != -1;
        Arguments arguments = new Arguments();
        arguments.parse(args, 1);
        String originePath = args[0];
        File origine = new File(originePath);
        if (!origine.exists()) {
            System.out.println("Fichier inexistant : " + originePath);
            return;
        }
        if (origine.isDirectory()) {
            System.out.println("C'est un r\u00e9pertoire : " + originePath);
            return;
        }
        File cssDestination = null;
        File xmlDestination = null;
        if (withCss && !Main.testFile(cssDestination = arguments.cssPath != null ? new File(arguments.cssPath) : new File(origine.getParentFile(), origine.getName() + ".css"), force)) {
            return;
        }
        if (withXml && !Main.testFile(xmlDestination = arguments.xmlPath != null ? new File(arguments.xmlPath) : new File(origine.getParentFile(), origine.getName() + ".styles.xml"), force)) {
            return;
        }
        CssExtraction.extract(origine, cssDestination, xmlDestination);
    }

    private static boolean testFile(File f, boolean force) {
        if (f == null) {
            return true;
        }
        if (f.exists()) {
            if (f.isDirectory()) {
                System.out.println("C'est un r\u00e9pertoire : " + f.getPath());
                return false;
            }
            if (force) {
                return true;
            }
            System.out.println("Existe d\u00e9j\u00e0 : " + f.getPath());
            return false;
        }
        return true;
    }

    private static void missingArgument() {
        System.out.println("Nombre d'arguments insuffisants");
    }

    private static class Arguments {
        String cssPath;
        String xmlPath;

        Arguments() {
        }

        void parse(String[] args, int start) {
            int length = args.length - 1;
            for (int i = start; i < length; ++i) {
                String arg2;
                String arg = args[i];
                if (arg.equals("-C")) {
                    arg2 = args[i + 1];
                    if (arg2.startsWith("-")) continue;
                    this.cssPath = arg2;
                    ++i;
                    continue;
                }
                if (!arg.equals("-X") || (arg2 = args[i + 1]).startsWith("-")) continue;
                this.xmlPath = arg2;
                ++i;
            }
        }
    }
}

