/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.thesaurus.sortprecedence;

import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.fichotheque.thesaurus.Motcle;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.collation.CollationUnit;

public class PrecedenceComparator
implements Comparator<Motcle> {
    private final Lang lang;
    private final String originalPrecedence;
    private final String lowPrecedence;
    private final boolean withLowTest;
    private final RuleBasedCollator collator;
    private final String collatedPrecedence;
    private final Map<String, SortKey> keyMap = new HashMap<String, SortKey>();

    public PrecedenceComparator(String originalPrecedence, Lang lang) {
        this.originalPrecedence = originalPrecedence;
        this.lowPrecedence = originalPrecedence.toLowerCase();
        this.withLowTest = !originalPrecedence.equals(this.lowPrecedence);
        this.lang = lang;
        this.collator = (RuleBasedCollator)Collator.getInstance(lang.toLocale());
        this.collator.setStrength(0);
        this.collatedPrecedence = CollationUnit.collate(originalPrecedence, this.collator);
    }

    @Override
    public int compare(Motcle mc1, Motcle mc2) {
        SortKey sortKey1 = this.getSortKey(mc1);
        SortKey sortKey2 = this.getSortKey(mc2);
        return sortKey1.compareTo(sortKey2);
    }

    private SortKey getSortKey(Motcle motcle) {
        String globalId = motcle.getGlobalId();
        SortKey sortKey = this.keyMap.get(globalId);
        if (sortKey == null) {
            String labelString = motcle.getLabelString(this.lang, "");
            String collatedLabel = !labelString.isEmpty() ? CollationUnit.collate(labelString, this.collator) : "";
            String idalpha = motcle.getIdalpha();
            int rate = this.getRate(idalpha, collatedLabel);
            sortKey = new SortKey(rate, globalId, idalpha, collatedLabel);
            this.keyMap.put(globalId, sortKey);
        }
        return sortKey;
    }

    private int getRate(String idalpha, String collatedLabel) {
        int idalphaRate;
        if (idalpha != null && (idalphaRate = this.getIdalphaRate(idalpha)) > 0) {
            return idalphaRate;
        }
        return this.getLabelRate(collatedLabel);
    }

    private int getIdalphaRate(String idalpha) {
        String lowIdalpha = idalpha.toLowerCase();
        if (idalpha.equals(this.originalPrecedence)) {
            return 99;
        }
        if (this.withLowTest) {
            if (idalpha.equals(this.lowPrecedence)) {
                return 97;
            }
            if (lowIdalpha.equals(this.lowPrecedence)) {
                return 95;
            }
        } else if (lowIdalpha.equals(this.originalPrecedence)) {
            return 96;
        }
        if (idalpha.startsWith(this.originalPrecedence)) {
            return 89;
        }
        if (this.withLowTest) {
            if (idalpha.startsWith(this.lowPrecedence)) {
                return 87;
            }
            if (lowIdalpha.startsWith(this.lowPrecedence)) {
                return 85;
            }
        } else if (lowIdalpha.startsWith(this.originalPrecedence)) {
            return 86;
        }
        if (idalpha.contains(this.originalPrecedence)) {
            return 79;
        }
        if (this.withLowTest) {
            if (idalpha.contains(this.lowPrecedence)) {
                return 77;
            }
            if (lowIdalpha.contains(this.lowPrecedence)) {
                return 75;
            }
        } else if (lowIdalpha.contains(this.originalPrecedence)) {
            return 76;
        }
        return 0;
    }

    private int getLabelRate(String collatedLabel) {
        if (collatedLabel.equals(this.collatedPrecedence)) {
            return 69;
        }
        int index = collatedLabel.indexOf(this.collatedPrecedence);
        if (index == 0) {
            return 67;
        }
        if (index > 0) {
            if (index < 12) {
                return 65;
            }
            return 63;
        }
        return 0;
    }

    private static class SortKey {
        private final int rate;
        private final String idalpha;
        private final String globalId;
        private final String collatedLabel;

        private SortKey(int rate, String globalId, String idalpha, String collatedLabel) {
            this.rate = rate;
            this.globalId = globalId;
            this.idalpha = idalpha;
            this.collatedLabel = collatedLabel;
        }

        private int compareTo(SortKey otherKey) {
            int comp;
            if (this.rate > otherKey.rate) {
                return -1;
            }
            if (this.rate < otherKey.rate) {
                return 1;
            }
            if (this.idalpha != null) {
                if (otherKey.idalpha == null) {
                    return -1;
                }
                comp = this.idalpha.compareTo(otherKey.idalpha);
                if (comp != 0) {
                    return comp;
                }
            } else if (otherKey.idalpha != null) {
                return 1;
            }
            if ((comp = this.collatedLabel.compareTo(otherKey.collatedLabel)) != 0) {
                return comp;
            }
            return this.globalId.compareTo(otherKey.globalId);
        }
    }
}

