/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.parsers;

import java.text.ParseException;
import net.fichotheque.ExistingIdException;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.ThesaurusEditor;
import net.fichotheque.tools.parsers.JunctionParseEngine;
import net.fichotheque.tools.parsers.ParseContext;
import net.fichotheque.tools.parsers.junction.WeightMotcleToken;
import net.fichotheque.utils.ThesaurusUtils;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.CleanedString;

abstract class DynamicEdit {
    protected final ParseContext parseContext;
    protected final Parameters parameters;

    protected DynamicEdit(Parameters parameters) {
        this.parameters = parameters;
        this.parseContext = parameters.getParseContext();
    }

    public abstract void editToken(WeightMotcleToken var1);

    public Motcle createMotcle(CleanedString labelText) {
        return this.createMotcle(this.parameters.getMainThesaurus(), labelText);
    }

    public Motcle createMotcle(Thesaurus thesaurus, CleanedString labelText) {
        ThesaurusEditor thsedit = this.parseContext.getFichothequeEditor().getThesaurusEditor(thesaurus);
        try {
            Motcle motcle = thsedit.createMotcle(-1, null);
            if (labelText != null) {
                thsedit.putLabel(motcle, this.parameters.getLang(), labelText);
            }
            return motcle;
        }
        catch (ParseException | ExistingIdException e) {
            throw new ShouldNotOccurException(e);
        }
    }

    public void createTie(Motcle motcle, int weight) {
        this.parameters.junctionParseEngine.getMainChange().addTie(motcle, this.parameters.getMode(), weight);
    }

    public void appendTie(Motcle motcle, int weight) {
        this.parameters.junctionParseEngine.getAppendChange().addTie(motcle, this.parameters.getMode(), weight);
    }

    public Motcle getMotcle(Thesaurus otherThesaurus, CleanedString labelText) {
        if (labelText == null) {
            return null;
        }
        Lang lang = ThesaurusUtils.checkDisponibility(this.parseContext.getThesaurusLangChecker(), otherThesaurus, this.parameters.getLang());
        return otherThesaurus.seekMotcleByLabel(labelText.toString(), lang);
    }

    public static class Parameters {
        private final ParseContext parseContext;
        private final JunctionParseEngine junctionParseEngine;
        private final Thesaurus mainThesaurus;
        private final IncludeKey includeKey;
        private final Lang lang;

        public Parameters(ParseContext parseContext, JunctionParseEngine junctionParseEngine, Thesaurus mainThesaurus, IncludeKey includeKey, Lang lang) {
            this.parseContext = parseContext;
            this.junctionParseEngine = junctionParseEngine;
            this.mainThesaurus = mainThesaurus;
            this.includeKey = includeKey;
            this.lang = lang;
        }

        public ParseContext getParseContext() {
            return this.parseContext;
        }

        public JunctionParseEngine getJunctionParseEngine() {
            return this.junctionParseEngine;
        }

        public Thesaurus getMainThesaurus() {
            return this.mainThesaurus;
        }

        public IncludeKey getIncludeKey() {
            return this.includeKey;
        }

        public String getMode() {
            return this.includeKey.getMode();
        }

        public Lang getLang() {
            return this.lang;
        }
    }
}

