/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.eligibility;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.addenda.Addenda;
import net.fichotheque.album.Album;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.Fiches;
import net.fichotheque.eligibility.SubsetEligibility;
import net.fichotheque.junction.Junctions;
import net.fichotheque.utils.EligibilityUtils;
import net.fichotheque.utils.FichothequeUtils;

public class SelectionSubsetEligibility
implements SubsetEligibility {
    private final Map<SubsetKey, InternalPredicate> subsetKeyMap = new HashMap<SubsetKey, InternalPredicate>();

    private SelectionSubsetEligibility() {
    }

    public static SubsetEligibility build(Fichotheque fichotheque, Fiches fiches) {
        int i;
        SelectionSubsetEligibility result = new SelectionSubsetEligibility();
        Addenda[] addendaArray = FichothequeUtils.toAddendaArray(fichotheque);
        int addendaCount = addendaArray.length;
        InternalPredicate[] addendaEligibilityArray = new InternalPredicate[addendaCount];
        for (int i2 = 0; i2 < addendaCount; ++i2) {
            addendaEligibilityArray[i2] = new InternalPredicate(addendaArray[i2].getSubsetKey());
        }
        Album[] albumArray = FichothequeUtils.toAlbumArray(fichotheque);
        int albumCount = albumArray.length;
        InternalPredicate[] albumEligibilityArray = new InternalPredicate[albumCount];
        for (int i3 = 0; i3 < albumCount; ++i3) {
            albumEligibilityArray[i3] = new InternalPredicate(albumArray[i3].getSubsetKey());
        }
        for (Fiches.Entry entry : fiches.getEntryList()) {
            Corpus corpus = entry.getCorpus();
            InternalPredicate ficheEligibility = new InternalPredicate(corpus.getSubsetKey());
            for (FicheMeta ficheMeta : entry.getFicheMetaList()) {
                InternalPredicate subsetItemEligibility;
                Junctions junctions;
                int k;
                ficheEligibility.add(ficheMeta.getId());
                for (k = 0; k < addendaCount; ++k) {
                    junctions = fichotheque.getJunctions(ficheMeta, addendaArray[k]);
                    if (junctions.isEmpty()) continue;
                    subsetItemEligibility = addendaEligibilityArray[k];
                    for (Junctions.Entry junctionEntry : junctions.getEntryList()) {
                        subsetItemEligibility.add(junctionEntry.getSubsetItem().getId());
                    }
                }
                for (k = 0; k < albumCount; ++k) {
                    junctions = fichotheque.getJunctions(ficheMeta, albumArray[k]);
                    if (junctions.isEmpty()) continue;
                    subsetItemEligibility = albumEligibilityArray[k];
                    for (Junctions.Entry junctionEntry : junctions.getEntryList()) {
                        subsetItemEligibility.add(junctionEntry.getSubsetItem().getId());
                    }
                }
            }
            result.addEligibility(ficheEligibility);
        }
        for (i = 0; i < addendaCount; ++i) {
            result.addEligibility(addendaEligibilityArray[i]);
        }
        for (i = 0; i < albumCount; ++i) {
            result.addEligibility(albumEligibilityArray[i]);
        }
        return result;
    }

    private void addEligibility(InternalPredicate subsetItemEligibility) {
        if (subsetItemEligibility.size() > 0) {
            this.subsetKeyMap.put(subsetItemEligibility.subsetKey, subsetItemEligibility);
        }
    }

    @Override
    public boolean accept(SubsetKey subsetKey) {
        switch (subsetKey.getCategory()) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return this.subsetKeyMap.containsKey(subsetKey);
    }

    @Override
    public Predicate<SubsetItem> getPredicate(Subset subset) {
        SubsetKey subsetKey = subset.getSubsetKey();
        switch (subsetKey.getCategory()) {
            case 2: 
            case 3: {
                return EligibilityUtils.ALL_SUBSETITEM_PREDICATE;
            }
        }
        InternalPredicate predicate = this.subsetKeyMap.get(subsetKey);
        if (predicate == null) {
            return EligibilityUtils.NONE_SUBSETITEM_PREDICATE;
        }
        return predicate;
    }

    private static class InternalPredicate
    implements Predicate<SubsetItem> {
        private final SubsetKey subsetKey;
        private final Set<Integer> idSet = new HashSet<Integer>();

        private InternalPredicate(SubsetKey subsetKey) {
            this.subsetKey = subsetKey;
        }

        @Override
        public boolean test(SubsetItem subsetItem) {
            return this.idSet.contains(subsetItem.getId());
        }

        private void add(int id) {
            this.idSet.add(id);
        }

        private int size() {
            return this.idSet.size();
        }
    }
}

