/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.ficheform.builders;

import fr.exemole.bdfserver.api.ficheform.FicheFormParameters;
import fr.exemole.bdfserver.api.ficheform.include.AddendaEntry;
import fr.exemole.bdfserver.api.ficheform.include.SubsetItemState;
import fr.exemole.bdfserver.api.ui.SubsetIncludeUi;
import fr.exemole.bdfserver.tools.L10nUtils;
import fr.exemole.bdfserver.tools.ficheform.FicheFormUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.fichotheque.SubsetKey;
import net.fichotheque.addenda.Addenda;
import net.fichotheque.include.ExtendedIncludeKey;
import net.fichotheque.junction.Liaison;
import net.fichotheque.pointeurs.FichePointeur;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.attr.Attributes;

public class AddendaEntryBuilder {
    private final String name;
    private final Addenda addenda;
    private String label = "";
    private boolean mandatory = false;
    private boolean addAllowed = false;
    private final List<SubsetItemState> stateList = new ArrayList<SubsetItemState>();
    private Attributes attributes = AttributeUtils.EMPTY_ATTRIBUTES;

    public AddendaEntryBuilder(String name, Addenda addenda) {
        this.name = name;
        this.addenda = addenda;
    }

    public AddendaEntryBuilder setLabel(String label) {
        if (label == null) {
            throw new IllegalArgumentException("label is null");
        }
        this.label = label;
        return this;
    }

    public AddendaEntryBuilder setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
        return this;
    }

    public AddendaEntryBuilder addSubsetItemState(SubsetItemState subsetItemState) {
        this.stateList.add(subsetItemState);
        return this;
    }

    public AddendaEntryBuilder setAttributes(Attributes attributes) {
        this.attributes = attributes == null ? AttributeUtils.EMPTY_ATTRIBUTES : attributes;
        return this;
    }

    public AddendaEntryBuilder setAddAllowed(boolean addAllowed) {
        this.addAllowed = addAllowed;
        return this;
    }

    public AddendaEntry toAddendaEntry() {
        List<SubsetItemState> finalList = FicheFormUtils.wrap(this.stateList.toArray(new SubsetItemState[this.stateList.size()]));
        return new InternalAddendaEntry(this.name, this.addenda, this.label, this.mandatory, this.attributes, finalList, this.addAllowed);
    }

    @Nullable
    public static AddendaEntryBuilder check(FichePointeur fichePointeur, FicheFormParameters ficheFormParameters, SubsetIncludeUi includeUi, boolean toAdd) {
        ExtendedIncludeKey includeKey = includeUi.getExtendedIncludeKey();
        SubsetKey addendaKey = includeKey.getSubsetKey();
        Addenda addenda = (Addenda)ficheFormParameters.getBdfServer().getFichotheque().getSubset(addendaKey);
        if (addenda == null) {
            return null;
        }
        boolean addAllowed = ficheFormParameters.getPermissionSummary().isSubsetAdmin(addendaKey);
        Collection<Liaison> liaisons = fichePointeur.getLiaisons(addenda, includeKey);
        if (liaisons.isEmpty() && includeUi.isObsolete()) {
            return null;
        }
        AddendaEntryBuilder builder = AddendaEntryBuilder.init(includeUi.getName(), addenda).setLabel(L10nUtils.toLabelString(ficheFormParameters, includeUi)).setAddAllowed(addAllowed).setAttributes(includeUi.getAttributes());
        for (Liaison liaison : liaisons) {
            builder.addSubsetItemState(FicheFormUtils.toSubsetItemState(liaison.getSubsetItem(), toAdd));
        }
        return builder;
    }

    public static AddendaEntryBuilder init(String name, Addenda addenda) {
        return new AddendaEntryBuilder(name, addenda);
    }

    private static class InternalAddendaEntry
    implements AddendaEntry {
        private final String name;
        private final Addenda addenda;
        private final String label;
        private final boolean mandatory;
        private final boolean addAllowed;
        private final Attributes attributes;
        private final List<SubsetItemState> documentList;

        private InternalAddendaEntry(String name, Addenda addenda, String label, boolean mandatory, Attributes attributes, List<SubsetItemState> documentList, boolean addAllowed) {
            this.name = name;
            this.addenda = addenda;
            this.label = label;
            this.mandatory = mandatory;
            this.attributes = attributes;
            this.documentList = documentList;
            this.addAllowed = addAllowed;
        }

        @Override
        public String getIncludeName() {
            return this.name;
        }

        @Override
        public Addenda getAddenda() {
            return this.addenda;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public boolean isMandatory() {
            return this.mandatory;
        }

        @Override
        public Attributes getAttributes() {
            return this.attributes;
        }

        @Override
        public boolean isAddAllowed() {
            return this.addAllowed;
        }

        @Override
        public List<SubsetItemState> getDocumentList() {
            return this.documentList;
        }
    }
}

