/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.storage.directory.oldversions;

import java.text.ParseException;
import net.fichotheque.ExistingIdException;
import net.fichotheque.Metadata;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.SphereEditor;
import net.fichotheque.sphere.metadata.SphereMetadataEditor;
import net.fichotheque.tools.dom.FichothequeDOMUtils;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.attr.AttributesBuilder;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.models.EmailCore;
import net.mapeadores.util.models.EmailCoreUtils;
import net.mapeadores.util.models.PersonCore;
import net.mapeadores.util.models.PersonCoreUtils;
import net.mapeadores.util.xml.DomMessages;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SphereDOMReader {
    private final SphereEditor sphereEditor;
    private final SphereMetadataEditor sphereMetadataEditor;
    private final MessageHandler messageHandler;

    public SphereDOMReader(SphereEditor sphereEditor, MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
        this.sphereEditor = sphereEditor;
        this.sphereMetadataEditor = sphereEditor.getSphereMetadataEditor();
    }

    public void fillSphere(Element element_xml) {
        boolean metadone = false;
        NodeList liste = element_xml.getChildNodes();
        for (int i = 0; i < liste.getLength(); ++i) {
            if (liste.item(i).getNodeType() != 1) continue;
            Element element = (Element)liste.item(i);
            String tagname = element.getTagName();
            if (!metadone && tagname.equals("metadata")) {
                metadone = true;
                this.fillMetadata(element);
                continue;
            }
            if (tagname.equals("redacteur")) {
                String login = element.getAttribute("idsphere");
                try {
                    Redacteur redacteur = this.sphereEditor.createRedacteur(-1, login);
                    String actifString = element.getAttribute("actif");
                    if (actifString.equals("0")) {
                        this.sphereEditor.setStatus(redacteur, "inactive");
                    }
                    NodeList listered = element.getChildNodes();
                    for (int j = 0; j < listered.getLength(); ++j) {
                        if (listered.item(j).getNodeType() != 1) continue;
                        Element elementred = (Element)listered.item(j);
                        String tagnamered = elementred.getTagName();
                        if (tagnamered.equals("personne-core") || tagnamered.equals("personne-bean")) {
                            PersonCore personCore = SphereDOMReader.toPersonCore(elementred);
                            this.sphereEditor.setPerson(redacteur, personCore);
                            continue;
                        }
                        if (tagnamered.equals("courriel-core") || tagnamered.equals("courriel-bean")) {
                            EmailCore emailCore = null;
                            try {
                                emailCore = SphereDOMReader.toEmailCore(elementred);
                            }
                            catch (ParseException iae) {
                                DomMessages.wrongAttributeValue(this.messageHandler, tagnamered, "addr-spec", elementred.getAttribute("addr-spec"));
                            }
                            this.sphereEditor.setEmail(redacteur, emailCore);
                            continue;
                        }
                        DomMessages.unknownTagWarning(this.messageHandler, tagname);
                    }
                    continue;
                }
                catch (ParseException pe) {
                    DomMessages.wrongAttributeValue(this.messageHandler, tagname, "idsphere", login);
                    continue;
                }
                catch (ExistingIdException eie) {
                    this.messageHandler.addMessage("severe.fichotheque", "_ error.existing.login", login);
                    continue;
                }
            }
            DomMessages.unknownTagWarning(this.messageHandler, tagname);
        }
    }

    private void fillMetadata(Element element_xml) {
        Metadata metadata = this.sphereMetadataEditor.getMetadata();
        AttributesBuilder attributesBuilder = new AttributesBuilder();
        NodeList liste = element_xml.getChildNodes();
        for (int i = 0; i < liste.getLength(); ++i) {
            Node nd = liste.item(i);
            if (nd.getNodeType() != 1) continue;
            Element el = (Element)nd;
            String tagname = el.getTagName();
            if (tagname.equals("intitule")) {
                FichothequeDOMUtils.readIntitule(el, this.sphereMetadataEditor, this.messageHandler, "sphere");
                continue;
            }
            if (tagname.equals("attr")) {
                AttributeUtils.readAttrElement(attributesBuilder, el, this.messageHandler, tagname);
                continue;
            }
            DomMessages.unknownTagWarning(this.messageHandler, tagname);
        }
        this.sphereEditor.getFichothequeEditor().putAttributes(metadata, attributesBuilder.toAttributes());
    }

    private static PersonCore toPersonCore(Element element) {
        String strg_style;
        String surname = element.getAttribute("nom");
        String forename = element.getAttribute("prenom");
        String nonlatin = element.getAttribute("original");
        boolean surnameFirst = false;
        String surnameFirstString = element.getAttribute("nom-avant");
        if (surnameFirstString.equals("true")) {
            surnameFirst = true;
        }
        if ((strg_style = element.getAttribute("style")).length() > 0) {
            surnameFirst = true;
        }
        return PersonCoreUtils.toPersonCore(surname, forename, nonlatin, surnameFirst);
    }

    private static EmailCore toEmailCore(Element element) throws ParseException {
        String addrSpec = element.getAttribute("addr-spec");
        String realName = element.getAttribute("real-name");
        if (realName.length() == 0) {
            realName = element.getAttribute("nom-complet");
        }
        return EmailCoreUtils.parse(addrSpec, realName);
    }
}

