/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.storage.directory.bdfdata;

import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.storage.directory.StorageDirectory;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.SubsetKey;
import net.fichotheque.addenda.VersionInfo;
import net.fichotheque.utils.AddendaUtils;
import net.mapeadores.util.io.FileUtils;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.text.StringUtils;

public class DocumentDirectory {
    private final int id;
    private final File dir;

    private DocumentDirectory(File dir, int id) {
        this.dir = dir;
        this.id = id;
    }

    public InputStream getInputStream(String extension) {
        File f = this.getFile(extension);
        if (!f.exists()) {
            return null;
        }
        try {
            return new FileInputStream(f);
        }
        catch (IOException ioe) {
            throw new BdfStorageException("file : " + f.getAbsolutePath(), (Throwable)ioe);
        }
    }

    public boolean linkTo(String extension, Path destination, boolean symbolicLink) throws IOException {
        File f = this.getFile(extension);
        if (!f.exists()) {
            return false;
        }
        Path source = f.toPath();
        if (symbolicLink) {
            Files.createSymbolicLink(destination, source, new FileAttribute[0]);
        } else {
            Files.createLink(destination, source);
        }
        return true;
    }

    public VersionInfo saveInputStream(String extension, InputStream inputStream) {
        if (!AddendaUtils.testExtension(extension)) {
            throw new IllegalArgumentException("wrong extension value = " + extension);
        }
        File f = this.getFile(extension);
        if (!this.dir.exists()) {
            this.dir.mkdirs();
        }
        try (FileOutputStream os = new FileOutputStream(f);){
            IOUtils.copy(inputStream, (OutputStream)os);
        }
        catch (IOException ioe) {
            throw new BdfStorageException("file : " + f.getAbsolutePath(), (Throwable)ioe);
        }
        try {
            return new VersionInfo(extension, f.length(), StringUtils.getMD5Checksum(f));
        }
        catch (IOException ioe) {
            throw new BdfStorageException("file : " + f.getAbsolutePath(), (Throwable)ioe);
        }
    }

    public boolean delete() {
        try {
            if (this.dir.exists()) {
                FileUtils.forceDelete(this.dir);
                return true;
            }
            return false;
        }
        catch (IOException ioe) {
            throw new BdfStorageException(ioe);
        }
    }

    public boolean delete(String extension) {
        File f = this.getFile(extension);
        if (!f.exists()) {
            return false;
        }
        return f.delete();
    }

    public static DocumentDirectory getDocumentDirectory(StorageDirectory bdfdataDirectory, SubsetKey subsetKey, int id) {
        File docDir = bdfdataDirectory.getDataFile(DocumentDirectory.getPath(subsetKey, id));
        DocumentDirectory documentDirectory = new DocumentDirectory(docDir, id);
        return documentDirectory;
    }

    public DocumentInfo getDocumentInfo() {
        ArrayList<VersionInfo> versionInfoList = new ArrayList<VersionInfo>();
        String prefix = "doc.";
        int prefixLength = prefix.length();
        for (File f : this.dir.listFiles()) {
            String extension;
            String name;
            if (f.isDirectory() || (name = f.getName()).length() <= prefixLength || !name.startsWith(prefix) || !AddendaUtils.testExtension(extension = name.substring(prefixLength))) continue;
            try {
                versionInfoList.add(new VersionInfo(extension, f.length(), StringUtils.getMD5Checksum(f)));
            }
            catch (IOException ioe) {
                throw new BdfStorageException("file : " + f.getAbsolutePath(), (Throwable)ioe);
            }
        }
        return new DocumentInfo(this.id, versionInfoList);
    }

    public static String getPath(SubsetKey subsetKey, int id) {
        StringBuilder buf = new StringBuilder();
        buf.append("fichotheque");
        buf.append(File.separatorChar);
        buf.append("addenda");
        buf.append(File.separatorChar);
        buf.append(subsetKey.getSubsetName());
        buf.append(File.separatorChar);
        buf.append("d.");
        buf.append(BdfServerUtils.getMillier(id));
        buf.append(File.separatorChar);
        buf.append(id);
        return buf.toString();
    }

    public static List<DocumentInfo> getDocumentInfoList(StorageDirectory bdfdataDirectory, SubsetKey addendaKey) {
        ArrayList<DocumentInfo> list = new ArrayList<DocumentInfo>();
        File documentsDirectory = bdfdataDirectory.getDataFile("fichotheque" + File.separator + "addenda" + File.separator + addendaKey.getSubsetName());
        if (!documentsDirectory.exists() || !documentsDirectory.isDirectory()) {
            return list;
        }
        for (File directory : documentsDirectory.listFiles()) {
            String name;
            if (!directory.isDirectory() || (name = directory.getName()).length() < 2 || !name.startsWith("d.")) continue;
            try {
                int directoryNumber = Integer.parseInt(name.substring(2));
                DocumentDirectory.addDocumentInfo(list, directory, directoryNumber);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return list;
    }

    private static void addDocumentInfo(List<DocumentInfo> list, File intervalDirectory, int directoryNumber) {
        for (File docDir : intervalDirectory.listFiles()) {
            if (!docDir.isDirectory()) continue;
            String name = docDir.getName();
            String errorMessage = null;
            try {
                int documentid = Integer.parseInt(name);
                if (documentid < 1) {
                    errorMessage = "documentid < 1 (directoryNumber = " + directoryNumber;
                } else if (documentid < 1000 && directoryNumber != 0 || documentid / 1000 != directoryNumber) {
                    errorMessage = "Wrong range : documentid = " + documentid + " / directoryNumber = " + directoryNumber;
                } else {
                    list.add(new DocumentDirectory(docDir, documentid).getDocumentInfo());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (errorMessage == null) continue;
            System.out.println(errorMessage);
        }
    }

    private File getFile(String extension) {
        return new File(this.dir, "doc." + extension);
    }

    public static class DocumentInfo {
        private final int id;
        private final List<VersionInfo> versionInfoList;

        private DocumentInfo(int id, List<VersionInfo> versionInfoList) {
            this.id = id;
            this.versionInfoList = versionInfoList;
        }

        public int getId() {
            return this.id;
        }

        public List<VersionInfo> getVersionInfoList() {
            return this.versionInfoList;
        }
    }
}

