/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi.commands.personmanager;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.multi.api.Multi;
import fr.exemole.bdfserver.multi.commands.AbstractMultiCommand;
import java.text.ParseException;
import net.fichotheque.SubsetKey;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.Sphere;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public abstract class AbstractPersonMultiCommand
extends AbstractMultiCommand {
    public static final String SPHERE_PARAMNAME = "sphere";
    public static final String LOGIN_PARAMNAME = "login";
    public static final String COPYORIGIN_PARAMNAME = "copyorigin";
    protected SubsetKey sphereKey;
    protected String login;

    public AbstractPersonMultiCommand(Multi multi, RequestMap requestMap) {
        super(multi, requestMap);
    }

    public void initPersonParameters() throws ErrorMessageException {
        if (!this.multi.isPersonManagementAllowed()) {
            throw new ErrorMessageException("_ error.unsupported.personmanagementnotallowed");
        }
        String sphereName = this.getMandatory(SPHERE_PARAMNAME);
        this.login = this.getMandatory(LOGIN_PARAMNAME);
        try {
            this.sphereKey = SubsetKey.parse((short)3, sphereName.trim());
        }
        catch (ParseException pe) {
            throw new ErrorMessageException("_ error.unknown.sphere", sphereName);
        }
    }

    public CopyOrigin getCopyOrigin() throws ErrorMessageException {
        String copyOrigin = this.getMandatory(COPYORIGIN_PARAMNAME);
        if (!this.multi.isInit(copyOrigin)) {
            throw new ErrorMessageException("_ error.unknown.parametervalue", COPYORIGIN_PARAMNAME, copyOrigin);
        }
        BdfServer bdfServer = this.multi.getBdfServer(copyOrigin);
        Sphere sphere = (Sphere)bdfServer.getFichotheque().getSubset(this.sphereKey);
        if (sphere != null) {
            Redacteur redacteur = sphere.getRedacteurByLogin(this.login);
            if (redacteur != null) {
                return new CopyOrigin(bdfServer, redacteur);
            }
            throw new ErrorMessageException("_ error.unknown.parametervalue", COPYORIGIN_PARAMNAME, copyOrigin);
        }
        throw new ErrorMessageException("_ error.unknown.sphere", this.sphereKey.getSubsetName());
    }

    public static class CopyOrigin {
        private final BdfServer originBdfServer;
        private final Redacteur redacteur;
        private final String encryptedPassword;

        private CopyOrigin(BdfServer originBdfServer, Redacteur redacteur) {
            this.originBdfServer = originBdfServer;
            this.redacteur = redacteur;
            this.encryptedPassword = originBdfServer.getPasswordManager().getEncryptedPassword(redacteur.getGlobalId());
        }

        public String getOriginName() {
            return this.originBdfServer.getName();
        }

        public BdfServer getOriginBdfServer() {
            return this.originBdfServer;
        }

        public Redacteur getRedacteur() {
            return this.redacteur;
        }

        public String getEncryptedPassword() {
            return this.encryptedPassword;
        }
    }
}

