/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.pioche;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.jslib.GeoJsLibs;
import fr.exemole.bdfserver.htmlproducers.pioche.PiocheParameters;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.JsObject;
import net.mapeadores.util.primitives.DegreDecimal;
import net.mapeadores.util.text.StringUtils;

public class GeocodageHtmlProducer
extends BdfServerHtmlProducer {
    private static final String[] EMPTY_ARRAY = new String[0];
    private final PiocheParameters piocheParameters;
    private final DegreDecimal latDecimal;
    private final DegreDecimal lonDecimal;
    private final String callKey;
    private final String[] addressArray;

    public GeocodageHtmlProducer(BdfParameters bdfParameters, PiocheParameters piocheParameters) {
        super(bdfParameters);
        this.piocheParameters = piocheParameters;
        this.callKey = piocheParameters.getCallKey();
        this.latDecimal = (DegreDecimal)piocheParameters.getParameter("lat");
        this.lonDecimal = (DegreDecimal)piocheParameters.getParameter("lon");
        String adressFields = (String)piocheParameters.getParameter("addressfields");
        this.addressArray = adressFields != null ? StringUtils.getTechnicalTokens(adressFields, true) : EMPTY_ARRAY;
        this.addThemeCss("geocodage.css");
        this.addJsLib(GeoJsLibs.PIOCHE);
    }

    @Override
    public void printHtml() {
        String longitudeId;
        String latitudeId;
        int idx = this.callKey.indexOf(44);
        if (idx > 0) {
            latitudeId = this.callKey.substring(0, idx);
            longitudeId = this.callKey.substring(idx + 1);
        } else {
            latitudeId = this.callKey;
            longitudeId = "";
        }
        String clientId = this.generateId();
        JsObject piocheArgs = JsObject.init().put("clientId", clientId).put("latitudeId", latitudeId).put("longitudeId", longitudeId).put("addressArray", this.addressArray);
        if (this.latDecimal != null && this.lonDecimal != null) {
            piocheArgs.put("start", this.getStartObject());
        }
        this.startLoc("_ title.pioche.geocodage");
        this.SCRIPT().__jsObject("Geo.Geocodage.ARGS", piocheArgs)._SCRIPT();
        this.DIV(HA.id(clientId).classes("geocodage-Client"))._DIV();
        this.end();
    }

    private JsObject getStartObject() {
        Boolean noCurrent;
        JsObject startObject = JsObject.init().put("latitude", this.latDecimal.toString()).put("longitude", this.lonDecimal.toString());
        String zoom = (String)this.piocheParameters.getParameter("zoom");
        if (zoom != null) {
            try {
                int zoomInt = Integer.parseInt(zoom);
                if (zoomInt > 0) {
                    startObject.put("zoom", zoomInt);
                }
            }
            catch (NumberFormatException zoomInt) {
                // empty catch block
            }
        }
        if ((noCurrent = (Boolean)this.piocheParameters.getParameter("nocurrent")) != null) {
            startObject.put("noCurrent", noCurrent);
        }
        return startObject;
    }
}

