/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.edition;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.EditionEngine;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfInstructionUtils;
import fr.exemole.bdfserver.tools.instruction.PermissionChecker;
import net.fichotheque.ExistingIdException;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.CorpusEditor;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.NoMasterIdException;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.mapeadores.util.date.FuzzyDate;
import net.mapeadores.util.exceptions.ImplementationException;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class FicheChangeCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "FicheChange";
    private Corpus corpus;
    private int id;
    private FicheMeta ficheMeta;

    public FicheChangeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = this.startEditSession("edition", COMMANDNAME);){
            CorpusEditor corpusEditor = session.getFichothequeEditor().getCorpusEditor(this.corpus);
            if (this.ficheMeta == null) {
                try {
                    this.ficheMeta = corpusEditor.createFiche(this.id);
                }
                catch (ExistingIdException eii) {
                    throw new ImplementationException(eii);
                }
                catch (NoMasterIdException nmie) {
                    throw new ShouldNotOccurException(nmie);
                }
                corpusEditor.setDate(this.ficheMeta, FuzzyDate.current(), false);
            }
            EditionEngine.update(session, this.requestHandler, this.requestHandler.getRequestMap(), this.ficheMeta);
        }
        this.putResultObject("obj.corpus", this.corpus);
        this.putResultObject("obj.fichemeta", this.ficheMeta);
        this.setDone("_ done.edition.fichechange", CorpusMetadataUtils.getFicheTitle(this.ficheMeta, this.bdfUser.getWorkingLang(), this.bdfUser.getFormatLocale()));
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.corpus = this.requestHandler.getMandatoryCorpus();
        this.id = this.requestHandler.getMandatoryId();
        this.ficheMeta = this.corpus.getFicheMetaById(this.id);
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (this.ficheMeta == null) {
            BdfInstructionUtils.checkMasterSubsetItem(this.corpus, this.id, this.bdfUser);
            permissionChecker.checkFicheCreate(this.corpus);
        } else {
            permissionChecker.checkWrite(this.ficheMeta);
        }
    }
}

