/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.configuration;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.policies.UserAllow;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.policies.UserAllowBuilder;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class UserAllowChangeCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "UserAllowChange";
    public static final String COMMANDKEY = "_ CNF-05";
    public static final String DATA_PARAMNAME = "data";
    public static final String PASSWORD_PARAMNAME = "password";
    private boolean allowData = false;
    private boolean allowPassword = false;

    public UserAllowChangeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        boolean done;
        UserAllow userAllow = UserAllowBuilder.init().setDataChangeAllowed(this.allowData).setPasswordChangeAllowed(this.allowPassword).toUserAllow();
        try (EditSession session = this.startEditSession("configuration", COMMANDNAME);){
            done = session.getBdfServerEditor().setUserAllow(userAllow);
        }
        if (done) {
            this.setDone("_ done.configuration.userallowchange", new Object[0]);
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        this.allowData = this.requestHandler.isTrue(DATA_PARAMNAME);
        this.allowPassword = this.requestHandler.isTrue(PASSWORD_PARAMNAME);
    }
}

