/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.configuration;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.metadata.FichothequeMetadataEditor;
import net.mapeadores.util.logging.CommandMessageBuilder;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;

public class IdentificationCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "Identification";
    public static final String COMMANDKEY = "_ CNF-01";
    public static final String AUTHORITY_PARAMNAME = "authority";
    public static final String BASENAME_PARAMNAME = "basename";
    private String baseName;
    private String authority;

    public IdentificationCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        boolean done;
        try (EditSession session = this.startEditSession("configuration", COMMANDNAME);){
            FichothequeMetadataEditor fichothequeMetadataEditor = session.getFichothequeEditor().getFichothequeMetadataEditor();
            boolean done1 = fichothequeMetadataEditor.setAuthority(this.authority);
            boolean done2 = fichothequeMetadataEditor.setBaseName(this.baseName);
            done = done1 || done2;
        }
        if (done) {
            this.setDone("_ done.configuration.identification", new Object[0]);
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        this.baseName = this.getMandatory(BASENAME_PARAMNAME);
        this.authority = this.getMandatory(AUTHORITY_PARAMNAME);
        CommandMessageBuilder commandMessageBuilder = CommandMessageBuilder.init();
        if (!StringUtils.isTechnicalName(this.baseName, true)) {
            commandMessageBuilder.addMultiError("_ error.wrong.basename_fichotheque", this.baseName);
        }
        if (!StringUtils.isAuthority(this.authority)) {
            commandMessageBuilder.addMultiError("_ error.wrong.authority", this.authority);
        }
        if (commandMessageBuilder.hasMultiError()) {
            throw BdfErrors.error(commandMessageBuilder, "_ error.list.configuration");
        }
    }
}

