/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.album;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import net.fichotheque.album.Illustration;
import net.fichotheque.junction.JunctionChanges;
import net.fichotheque.tools.junction.JunctionChangeEngine;
import net.fichotheque.tools.junction.TieBuffer;
import net.fichotheque.tools.parsers.junction.TieBufferParser;
import net.fichotheque.tools.permission.PermissionPredicate;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;

public class JunctionAddCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "JunctionAdd";
    public static final String COMMANDKEY = "_ ALB-14";
    public static final String ADD_PARAMNAME = "add";
    private Illustration illustration;
    private JunctionChanges junctionChanges;

    public JunctionAddCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = this.startEditSession("album", COMMANDNAME);){
            session.getFichothequeEditor().getJunctionEditor().updateJunctions(this.illustration, this.junctionChanges);
        }
        this.putResultObject("obj.album", this.illustration.getAlbum());
        this.putResultObject("obj.illustration", this.illustration);
        this.setDone("_ done.album.junctionadd", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.illustration = this.requestHandler.getMandatoryIllustration();
        this.getPermissionChecker().checkWrite(this.illustration);
        PermissionPredicate predicate = PermissionPredicate.read(this.requestHandler.getPermissionSummary());
        String addString = this.getMandatory(ADD_PARAMNAME);
        String[] tokens = StringUtils.getTechnicalTokens(addString, false);
        JunctionChangeEngine junctionChangeEngine = JunctionChangeEngine.appendEngine(this.illustration);
        boolean done = false;
        for (String token : tokens) {
            try {
                TieBuffer tieBuffer = TieBufferParser.parse(this.bdfServer.getFichothequeQuestioner(), token, (short)1);
                if (!predicate.test(tieBuffer.getSubsetItem())) continue;
                junctionChangeEngine.addTie(tieBuffer);
                done = true;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (!done) {
            throw BdfErrors.error("_ error.wrong.fichekeys");
        }
        this.junctionChanges = junctionChangeEngine.toJunctionChanges();
    }
}

