/*
 * Decompiled with CFR 0.152.
 */
package net.scrutari.dataexport.xml;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.scrutari.dataexport.api.BaseMetadataExport;
import net.scrutari.dataexport.xml.XmlMetadataExport;
import net.scrutari.dataexport.xml.XmlWriter;

public class XmlBaseMetadataExport
extends XmlMetadataExport
implements BaseMetadataExport {
    private final List<String> langUIList = new ArrayList<String>();
    private final Map<String, String> shortMap = new LinkedHashMap<String, String>();
    private final Map<String, String> longMap = new LinkedHashMap<String, String>();
    private String authority;
    private String baseName;
    private String baseIcon;

    @Override
    public void setAuthority(String authority) {
        this.authority = authority;
    }

    @Override
    public void setBaseName(String baseName) {
        this.baseName = baseName;
    }

    @Override
    public void setBaseIcon(String baseIcon) {
        this.baseIcon = baseIcon;
    }

    @Override
    public void setIntitule(int intituleType, String lang, String intituleValue) {
        Map<String, String> map = this.getMap(intituleType);
        map.put(lang, intituleValue);
    }

    @Override
    public void addLangUI(String lang) {
        this.langUIList.add(lang);
    }

    @Override
    public void writeXML(XmlWriter xmlWriter) {
        xmlWriter.openTag("base-metadata");
        xmlWriter.addSimpleElement("authority", this.authority);
        xmlWriter.addSimpleElement("base-name", this.baseName);
        xmlWriter.addSimpleElement("base-icon", this.baseIcon);
        this.addMap(1, xmlWriter);
        this.addMap(2, xmlWriter);
        int size = this.langUIList.size();
        if (size > 0) {
            xmlWriter.openTag("langs-ui");
            for (int i = 0; i < size; ++i) {
                xmlWriter.addSimpleElement("lang", this.langUIList.get(i));
            }
            xmlWriter.closeTag("langs-ui");
        }
        this.writePhrases(xmlWriter);
        this.writeAttributes(xmlWriter);
        xmlWriter.closeTag("base-metadata");
    }

    private void addMap(int intituleType, XmlWriter xmlWriter) {
        Map<String, String> map = this.getMap(intituleType);
        if (map.isEmpty()) {
            return;
        }
        String suffix = XmlBaseMetadataExport.getSuffix(intituleType);
        xmlWriter.openTag("intitule-" + suffix);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            xmlWriter.addLibElement(entry.getKey(), entry.getValue());
        }
        xmlWriter.closeTag("intitule-" + suffix);
    }

    private Map<String, String> getMap(int type) {
        switch (type) {
            case 1: {
                return this.shortMap;
            }
            case 2: {
                return this.longMap;
            }
        }
        throw new IllegalArgumentException("Wrong intituleType = " + type);
    }

    private static String getSuffix(int type) {
        switch (type) {
            case 1: {
                return "short";
            }
            case 2: {
                return "long";
            }
        }
        throw new IllegalArgumentException("Wrong intituleType = " + type);
    }
}

