/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.xml.svg;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.mapeadores.util.xml.DefaultXMLWriter;
import net.mapeadores.util.xml.XMLUtils;
import net.mapeadores.util.xml.ns.NameSpace;

public class SvgWriter
extends DefaultXMLWriter {
    private static final NameSpace DEFAULT_NAMESPACE = new NameSpace("", "http://www.w3.org/2000/svg");
    private final List<NameSpace> nameSpaceList = new ArrayList<NameSpace>();
    private final String prefix;

    public SvgWriter(boolean isDefaultNamespace) {
        this.nameSpaceList.add(NameSpace.SVG_NAMESPACE);
        if (isDefaultNamespace) {
            this.prefix = "";
            this.nameSpaceList.add(DEFAULT_NAMESPACE);
        } else {
            this.prefix = "svg:";
            this.nameSpaceList.add(NameSpace.SVG_NAMESPACE);
        }
    }

    public void addNameSpace(NameSpace nameSpace) {
        this.nameSpaceList.add(nameSpace);
    }

    public void openSvg(int width, int height) throws IOException {
        this.startOpenTag(this.prefix + "svg");
        for (NameSpace nameSpace : this.nameSpaceList) {
            XMLUtils.appendNameSpaceAttribute(this, nameSpace);
        }
        this.addWidthAttribute(width);
        this.addHeightAttribute(height);
        this.endOpenTag();
    }

    public void closeSvg() throws IOException {
        this.closeTag(this.prefix + "svg");
    }

    public void openGroup() throws IOException {
        this.openTag(this.prefix + "g");
    }

    public void closeGroup() throws IOException {
        this.closeTag(this.prefix + "g");
    }

    public void closeA() throws IOException {
        this.closeTag(this.prefix + "a");
    }

    public void closeText() throws IOException {
        this.closeTag(this.prefix + "text", false);
    }

    public void addXAttribute(int x) throws IOException {
        this.addAttribute("x", String.valueOf(x));
    }

    public void addYAttribute(int y) throws IOException {
        this.addAttribute("y", String.valueOf(y));
    }

    public void addWidthAttribute(int width) throws IOException {
        if (width >= 0) {
            this.addAttribute("width", String.valueOf(width));
        }
    }

    public void addHeightAttribute(int height) throws IOException {
        if (height >= 0) {
            this.addAttribute("height", String.valueOf(height));
        }
    }

    public void addStyleAttribute(String style) throws IOException {
        this.addAttribute("style", style);
    }

    public void addClassAttribute(String className) throws IOException {
        this.addAttribute("class", className);
    }

    public void addIdAttribute(String id) throws IOException {
        this.addAttribute("id", id);
    }

    public void addTransformAttribute(String transform) throws IOException {
        this.addAttribute("transform", transform);
    }

    public void startGroupOpenTag() throws IOException {
        this.startOpenTag(this.prefix + "g");
    }

    public void startAOpenTag(String href) throws IOException {
        this.startOpenTag(this.prefix + "a");
        this.addAttribute("xlink:href", href);
    }

    public void startLineOpenTag(int x1, int y1, int x2, int y2) throws IOException {
        this.startOpenTag(this.prefix + "line");
        this.addAttribute("x1", String.valueOf(x1));
        this.addAttribute("y1", String.valueOf(y1));
        this.addAttribute("x2", String.valueOf(x2));
        this.addAttribute("y2", String.valueOf(y2));
    }

    public void startArcPathOpenTag(int x1, int y1, int rx, int ry, int xrotate, boolean largeArcFlag, boolean sweepFlag, int x2, int y2) throws IOException {
        StringBuilder bufD = new StringBuilder();
        bufD.append("M ");
        bufD.append(x1);
        bufD.append(",");
        bufD.append(y1);
        bufD.append(" A ");
        bufD.append(rx);
        bufD.append(",");
        bufD.append(ry);
        bufD.append(" ");
        bufD.append(xrotate);
        bufD.append(" ");
        bufD.append(largeArcFlag ? 1 : 0);
        bufD.append(",");
        bufD.append(sweepFlag ? 1 : 0);
        bufD.append(" ");
        bufD.append(x2);
        bufD.append(",");
        bufD.append(y2);
        this.startOpenTag(this.prefix + "path");
        this.addAttribute("d", bufD.toString());
    }

    public void startRectOpenTag(int x, int y, int width, int height) throws IOException {
        this.startOpenTag(this.prefix + "rect");
        this.addXAttribute(x);
        this.addYAttribute(y);
        this.addWidthAttribute(width);
        this.addHeightAttribute(height);
    }

    public void startTextOpenTag(int x, int y) throws IOException {
        this.startOpenTag(this.prefix + "text");
        this.addXAttribute(x);
        this.addYAttribute(y);
    }

    public void startEllipseOpentag(int cx, int cy, int rx, int ry) throws IOException {
        this.startOpenTag(this.prefix + "ellipse");
        this.addAttribute("cx", String.valueOf(cx));
        this.addAttribute("cy", String.valueOf(cy));
        this.addAttribute("rx", String.valueOf(rx));
        this.addAttribute("ry", String.valueOf(ry));
    }

    public void startImageOpenTag(String href, int x, int y, int width, int height) throws IOException {
        this.startOpenTag(this.prefix + "image");
        this.addAttribute("xlink:href", href);
        this.addXAttribute(x);
        this.addYAttribute(y);
        this.addWidthAttribute(width);
        this.addHeightAttribute(height);
    }

    public String getRotate(int angle, int x, int y) {
        StringBuilder buf = new StringBuilder();
        buf.append("rotate(");
        buf.append(angle);
        buf.append(",");
        buf.append(x);
        buf.append(",");
        buf.append(y);
        buf.append(")");
        return buf.toString();
    }

    public String getTranslate(int x, int y) {
        StringBuilder buf = new StringBuilder();
        buf.append("translate(");
        buf.append(x);
        buf.append(",");
        buf.append(y);
        buf.append(")");
        return buf.toString();
    }
}

