/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.text.tableparser;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.NoSuchElementException;
import net.mapeadores.util.exceptions.NestedIOException;
import net.mapeadores.util.primitives.io.PrimitivesIOFactory;
import net.mapeadores.util.primitives.io.PrimitivesReader;
import net.mapeadores.util.primitives.io.PrimitivesWriter;
import net.mapeadores.util.text.tableparser.RowChecker;
import net.mapeadores.util.text.tableparser.RowHandler;
import net.mapeadores.util.text.tableparser.RowIterator;
import net.mapeadores.util.text.tableparser.RowIteratorFactory;

public class CacheRowHandler
implements RowHandler {
    private final File dataFile;
    private final OutputStream dataOutputStream;
    private final PrimitivesWriter dataPrimitivesWriter;
    private final RowChecker rowChecker;

    public CacheRowHandler(File dataFile, RowChecker rowChecker) {
        this.dataFile = dataFile;
        this.rowChecker = rowChecker;
        try {
            if (dataFile.exists()) {
                dataFile.delete();
            }
            this.dataOutputStream = new BufferedOutputStream(new FileOutputStream(dataFile));
        }
        catch (IOException ioe) {
            throw new NestedIOException(ioe);
        }
        this.dataPrimitivesWriter = PrimitivesIOFactory.newWriter(this.dataOutputStream);
    }

    @Override
    public void addRow(String[] row) {
        if (this.rowChecker != null && (row = this.rowChecker.checkRow(row)) == null) {
            return;
        }
        int length = row.length;
        try {
            this.dataPrimitivesWriter.writeInt(length);
            for (int i = 0; i < length; ++i) {
                this.dataPrimitivesWriter.writeString(row[i]);
            }
        }
        catch (IOException ioe) {
            throw new NestedIOException(ioe);
        }
    }

    public RowIteratorFactory toRowIteratorFactory() {
        try {
            this.dataOutputStream.close();
        }
        catch (IOException ioe) {
            throw new NestedIOException(ioe);
        }
        return new InternalRowIteratorFactory(this.dataFile);
    }

    private static class InternalRowIteratorFactory
    implements RowIteratorFactory {
        private final File dataFile;

        private InternalRowIteratorFactory(File dataFile) {
            this.dataFile = dataFile;
        }

        @Override
        public RowIterator newRowIterator() {
            return new InternalRowIterator(this.dataFile);
        }
    }

    private static class InternalRowIterator
    implements RowIterator {
        private final RandomAccessFile dataRandomAccessFile;
        private final PrimitivesReader dataPrimitivesReader;

        private InternalRowIterator(File dataFile) {
            try {
                this.dataRandomAccessFile = new RandomAccessFile(dataFile, "r");
                this.dataPrimitivesReader = PrimitivesIOFactory.newReader(this.dataRandomAccessFile);
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
        }

        @Override
        public boolean hasNext() {
            try {
                return this.dataRandomAccessFile.getFilePointer() < this.dataRandomAccessFile.length();
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
        }

        @Override
        public String[] next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                int length = this.dataPrimitivesReader.readInt();
                String[] result = new String[length];
                for (int i = 0; i < length; ++i) {
                    result[i] = this.dataPrimitivesReader.readString();
                }
                return result;
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
        }

        @Override
        public void close() {
            try {
                this.dataRandomAccessFile.close();
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
        }
    }
}

