/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.text.collation.map;

import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.mapeadores.util.text.LevenshteinDistance;
import net.mapeadores.util.text.OneDistance;
import net.mapeadores.util.text.SubstringPosition;
import net.mapeadores.util.text.collation.CollationUnit;
import net.mapeadores.util.text.collation.map.CollatedKeyMap;
import net.mapeadores.util.text.collation.map.CollationMapUtils;
import net.mapeadores.util.text.collation.map.SearchResultUnit;
import net.mapeadores.util.text.collation.map.ValueFilter;

public class SortedCollatedKeyMap<E>
implements CollatedKeyMap<E> {
    private final RuleBasedCollator collator;
    private final Locale locale;
    private final SortedMap<String, E> valuesMap = new TreeMap<String, E>();

    public SortedCollatedKeyMap(Locale locale) {
        this.locale = locale;
        this.collator = (RuleBasedCollator)Collator.getInstance(locale);
        this.collator.setStrength(0);
    }

    @Override
    public Collection<E> values() {
        return this.valuesMap.values();
    }

    @Override
    public RuleBasedCollator getCollator() {
        return this.collator;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public int size() {
        return this.valuesMap.size();
    }

    @Override
    public E getValue(String key) {
        String collatedKey = CollationUnit.collate(key, this.collator);
        return (E)this.valuesMap.get(collatedKey);
    }

    @Override
    public E getValueByCollatedKey(String collatedKey) {
        return (E)this.valuesMap.get(collatedKey);
    }

    @Override
    public void putValue(String key, E value) {
        String collatedKey = CollationUnit.collate(key, this.collator);
        this.valuesMap.put(collatedKey, value);
    }

    @Override
    public void putValueByCollatedKey(String collatedKey, E value) {
        this.valuesMap.put(collatedKey, value);
    }

    @Override
    public E removeValue(String key) {
        String collatedKey = CollationUnit.collate(key, this.collator);
        return (E)this.valuesMap.remove(collatedKey);
    }

    @Override
    public E removeValueByCollatedKey(String collatedKey) {
        return (E)this.valuesMap.remove(collatedKey);
    }

    @Override
    public List<SearchResultUnit<E>> search(String searchText, int type, ValueFilter valueFilter) {
        return this.internalSearch(searchText, type, valueFilter);
    }

    @Override
    public List<SearchResultUnit<E>> searchNeighbours(String searchText, int type, ValueFilter valueFilter, int distance) {
        if (distance < 1) {
            return this.internalSearch(searchText, type, valueFilter);
        }
        if (valueFilter == null) {
            valueFilter = CollationMapUtils.ALL_VALUEFILTER;
        }
        switch (type) {
            case 2: 
            case 3: {
                return Collections.emptyList();
            }
            case 0: {
                if (distance == 1) {
                    return this.getOneDistanceNeighboursStartingWith(searchText, valueFilter, true);
                }
                return this.getNeighboursStartingWith(searchText, valueFilter, distance, true);
            }
            case 1: {
                if (distance == 1) {
                    return this.getOneDistanceNeighboursStartingWith(searchText, valueFilter, false);
                }
                return this.getNeighboursStartingWith(searchText, valueFilter, distance, false);
            }
        }
        throw new IllegalArgumentException("unknwon TextConstants type : " + type);
    }

    @Override
    public void clear() {
        this.valuesMap.clear();
    }

    private List<SearchResultUnit<E>> internalSearch(String searchText, int type, ValueFilter valueFilter) {
        if (valueFilter == null) {
            valueFilter = CollationMapUtils.ALL_VALUEFILTER;
        }
        switch (type) {
            case 3: {
                return this.getValuesContaining(searchText, valueFilter);
            }
            case 2: {
                return this.getValuesEndingWith(searchText, valueFilter);
            }
            case 0: {
                String collatedKey = CollationUnit.collate(searchText, this.collator);
                Object value = this.valuesMap.get(collatedKey);
                if (value == null || !valueFilter.acceptValue(value)) {
                    return Collections.emptyList();
                }
                InternalSearchResultUnit unique = new InternalSearchResultUnit(value, collatedKey, new SubstringPosition(0, collatedKey.length()));
                return Collections.singletonList(unique);
            }
            case 1: {
                return this.getValuesStartingWith(searchText, valueFilter);
            }
        }
        throw new IllegalArgumentException("unknwon TextConstants type : " + type);
    }

    private List<SearchResultUnit<E>> getValuesStartingWith(String s, ValueFilter valueFilter) {
        Map.Entry<String, E> couple;
        String currentkey;
        String searchkey = CollationUnit.collate(s, this.collator);
        ArrayList searchResultItemList = new ArrayList();
        int minlength = searchkey.length();
        SortedMap<String, E> sorted = this.valuesMap.tailMap(searchkey);
        Iterator<Map.Entry<String, E>> iterator = sorted.entrySet().iterator();
        while (iterator.hasNext() && (currentkey = (couple = iterator.next()).getKey()).length() >= minlength && currentkey.startsWith(searchkey)) {
            E value = couple.getValue();
            if (!valueFilter.acceptValue(value)) continue;
            InternalSearchResultUnit searchResultItem = new InternalSearchResultUnit(value, currentkey, new SubstringPosition(0, minlength));
            searchResultItemList.add(searchResultItem);
        }
        return searchResultItemList;
    }

    private List<SearchResultUnit<E>> getValuesEndingWith(String s, ValueFilter valueFilter) {
        String searchkey = CollationUnit.collate(s, this.collator);
        ArrayList searchResultItemList = new ArrayList();
        int minlength = searchkey.length();
        for (Map.Entry<String, E> couple : this.valuesMap.entrySet()) {
            E value;
            String currentkey = couple.getKey();
            if (currentkey.length() < minlength || !currentkey.endsWith(searchkey) || !valueFilter.acceptValue(value = couple.getValue())) continue;
            InternalSearchResultUnit searchResultItem = new InternalSearchResultUnit(value, currentkey, new SubstringPosition(currentkey.length() - minlength, minlength));
            searchResultItemList.add(searchResultItem);
        }
        return searchResultItemList;
    }

    private List<SearchResultUnit<E>> getValuesContaining(String s, ValueFilter valueFilter) {
        String searchkey = CollationUnit.collate(s, this.collator);
        ArrayList searchResultItemList = new ArrayList();
        int minlength = searchkey.length();
        for (Map.Entry<String, E> couple : this.valuesMap.entrySet()) {
            E value;
            int idx;
            String currentkey = couple.getKey();
            if (currentkey.length() < minlength || (idx = currentkey.indexOf(searchkey)) == -1 || !valueFilter.acceptValue(value = couple.getValue())) continue;
            InternalSearchResultUnit searchResultItem = new InternalSearchResultUnit(couple.getValue(), currentkey, new SubstringPosition(idx, minlength));
            searchResultItemList.add(searchResultItem);
        }
        return searchResultItemList;
    }

    private List<SearchResultUnit<E>> getNeighboursStartingWith(String s, ValueFilter valueFilter, int distance, boolean matches) {
        String searchkey = CollationUnit.collate(s, this.collator);
        LevenshteinDistance levenshteinDistance = new LevenshteinDistance(distance);
        ArrayList searchResultItemList = new ArrayList();
        int length = searchkey.length();
        SubstringPosition defaultPosition = new SubstringPosition(0, length - 1);
        for (Map.Entry<String, E> couple : this.valuesMap.entrySet()) {
            E value;
            String currentkey = couple.getKey();
            int dist = levenshteinDistance.apply(searchkey, currentkey);
            if (!matches && dist == -1 && currentkey.length() > length && (dist = levenshteinDistance.apply(searchkey, currentkey.substring(0, length)).intValue()) == -1) {
                dist = levenshteinDistance.apply(searchkey, currentkey.substring(0, length + 1));
            }
            if (dist == -1 || !valueFilter.acceptValue(value = couple.getValue())) continue;
            InternalSearchResultUnit searchResultItem = new InternalSearchResultUnit(value, currentkey, defaultPosition);
            searchResultItemList.add(searchResultItem);
        }
        return searchResultItemList;
    }

    private List<SearchResultUnit<E>> getOneDistanceNeighboursStartingWith(String s, ValueFilter valueFilter, boolean matches) {
        String searchkey = CollationUnit.collate(s, this.collator);
        ArrayList searchResultItemList = new ArrayList();
        int length = searchkey.length();
        SubstringPosition defaultPosition = new SubstringPosition(0, length - 1);
        for (Map.Entry<String, E> couple : this.valuesMap.entrySet()) {
            E value;
            String currentkey = couple.getKey();
            boolean done = OneDistance.apply(searchkey, currentkey);
            if (!(matches || done || currentkey.length() <= length || (done = OneDistance.apply(searchkey, currentkey.substring(0, length))))) {
                done = OneDistance.apply(searchkey, currentkey.substring(0, length + 1));
            }
            if (!done || !valueFilter.acceptValue(value = couple.getValue())) continue;
            InternalSearchResultUnit searchResultItem = new InternalSearchResultUnit(value, currentkey, defaultPosition);
            searchResultItemList.add(searchResultItem);
        }
        return searchResultItemList;
    }

    private static class InternalSearchResultUnit<E>
    implements SearchResultUnit<E> {
        private final E value;
        private final SubstringPosition collatedSearchTextPosition;
        private final String collatedKey;

        private InternalSearchResultUnit(E value, String collatedKey, SubstringPosition collatedSearchTextPosition) {
            this.value = value;
            this.collatedKey = collatedKey;
            this.collatedSearchTextPosition = collatedSearchTextPosition;
        }

        @Override
        public E getValue() {
            return this.value;
        }

        @Override
        public SubstringPosition getSearchTextPositionInCollatedKey() {
            return this.collatedSearchTextPosition;
        }

        @Override
        public String getCollatedKey() {
            return this.collatedKey;
        }
    }
}

