/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.servlets.handlers;

import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.CommandMessageJsonProducer;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.request.RequestUtils;
import net.mapeadores.util.servlets.ResponseHandler;
import net.mapeadores.util.servlets.handlers.CommandMessageResponseHandler;
import net.mapeadores.util.servlets.handlers.JsonResponseHandler;
import net.mapeadores.util.servlets.handlers.SimpleResponseHandler;

public final class ResponseHandlerFactory {
    private ResponseHandlerFactory() {
    }

    public static ResponseHandler getInstance(MessageLocalisation messageLocalisation, RequestMap requestMap, CommandMessage ... commandMessages) {
        if (RequestUtils.isJsonDefined(requestMap)) {
            return ResponseHandlerFactory.getJsonInstance(messageLocalisation, requestMap, commandMessages);
        }
        return ResponseHandlerFactory.getHtmlInstance(messageLocalisation, commandMessages);
    }

    public static ResponseHandler getJsonInstance(MessageLocalisation messageLocalisation, RequestMap requestMap, CommandMessage ... commandMessages) {
        CommandMessageJsonProducer jsonProducer = new CommandMessageJsonProducer(messageLocalisation, commandMessages);
        return JsonResponseHandler.build(jsonProducer, requestMap);
    }

    public static ResponseHandler getHtmlInstance(MessageLocalisation messageLocalisation, CommandMessage ... commandMessages) {
        return new CommandMessageResponseHandler(messageLocalisation, commandMessages);
    }

    public static ResponseHandler getHtmlErrorInstance(MessageLocalisation messageLocalisation, String messageKey, Object ... messageValues) {
        return new CommandMessageResponseHandler(messageLocalisation, LogUtils.error(messageKey, messageValues));
    }

    public static ResponseHandler getTextInstance(MessageLocalisation messageLocalisation, CommandMessage ... commandMessages) {
        StringBuilder buf = new StringBuilder();
        for (CommandMessage commandMessage : commandMessages) {
            String loc = messageLocalisation.toString(commandMessage);
            if (loc == null) {
                loc = "?" + commandMessage.getMessageKey() + "?";
            }
            buf.append(loc);
            buf.append("\n");
        }
        return SimpleResponseHandler.init(buf.toString());
    }

    public static ResponseHandler getTextErrorInstance(MessageLocalisation messageLocalisation, String messageKey, Object ... messageValues) {
        return ResponseHandlerFactory.getTextInstance(messageLocalisation, LogUtils.error(messageKey, messageValues));
    }
}

