/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.servlets.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.mapeadores.util.io.DocStream;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.servlets.ResponseHandler;

public class DocStreamResponseHandler
implements ResponseHandler {
    private final DocStream docStream;
    private String fileName = null;

    public DocStreamResponseHandler(DocStream docStream) {
        this.docStream = docStream;
    }

    public DocStreamResponseHandler(DocStream docStream, String fileName) {
        this.docStream = docStream;
        this.fileName = fileName;
    }

    @Override
    public Instant getLastModified() {
        long l = this.docStream.getLastModified();
        if (l == -1L) {
            return ResponseHandler.LASTMODIFIED_NOCACHE;
        }
        return Instant.ofEpochMilli(l);
    }

    public DocStreamResponseHandler fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @Override
    public void handleResponse(HttpServletResponse response) throws IOException {
        String contentType = this.docStream.getMimeType();
        String charset = this.docStream.getCharset();
        if (charset != null) {
            contentType = contentType + ";charset=" + charset;
        }
        response.setContentType(contentType);
        int length = this.docStream.getLength();
        if (length > -1) {
            response.setContentLength(length);
        }
        if (this.fileName != null) {
            response.setHeader("Content-Disposition", "attachment; filename=" + this.fileName);
        }
        try (InputStream is = this.docStream.getInputStream();
             ServletOutputStream os = response.getOutputStream();){
            IOUtils.copy(is, (OutputStream)os);
        }
    }

    public static DocStreamResponseHandler init(DocStream docStream) {
        return new DocStreamResponseHandler(docStream);
    }
}

