/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.money;

import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.money.MoneyUtils;
import net.mapeadores.util.primitives.Decimal;

public class MoneyLong {
    private MoneyLong() {
    }

    public static long toMoneyLong(Decimal decimal, int fractionDigits) {
        int multiplicator = MoneyUtils.toMultiplicator(fractionDigits);
        long lg = decimal.getPartieEntiere() * (long)multiplicator;
        int partieDecimale = decimal.getPartieDecimale();
        if (partieDecimale == 0) {
            return lg;
        }
        byte zeroLength = decimal.getZeroLength();
        if (zeroLength > fractionDigits) {
            return lg;
        }
        boolean neg = false;
        if (lg < 0L) {
            lg = -lg;
            neg = true;
        }
        if (partieDecimale < 0) {
            partieDecimale = -partieDecimale;
            neg = true;
        }
        lg += (long)MoneyLong.getDecimalPart(zeroLength, partieDecimale, fractionDigits);
        if (neg) {
            lg = -lg;
        }
        return lg;
    }

    public static Decimal toDecimal(long l, int fractionDigits, boolean avoidDecimal) {
        int multiplicator = MoneyUtils.toMultiplicator(fractionDigits);
        long partieEntiere = l / (long)multiplicator;
        int partieDecimale = (int)(l % (long)multiplicator);
        byte zeroLength = 0;
        if (partieDecimale == 0) {
            if (!avoidDecimal) {
                zeroLength = (byte)fractionDigits;
            }
        } else if (Math.abs(partieDecimale) < multiplicator) {
            String s = String.valueOf(Math.abs(partieDecimale));
            zeroLength = (byte)(fractionDigits - s.length());
        }
        return new Decimal(partieEntiere, zeroLength, partieDecimale);
    }

    public static String toString(long moneyLong, int fractionDigits) {
        int i;
        String s;
        int longLength;
        StringBuilder buf = new StringBuilder();
        if (moneyLong == 0L) {
            buf.append('0');
            if (fractionDigits > 0) {
                buf.append('.');
                for (int i2 = 0; i2 < fractionDigits; ++i2) {
                    buf.append('0');
                }
            }
            return buf.toString();
        }
        if (moneyLong < 0L) {
            moneyLong = -moneyLong;
            buf.append('-');
        }
        if ((longLength = (s = Long.toString(moneyLong)).length()) <= fractionDigits) {
            buf.append('0');
        } else {
            int entierLength = longLength - fractionDigits;
            for (i = 0; i < entierLength; ++i) {
                buf.append(s.charAt(i));
            }
        }
        if (fractionDigits > 0) {
            buf.append('.');
            int depart = longLength - fractionDigits;
            if (depart < 0) {
                depart = -depart;
                for (i = 0; i < depart; ++i) {
                    buf.append('0');
                }
                depart = 0;
            }
            for (i = depart; i < longLength; ++i) {
                buf.append(s.charAt(i));
            }
        }
        return buf.toString();
    }

    public static String toString(long moneyLong, int fractionDigits, char decimalSeparator, char groupingSeparator, boolean avoidDecimal) {
        int i;
        String s;
        int longLength;
        StringBuilder buf = new StringBuilder();
        if (moneyLong == 0L) {
            buf.append('0');
            if (!avoidDecimal && fractionDigits > 0) {
                buf.append(decimalSeparator);
                for (int i2 = 0; i2 < fractionDigits; ++i2) {
                    buf.append('0');
                }
            }
            return buf.toString();
        }
        if (moneyLong < 0L) {
            moneyLong = -moneyLong;
            buf.append("- ");
        }
        if ((longLength = (s = Long.toString(moneyLong)).length()) <= fractionDigits) {
            buf.append('0');
        } else {
            int entierLength = longLength - fractionDigits;
            if (entierLength <= 3) {
                for (int i3 = 0; i3 < entierLength; ++i3) {
                    buf.append(s.charAt(i3));
                }
            } else {
                int reste = entierLength % 3;
                if (reste > 0) {
                    buf.append(s.charAt(0));
                    if (reste > 1) {
                        buf.append(s.charAt(1));
                    }
                    buf.append(groupingSeparator);
                }
                int p = 0;
                for (i = reste; i < entierLength; ++i) {
                    buf.append(s.charAt(i));
                    if (++p != 3) continue;
                    if (i < entierLength - 1) {
                        buf.append(groupingSeparator);
                    }
                    p = 0;
                }
            }
        }
        if (fractionDigits > 0) {
            int i4;
            boolean append = true;
            int depart = longLength - fractionDigits;
            if (depart < 0) {
                depart = -depart;
                buf.append(decimalSeparator);
                for (i4 = 0; i4 < depart; ++i4) {
                    buf.append('0');
                }
                depart = 0;
            } else {
                if (avoidDecimal) {
                    boolean withDecimal = false;
                    for (i = depart; i < longLength; ++i) {
                        if (s.charAt(i) == '0') continue;
                        withDecimal = true;
                        break;
                    }
                    if (!withDecimal) {
                        append = false;
                    }
                }
                if (append) {
                    buf.append(decimalSeparator);
                }
            }
            if (append) {
                for (i4 = depart; i4 < longLength; ++i4) {
                    buf.append(s.charAt(i4));
                }
            }
        }
        return buf.toString();
    }

    private static int getDecimalPart(byte zeroLength, int partieDecimale, int totalLength) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < zeroLength; ++i) {
            buf.append('0');
            --totalLength;
        }
        String s = String.valueOf(partieDecimale);
        int decimalLength = s.length();
        int min = Math.min(decimalLength, totalLength);
        for (int i = 0; i < min; ++i) {
            buf.append(s.charAt(i));
        }
        int chiffrearrondi = 0;
        if (min < totalLength) {
            for (int i = min; i < totalLength; ++i) {
                buf.append('0');
            }
        } else if (min < decimalLength) {
            chiffrearrondi = s.charAt(min) - 48;
        }
        try {
            int result = 0;
            if (buf.length() > 0) {
                result = Integer.parseInt(buf.toString());
            }
            if (chiffrearrondi >= 5) {
                ++result;
            }
            return result;
        }
        catch (NumberFormatException nfe) {
            throw new ShouldNotOccurException();
        }
    }
}

