/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.money;

import java.text.ParseException;
import java.util.Currency;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.mapeadores.util.annotation.Nullable;

public final class ExtendedCurrency
implements Comparable<ExtendedCurrency> {
    private static final ConcurrentMap<String, ExtendedCurrency> internMap = new ConcurrentHashMap<String, ExtendedCurrency>();
    private final String code;
    private final String symbol;
    private final int fractionDigits;
    private final Currency currency;
    private final boolean symbolBefore;

    private ExtendedCurrency(String code, int fractionDigits, boolean symbolBefore, String symbol) {
        if (fractionDigits < 0) {
            throw new IllegalArgumentException("fractionDigits < 0");
        }
        this.code = code;
        this.fractionDigits = fractionDigits;
        this.currency = null;
        this.symbolBefore = symbolBefore;
        this.symbol = symbol;
    }

    private ExtendedCurrency(Currency currency, String symbol) {
        int defaulFractionDigits = currency.getDefaultFractionDigits();
        if (defaulFractionDigits < 0) {
            defaulFractionDigits = 0;
        }
        this.code = currency.getCurrencyCode();
        this.fractionDigits = defaulFractionDigits;
        this.currency = currency;
        this.symbolBefore = ExtendedCurrency.isSymbolBefore(currency.getCurrencyCode());
        this.symbol = symbol;
    }

    public String getCurrencyCode() {
        return this.code;
    }

    public int getDefaultFractionDigits() {
        return this.fractionDigits;
    }

    @Nullable
    public Currency getCurrency() {
        return this.currency;
    }

    public String getSymbol() {
        if (this.symbol != null) {
            return this.symbol;
        }
        if (this.currency != null) {
            return this.currency.getSymbol();
        }
        return this.code;
    }

    public boolean isSymbolBefore() {
        return this.symbolBefore;
    }

    public int hashCode() {
        return this.code.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        ExtendedCurrency otherCurrency = (ExtendedCurrency)other;
        return otherCurrency.code.equals(this.code);
    }

    public String toString() {
        return this.code;
    }

    @Override
    public int compareTo(ExtendedCurrency other) {
        return this.code.compareTo(other.code);
    }

    public static ExtendedCurrency parse(String currencyCode) throws ParseException {
        ExtendedCurrency instance = (ExtendedCurrency)internMap.get(currencyCode);
        if (instance != null) {
            return instance;
        }
        try {
            Currency currency = Currency.getInstance(currencyCode);
            instance = new ExtendedCurrency(currency, null);
        }
        catch (IllegalArgumentException iae) {
            ExtendedCurrency.checkCode(currencyCode);
            instance = new ExtendedCurrency(currencyCode, 2, false, null);
        }
        ExtendedCurrency previous = internMap.putIfAbsent(currencyCode, instance);
        return previous != null ? previous : instance;
    }

    private static void init(String symbol, String code, boolean symbolFix) {
        try {
            Currency currency = Currency.getInstance(code);
            ExtendedCurrency instance = symbolFix ? new ExtendedCurrency(currency, symbol) : new ExtendedCurrency(currency, null);
            internMap.putIfAbsent(code, instance);
            internMap.putIfAbsent(symbol, instance);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static void checkCode(String code) throws ParseException {
        int length = code.length();
        if (length != 3) {
            throw new ParseException("length != 3", 0);
        }
        for (int i = 0; i < 3; ++i) {
            char carac = code.charAt(i);
            if (carac >= 'A' && carac <= 'Z') continue;
            throw new ParseException("Invalid character: " + carac, i);
        }
    }

    private static void init(String code, int fractionDigits, boolean symbolBefore, String symbol) {
        ExtendedCurrency instance = new ExtendedCurrency(code, fractionDigits, symbolBefore, symbol);
        internMap.putIfAbsent(code, instance);
    }

    private static boolean isSymbolBefore(String code) {
        switch (code) {
            case "USD": 
            case "GBP": {
                return true;
            }
        }
        return false;
    }

    static {
        ExtendedCurrency.init("\u20ac", "EUR", true);
        ExtendedCurrency.init("$", "USD", false);
        ExtendedCurrency.init("\u00a5", "JPY", false);
        ExtendedCurrency.init("\u00a3", "GBP", false);
        ExtendedCurrency.init("CFA", 0, false, null);
    }
}

