/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.logicaloperation;

import java.util.AbstractList;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.logicaloperation.Operand;
import net.mapeadores.util.logicaloperation.SimpleOperand;
import net.mapeadores.util.logicaloperation.SubOperand;

public final class LogicalOperationUtils {
    private LogicalOperationUtils() {
    }

    public static SubOperand toSubOperand(Operand[] array, short operator) {
        if (array.length < 2) {
            throw new IllegalArgumentException("array.length < 2");
        }
        return new ArraySubOperand(array, operator);
    }

    public static SimpleOperand toSimpleOperand(boolean acceptMode, String operandString, String scope, String content) {
        return new InternalSimpleOperand(acceptMode, operandString, scope, content);
    }

    public static String toInformatiqueString(Operand operand) {
        StringBuilder buf = new StringBuilder();
        LogicalOperationUtils.appendInformatiqueOperand(buf, operand, true);
        return buf.toString();
    }

    private static void appendInformatiqueOperand(StringBuilder buf, Operand operand, boolean root) {
        if (operand instanceof SimpleOperand) {
            SimpleOperand simpleOperand = (SimpleOperand)operand;
            if (!simpleOperand.isAcceptMode()) {
                buf.append('!');
            }
            String operandString = ((SimpleOperand)operand).getOperandString();
            int length = operandString.length();
            for (int i = 0; i < length; ++i) {
                char carac = operandString.charAt(i);
                switch (carac) {
                    case '&': 
                    case '(': 
                    case ')': 
                    case '\\': 
                    case '|': {
                        buf.append('\\');
                    }
                }
                buf.append(carac);
            }
        } else if (operand instanceof SubOperand) {
            SubOperand subOperand = (SubOperand)operand;
            String separator = LogicalOperationUtils.getSeparator(subOperand.getOperator());
            if (!root) {
                buf.append('(');
            }
            int operandLength = subOperand.size();
            for (int i = 0; i < operandLength; ++i) {
                if (i > 0) {
                    buf.append(separator);
                }
                LogicalOperationUtils.appendInformatiqueOperand(buf, (Operand)subOperand.get(i), false);
            }
            if (!root) {
                buf.append(')');
            }
        } else {
            buf.append(operand.toString());
        }
    }

    public static String toEnsembleString(Operand operand) {
        StringBuilder buf = new StringBuilder();
        LogicalOperationUtils.appendEnsembleOperand(buf, operand, true);
        return buf.toString();
    }

    public static short inverseOperator(short operator) {
        if (operator == 2) {
            return 1;
        }
        return 2;
    }

    private static void appendEnsembleOperand(StringBuilder buf, Operand operand, boolean root) {
        if (operand instanceof SimpleOperand) {
            SimpleOperand simpleOperand = (SimpleOperand)operand;
            if (!simpleOperand.isAcceptMode()) {
                buf.append('\u00ac');
            }
            buf.append(((SimpleOperand)operand).getOperandString());
        } else if (operand instanceof SubOperand) {
            SubOperand subOperand = (SubOperand)operand;
            buf.append(LogicalOperationUtils.getOperator(subOperand.getOperator()));
            buf.append('(');
            int operandLength = subOperand.size();
            for (int i = 0; i < operandLength; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                LogicalOperationUtils.appendEnsembleOperand(buf, (Operand)subOperand.get(i), false);
            }
            buf.append(')');
        } else {
            String s = operand.toString();
            int length = s.length();
            if (length > 0) {
                if (s.charAt(0) == '!') {
                    buf.append('\u00ac');
                    buf.append(s, 1, length);
                } else {
                    buf.append(s);
                }
            }
        }
    }

    public static String getSeparator(short operator) {
        switch (operator) {
            case 1: {
                return " && ";
            }
            case 2: {
                return " || ";
            }
        }
        throw new SwitchException("Unknown operator = " + operator);
    }

    public static String getOperator(short operator) {
        switch (operator) {
            case 1: {
                return "\u22c2";
            }
            case 2: {
                return "\u22c3";
            }
        }
        throw new SwitchException("Unknown operator = " + operator);
    }

    private static class ArraySubOperand
    extends AbstractList<Operand>
    implements SubOperand {
        private final Operand[] array;
        private final short operator;

        private ArraySubOperand(Operand[] array, short operator) {
            this.array = array;
            this.operator = operator;
        }

        @Override
        public short getOperator() {
            return this.operator;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Operand get(int i) {
            return this.array[i];
        }
    }

    private static class InternalSimpleOperand
    implements SimpleOperand {
        private final boolean acceptMode;
        private final String operandString;
        private final String scope;
        private final String body;

        private InternalSimpleOperand(boolean acceptMode, String operandString, String scope, String body) {
            this.acceptMode = acceptMode;
            this.operandString = operandString;
            this.scope = scope;
            this.body = body;
        }

        @Override
        public boolean isAcceptMode() {
            return this.acceptMode;
        }

        @Override
        public String getOperandString() {
            return this.operandString;
        }

        @Override
        public String getScope() {
            return this.scope;
        }

        @Override
        public String getBody() {
            return this.body;
        }
    }
}

